/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.cms;

import org.bouncycastleDJ.asn1.DEROctetString;
import org.bouncycastleDJ.asn1.cms.KEKIdentifier;
import org.bouncycastleDJ.asn1.cms.KEKRecipientInfo;
import org.bouncycastleDJ.asn1.cms.RecipientInfo;
import org.bouncycastleDJ.cms.CMSException;
import org.bouncycastleDJ.cms.RecipientInfoGenerator;
import org.bouncycastleDJ.operator.GenericKey;
import org.bouncycastleDJ.operator.OperatorException;
import org.bouncycastleDJ.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kEKIdentifier, SymmetricKeyWrapper symmetricKeyWrapper) {
        this.kekIdentifier = kEKIdentifier;
        this.wrapper = symmetricKeyWrapper;
    }

    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        try {
            DEROctetString dEROctetString = new DEROctetString(this.wrapper.generateWrappedKey(genericKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), dEROctetString));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
    }
}

