/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.cert.jcajce;

import java.security.Provider;
import java.security.cert.CertificateException;
import org.bouncycastleDJ.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastleDJ.cert.X509CertificateHolder;
import org.bouncycastleDJ.cert.X509ContentVerifierProviderBuilder;
import org.bouncycastleDJ.operator.ContentVerifierProvider;
import org.bouncycastleDJ.operator.OperatorCreationException;
import org.bouncycastleDJ.operator.jcajce.JcaContentVerifierProviderBuilder;

public class JcaX509ContentVerifierProviderBuilder
implements X509ContentVerifierProviderBuilder {
    private JcaContentVerifierProviderBuilder builder = new JcaContentVerifierProviderBuilder();

    public JcaX509ContentVerifierProviderBuilder setProvider(Provider provider) {
        this.builder.setProvider(provider);
        return this;
    }

    public JcaX509ContentVerifierProviderBuilder setProvider(String string) {
        this.builder.setProvider(string);
        return this;
    }

    public ContentVerifierProvider build(SubjectPublicKeyInfo subjectPublicKeyInfo) throws OperatorCreationException {
        return this.builder.build(subjectPublicKeyInfo);
    }

    public ContentVerifierProvider build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        try {
            return this.builder.build(x509CertificateHolder);
        }
        catch (CertificateException certificateException) {
            throw new OperatorCreationException("Unable to process certificate: " + certificateException.getMessage(), certificateException);
        }
    }
}

