/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.cert.crmf.bc;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastleDJ.asn1.crmf.EncryptedValue;
import org.bouncycastleDJ.cert.crmf.CRMFException;
import org.bouncycastleDJ.cert.crmf.EncryptedValueBuilder;
import org.bouncycastleDJ.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastleDJ.crypto.params.AsymmetricKeyParameter;
import org.bouncycastleDJ.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastleDJ.operator.KeyWrapper;
import org.bouncycastleDJ.operator.OutputEncryptor;

public class BcEncryptedValueBuilder
extends EncryptedValueBuilder {
    public BcEncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        super(keyWrapper, outputEncryptor);
    }

    public EncryptedValue build(X509Certificate x509Certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(x509Certificate));
    }

    public EncryptedValue build(AsymmetricKeyParameter asymmetricKeyParameter) throws CRMFException, IOException {
        return this.build(PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter));
    }
}

