/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastleDJ.asn1.cmp.PBMParameter;
import org.bouncycastleDJ.asn1.crmf.PKMACValue;
import org.bouncycastleDJ.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastleDJ.cert.crmf.CRMFException;
import org.bouncycastleDJ.cert.crmf.PKMACBuilder;
import org.bouncycastleDJ.operator.MacCalculator;
import org.bouncycastleDJ.util.Arrays;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public boolean isValid(PKMACValue pKMACValue, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(pKMACValue.getAlgId().getParameters()));
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return Arrays.constantTimeAreEqual(macCalculator.getMac(), pKMACValue.getValue().getBytes());
    }
}

