/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastleDJ.asn1.DERBitString;
import org.bouncycastleDJ.asn1.crmf.PKMACValue;
import org.bouncycastleDJ.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastleDJ.cert.crmf.CRMFException;
import org.bouncycastleDJ.cert.crmf.PKMACBuilder;
import org.bouncycastleDJ.operator.MacCalculator;

class PKMACValueGenerator {
    private PKMACBuilder builder;

    public PKMACValueGenerator(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public PKMACValue generate(char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return new PKMACValue(macCalculator.getAlgorithmIdentifier(), new DERBitString(macCalculator.getMac()));
    }
}

