/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastleDJ.cert.cmp;

import java.math.BigInteger;
import org.bouncycastleDJ.asn1.cmp.CertStatus;
import org.bouncycastleDJ.asn1.cmp.PKIStatusInfo;
import org.bouncycastleDJ.asn1.x509.AlgorithmIdentifier;
import org.bouncycastleDJ.cert.X509CertificateHolder;
import org.bouncycastleDJ.cert.cmp.CMPException;
import org.bouncycastleDJ.cert.cmp.CMPUtil;
import org.bouncycastleDJ.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastleDJ.operator.DigestCalculator;
import org.bouncycastleDJ.operator.DigestCalculatorProvider;
import org.bouncycastleDJ.operator.OperatorCreationException;
import org.bouncycastleDJ.util.Arrays;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder x509CertificateHolder, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        DigestCalculator digestCalculator;
        AlgorithmIdentifier algorithmIdentifier = this.digestAlgFinder.find(x509CertificateHolder.toASN1Structure().getSignatureAlgorithm());
        if (algorithmIdentifier == null) {
            throw new CMPException("cannot find algorithm for digest from signature");
        }
        try {
            digestCalculator = digestCalculatorProvider.get(algorithmIdentifier);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMPException("unable to create digester: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        CMPUtil.derEncodeToStream(x509CertificateHolder.toASN1Structure(), digestCalculator.getOutputStream());
        return Arrays.areEqual(this.certStatus.getCertHash().getOctets(), digestCalculator.getDigest());
    }
}

