/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.bouncycastleDJ.cert.X509CertificateHolder;
import org.bouncycastleDJ.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastleDJ.cms.CMSException;
import org.bouncycastleDJ.cms.CMSSignedData;
import org.bouncycastleDJ.cms.SignerInformation;
import org.bouncycastleDJ.cms.SignerInformationStore;
import org.bouncycastleDJ.crypto.CipherParameters;
import org.bouncycastleDJ.crypto.params.ECDomainParameters;
import org.bouncycastleDJ.crypto.params.ECPublicKeyParameters;
import org.bouncycastleDJ.crypto.params.ParametersWithID;
import org.bouncycastleDJ.crypto.signers.SM2Signer;
import org.bouncycastleDJ.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastleDJ.jce.interfaces.ECPublicKey;
import org.bouncycastleDJ.jce.provider.BouncyCastleProvider;
import org.bouncycastleDJ.jce.spec.ECParameterSpec;
import org.bouncycastleDJ.jce.spec.ECPublicKeySpec;
import org.bouncycastleDJ.math.ec.ECPoint;
import org.bouncycastleDJ.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastleDJ.util.CollectionStore;

public class SM2Util {
    private static final SM2P256V1Curve CURVE = new SM2P256V1Curve();
    private static final BigInteger SM2_ECC_N = CURVE.getOrder();
    private static final BigInteger SM2_ECC_H = CURVE.getCofactor();
    private static final BigInteger SM2_ECC_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static final BigInteger SM2_ECC_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static final ECPoint G_POINT = CURVE.createPoint(SM2_ECC_GX, SM2_ECC_GY);

    private static BCECPublicKey getBCECPublicKey(X509Certificate sm2Cert) {
        ECPublicKey pubKey = (ECPublicKey)sm2Cert.getPublicKey();
        ECPoint q = pubKey.getQ();
        ECParameterSpec parameterSpec = new ECParameterSpec(CURVE, G_POINT, SM2_ECC_N, SM2_ECC_H);
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(q, parameterSpec);
        return new BCECPublicKey(pubKey.getAlgorithm(), pubKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    private static boolean verify(BCECPublicKey pubKey, byte[] withId, byte[] srcData, byte[] sign) {
        ECPublicKeyParameters pubKeyParameters = SM2Util.convertPublicKeyToParameters(pubKey);
        return SM2Util.verify(pubKeyParameters, withId, srcData, sign);
    }

    private static ECPublicKeyParameters convertPublicKeyToParameters(BCECPublicKey ecPubKey) {
        ECParameterSpec parameterSpec = ecPubKey.getParameters();
        ECDomainParameters domainParameters = new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
        return new ECPublicKeyParameters(ecPubKey.getQ(), domainParameters);
    }

    private static boolean verify(ECPublicKeyParameters pubKeyParameters, byte[] withId, byte[] srcData, byte[] sign) {
        SM2Signer signer = new SM2Signer();
        CipherParameters param = withId != null ? new ParametersWithID(pubKeyParameters, withId) : pubKeyParameters;
        signer.init(false, param);
        signer.update(srcData, 0, srcData.length);
        return signer.verifySignature(sign);
    }

    public static boolean verifyP7(byte[] srcData, byte[] signedData) throws CertificateException, CMSException, IOException {
        return SM2Util.verifyP7(null, srcData, signedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyP7(byte[] withId, byte[] srcData, byte[] signedData) throws CMSException, IOException, CertificateException {
        try (ByteArrayInputStream inStream = null;){
            inStream = new ByteArrayInputStream(signedData);
            CMSSignedData cmsSingedData = new CMSSignedData(inStream);
            byte[] signed = null;
            X509Certificate cert = null;
            CollectionStore x509s = (CollectionStore)cmsSingedData.getCertificates();
            X509CertificateHolder holder = (X509CertificateHolder)x509s.iterator().next();
            cert = new JcaX509CertificateConverter().setProvider(new BouncyCastleProvider()).getCertificate(holder);
            SignerInformationStore signers = cmsSingedData.getSignerInfos();
            Collection<SignerInformation> c = signers.getSigners();
            for (SignerInformation signer : c) {
                System.out.println("\u6458\u8981\u7b97\u6cd5 =" + signer.getDigestAlgOID());
                System.out.println("\u7b97\u6cd5 =" + signer.getEncryptionAlgOID());
                signed = signer.getSignature();
            }
            BCECPublicKey pubKey = SM2Util.getBCECPublicKey(cert);
            boolean bl = SM2Util.verify(pubKey, withId, srcData, signed);
            return bl;
        }
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

