/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.util;

import com.dianju.cz.base.DJCommonResponseException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastleDJ.jce.provider.BouncyCastleProvider;
import org.bouncycastleDJ.util.encoders.Base64;

public class CertVerifyUtil {
    public static final BouncyCastleProvider BC_PROVIDER = new BouncyCastleProvider();
    private static final CertificateFactory CF;

    public static void verifyCertificateChain(List<X509Certificate> certificates, X509Certificate waitCheck) {
        for (X509Certificate x509 : certificates) {
            Principal principalSubject = x509.getSubjectDN();
            if (!waitCheck.getIssuerDN().equals(principalSubject)) continue;
            try {
                PublicKey publickey = x509.getPublicKey();
                waitCheck.verify(publickey);
                return;
            }
            catch (Exception e) {
                throw new DJCommonResponseException("\u53ef\u4fe1\u8bc1\u4e66\u94fe\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u901a\u8fc7!");
            }
        }
        throw new DJCommonResponseException("\u7b7e\u7ae0\u8bc1\u4e66\u9881\u53d1\u8005\u4e0d\u5728\u53ef\u4fe1\u8bc1\u4e66\u94fe\u5217\u8868\u4e2d,\u9881\u53d1\u8005:" + waitCheck.getIssuerDN());
    }

    public static X509Certificate parsCert(String cert) {
        X509Certificate x509Certificate = null;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.decode(cert));){
            x509Certificate = (X509Certificate)CF.generateCertificate(inputStream);
        }
        catch (IOException | CertificateException e) {
            e.printStackTrace();
        }
        return x509Certificate;
    }

    public static List<X509Certificate> parseUnknownFormatCertFile(File certFile, boolean checkDate) throws IOException {
        List<X509Certificate> list;
        if (!certFile.getName().endsWith(".cer") && !certFile.getName().endsWith(".p7b")) {
            System.err.println("\u672a\u77e5\u7684\u8bc1\u4e66\u6587\u4ef6\u683c\u5f0f:" + certFile.getName());
            return new ArrayList<X509Certificate>();
        }
        FileInputStream fis = new FileInputStream(certFile);
        try {
            list = CertVerifyUtil.parsCertFile(fis, certFile.getName(), checkDate);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (CertificateException e) {
                List<X509Certificate> list2;
                byte[] certData = Base64.decode(new String(Files.readAllBytes(certFile.toPath())));
                ByteArrayInputStream bis = new ByteArrayInputStream(certData);
                try {
                    list2 = CertVerifyUtil.parsCertFile(bis, certFile.getName(), checkDate);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            bis.close();
                        }
                        catch (Throwable throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    catch (CertificateException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                bis.close();
                return list2;
            }
        }
        fis.close();
        return list;
    }

    public static List<X509Certificate> parsCertFile(InputStream fis, String fileName, boolean checkDate) throws CertificateException {
        Date now = new Date();
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        if (fileName.endsWith(".cer")) {
            X509Certificate cert = (X509Certificate)CF.generateCertificate(fis);
            if (checkDate) {
                try {
                    cert.checkValidity(now);
                }
                catch (GeneralSecurityException e) {
                    throw new DJCommonResponseException("\u6839\u8bc1\u4e66\u65e0\u6548:" + cert.getSubjectDN() + ":" + cert.getNotBefore() + "-" + cert.getNotAfter());
                }
            }
            certificates.add(cert);
        } else if (fileName.endsWith(".p7b")) {
            certificates = (List)CF.generateCertificates(fis);
            if (checkDate) {
                certificates.forEach(x509 -> {
                    try {
                        x509.checkValidity(now);
                    }
                    catch (CertificateExpiredException | CertificateNotYetValidException e) {
                        throw new DJCommonResponseException("\u6839\u8bc1\u4e66\u65e0\u6548:" + x509.getSubjectDN() + ":" + x509.getNotBefore() + "-" + x509.getNotAfter());
                    }
                });
            }
        } else {
            System.err.println("\u672a\u77e5\u7684\u8bc1\u4e66\u6587\u4ef6\u683c\u5f0f:" + fileName);
        }
        return certificates;
    }

    static {
        try {
            CF = CertificateFactory.getInstance("X.509", BC_PROVIDER);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

