/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.pl.xbrl.util;

import com.dianju.cz.pl.xbrl.model.Context;
import com.dianju.cz.pl.xbrl.model.ContextDim;
import com.dianju.cz.pl.xbrl.model.TypedMember;
import com.dianju.cz.pl.xbrl.object.ContextDimComp;
import java.util.Collections;
import java.util.List;

public class ContextUtil {
    public static String createContextId(Context context) {
        if (context == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("As_Of_");
        if (context.getPeriodType() == 0) {
            sb.append(context.getInstDate().replaceAll("-", "_"));
        } else {
            sb.append(context.getStartDate().replaceAll("-", "_") + "_" + context.getEndDate().replaceAll("-", "_"));
        }
        List<ContextDim> contextDimList = context.getScenarioList();
        if (contextDimList != null) {
            Collections.sort(contextDimList, new ContextDimComp());
            for (ContextDim dim : contextDimList) {
                sb.append("_");
                String dimId = dim.getDimension();
                dimId = ContextUtil.getElementName(dimId);
                if (dim instanceof TypedMember) {
                    TypedMember tMember = (TypedMember)dim;
                    sb.append(dimId + "_" + tMember.getMemberValue());
                    continue;
                }
                sb.append(dimId + "_" + ContextUtil.getElementName(dim.getMember()));
            }
        }
        return sb.toString();
    }

    private static String getElementName(String elementInfo) {
        if (elementInfo == null) {
            return elementInfo;
        }
        String ret = elementInfo;
        int pos = elementInfo.indexOf(":");
        if (pos >= 0) {
            ret = elementInfo.substring(pos + 1, elementInfo.length());
        }
        return ret;
    }
}

