/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.pl.xbrl.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dianju.cz.pl.xbrl.config.XbrlJsonConfigMgr;
import com.dianju.cz.pl.xbrl.config.model.JsonConfigItem;
import com.dianju.cz.pl.xbrl.config.model.XbrlJsonConfig;
import com.dianju.cz.pl.xbrl.reader.XbrlReader;
import com.dianju.cz.pl.xbrl.reader.impl.BaseXbrlReader;
import com.dianju.cz.pl.xbrl.util.StringUtil;
import java.util.List;
import java.util.logging.Logger;

public class XbrlToJson {
    private static Logger log = Logger.getLogger(XbrlToJson.class.toString());
    private XbrlReader xbrlReader = new BaseXbrlReader();

    public JSONObject convertXbrlJsonData(String xbrlXml, String configId) {
        try {
            JSONObject jsonObject = this.xbrlReader.readXbrlDataWithXml(xbrlXml);
            return this.convertXbrlJsonData(jsonObject, configId);
        }
        catch (Exception e) {
            log.info(e.toString());
            return null;
        }
    }

    public JSONObject convertXbrlJsonData(JSONObject xbrlJsonData, String configId) {
        if (xbrlJsonData == null) {
            return null;
        }
        if (StringUtil.isBlank(configId)) {
            return null;
        }
        XbrlJsonConfig configObject = XbrlJsonConfigMgr.getInstance().getConfigObject(configId);
        if (configObject == null) {
            log.info("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\uff0c\u914d\u7f6e\u7f16\u53f7[" + configId + "]");
            return null;
        }
        JsonConfigItem jsonConfigItem = configObject.getJsonConfig();
        if (jsonConfigItem == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(true);
        this.buildJsonObject(jsonConfigItem, xbrlJsonData, jsonObject);
        return jsonObject;
    }

    private void buildJsonObject(JsonConfigItem jsonConfigItem, JSONObject xbrlJsonData, JSONObject parentJsonObject) {
        if (jsonConfigItem == null || xbrlJsonData == null) {
            return;
        }
        List<JsonConfigItem> childList = jsonConfigItem.getChildList();
        if (childList == null || childList.size() == 0) {
            return;
        }
        for (JsonConfigItem item : childList) {
            Object obj;
            String fieldName = item.getFieldName();
            String elementName = item.getElementNsName() + ":" + item.getElementName();
            String elementType = item.getElementValueType();
            List<JsonConfigItem> nextChildList = item.getChildList();
            if ("tuple".equals(elementType)) {
                obj = xbrlJsonData.get(elementName);
                if (obj == null || !(obj instanceof JSONArray)) continue;
                JSONArray objList = (JSONArray)obj;
                JSONArray tupleList = new JSONArray();
                parentJsonObject.put(fieldName, (Object)tupleList);
                for (Object tupleItem : objList) {
                    JSONObject parentNode = new JSONObject(true);
                    tupleList.add(parentNode);
                    this.buildJsonObject(item, (JSONObject)tupleItem, parentNode);
                }
                continue;
            }
            if (nextChildList != null && nextChildList.size() > 0) {
                JSONObject parentNode = new JSONObject(true);
                parentJsonObject.put(fieldName, (Object)parentNode);
                this.buildJsonObject(item, xbrlJsonData, parentNode);
                continue;
            }
            obj = xbrlJsonData.get(elementName);
            if (obj == null) continue;
            parentJsonObject.put(fieldName, obj);
        }
    }
}

