/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.api;

import com.alibaba.fastjson.JSONObject;
import com.dianju.cz.api.XbrlUtil;
import com.dianju.cz.base.DJCommonResponseException;
import com.dianju.cz.base.ExceptionEnum;
import com.dianju.cz.base.Response;
import com.dianju.cz.util.CertVerifyUtil;
import com.dianju.cz.util.SM2Util;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bouncycastleDJ.util.encoders.Base64;
import srvSeal.SrvSealUtil;

public class EVoucherFileUtil {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toUpperCase().contains("WINDOWS");
    private static SrvSealUtil srvSealUtil;
    private static final Map<String, String> ISSUER_MAP;
    private static boolean checkCert;

    private EVoucherFileUtil() {
    }

    public static void setSrvSealUtil(String soPath) {
        srvSealUtil = SrvSealUtil.installSrvSealUtil(soPath);
        EVoucherFileUtil.init();
    }

    public static void initCertChainCache(String certChainDir) throws IOException {
        ISSUER_MAP.clear();
        System.out.println("\u521d\u59cb\u5316\u8bc1\u4e66\u94fe\u6587\u4ef6\u7f13\u5b58:" + certChainDir);
        File certChainPath = Paths.get(certChainDir, new String[0]).toFile();
        File[] certs = certChainPath.listFiles();
        if (null == certs) {
            System.err.println("\u8bc1\u4e66\u94fe\u76ee\u5f55\u4e0b\u4e0d\u5b58\u5728\u8bc1\u4e66\u6587\u4ef6:path=" + certChainDir);
            return;
        }
        System.out.println("\u521d\u59cb\u5316\u8bc1\u4e66\u94fe\u6587\u4ef6\u7f13\u5b58:\u8def\u5f84=" + certChainDir + ",\u6570\u91cf=" + certs.length);
        for (File cert : certs) {
            if (!cert.getName().endsWith(".cer") && !cert.getName().endsWith(".p7b")) {
                System.err.println("\u672a\u77e5\u7684\u8bc1\u4e66\u6587\u4ef6\u683c\u5f0f:" + cert.getName());
                continue;
            }
            System.out.println("\u89e3\u6790\u8bc1\u4e66\u6587\u4ef6:" + cert.getName());
            List<X509Certificate> certificates = CertVerifyUtil.parseUnknownFormatCertFile(cert, false);
            certificates.stream().map(x509 -> x509.getSubjectDN().getName()).forEach(dn -> {
                EVoucherFileUtil.verifyCertChainCache(cert, dn);
                ISSUER_MAP.put((String)dn, cert.getAbsolutePath());
            });
        }
        checkCert = true;
        System.out.println("\u521d\u59cb\u5316\u8bc1\u4e66\u94fe\u6587\u4ef6\u7f13\u5b58\u5b8c\u6210!");
    }

    private static void verifyCertChainCache(File cert, String dn) {
        if (ISSUER_MAP.containsKey(dn)) {
            System.err.println("\u8bc1\u4e66\u94feDN=" + dn + "\u5bf9\u5e94\u591a\u4e2a\u6587\u4ef6,[" + ISSUER_MAP.get(dn) + "],[" + cert.getAbsolutePath() + "]");
            throw new DJCommonResponseException("\u8bc1\u4e66\u94feDN=" + dn + "\u5bf9\u5e94\u591a\u4e2a\u6587\u4ef6,[" + ISSUER_MAP.get(dn) + "],[" + cert.getName() + "]");
        }
    }

    private static void verifyCertIsTrust(String cert) throws IOException {
        if (null == cert || "".equals(cert)) {
            System.err.println("\u7b7e\u7ae0\u8bc1\u4e66\u4e3a\u7a7a");
            return;
        }
        System.out.println("\u9a8c\u8bc1\u7b7e\u7ae0\u8bc1\u4e66\u6709\u6548\u6027");
        X509Certificate x509 = CertVerifyUtil.parsCert(cert);
        String dn = x509.getIssuerDN().getName();
        if (!ISSUER_MAP.containsKey(dn)) {
            throw new DJCommonResponseException("\u7b7e\u7ae0\u8bc1\u4e66\u9881\u53d1\u8005\u4e0d\u5728\u53ef\u4fe1\u8bc1\u4e66\u94fe\u5217\u8868\u4e2d,\u9881\u53d1\u8005:" + dn);
        }
        String certChainPath = ISSUER_MAP.get(dn);
        System.out.println("\u7b7e\u7ae0\u8bc1\u4e66\u9881\u53d1\u8005DN:" + dn + ",\u5bf9\u5e94:" + certChainPath);
        List<X509Certificate> certificates = CertVerifyUtil.parseUnknownFormatCertFile(new File(certChainPath), false);
        CertVerifyUtil.verifyCertificateChain(certificates, x509);
        System.out.println("\u9a8c\u8bc1\u7b7e\u7ae0\u8bc1\u4e66\u6709\u6548\u6027\u901a\u8fc7");
    }

    public static Response<String> getXbrlFromFile(String oriFilePath) {
        EVoucherFileUtil.init();
        try {
            return EVoucherFileUtil.getXbrlData(oriFilePath);
        }
        catch (DJCommonResponseException e) {
            return Response.of(400, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.of(1000, "\u5904\u7406\u9644\u4ef6\u53d1\u751f\u5f02\u5e38");
        }
    }

    public static Response<String> exportXbrlFromFile(String oriFilePath, String targetFilePath) {
        EVoucherFileUtil.init();
        try {
            Response<String> xbrlData = EVoucherFileUtil.getXbrlData(oriFilePath);
            if (xbrlData.getCode() != 1) {
                return xbrlData;
            }
            byte[] xmlData = xbrlData.getData().getBytes(StandardCharsets.UTF_8);
            try (BufferedOutputStream writer = new BufferedOutputStream(Files.newOutputStream(Paths.get(targetFilePath, new String[0]), new OpenOption[0]));){
                writer.write(xmlData);
            }
            catch (Exception e) {
                e.printStackTrace();
                return Response.of(1011, "\u751f\u6210\u6587\u4ef6\u5931\u8d25:" + e.getMessage());
            }
            return Response.of(1, "true");
        }
        catch (DJCommonResponseException e) {
            return Response.of(400, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.of(1000, "\u5904\u7406\u9644\u4ef6\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response<String> getXbrlData(String oriFilePath) {
        EVoucherFileUtil.filePathCheck(oriFilePath);
        int nObjId = 0;
        try {
            nObjId = EVoucherFileUtil.ocxOpenObj(oriFilePath);
            String xmlAttachList = srvSealUtil.getValueEx(nObjId, "SAVE_ATTACHMENTLIST_TO_XML", 0, "", 0, "");
            if (null != xmlAttachList && !"".equals(xmlAttachList) && !xmlAttachList.startsWith("errorcode")) {
                String xmlIdEndStr = xmlAttachList.substring(xmlAttachList.indexOf(" id=\"") + 5);
                String xmlId = xmlIdEndStr.substring(0, xmlIdEndStr.indexOf("\""));
                byte[] xmlData = srvSealUtil.getAttachData(nObjId, Integer.parseInt(xmlId));
                if (null == xmlData || xmlData.length == 0) {
                    System.out.println(oriFilePath + " \u83b7\u53d6xbrl\u6570\u636e\u4e3a\u7a7a,xmlId=" + xmlId);
                    Response<String> response = Response.of(1003, "\u6587\u4ef6\u4e2d\u83b7\u53d6\u5230\u7684xbrl\u6570\u636e\u4e3a\u7a7a");
                    return response;
                }
                Response<String> response = Response.of(1, new String(xmlData, StandardCharsets.UTF_8));
                return response;
            }
            String xmlZip = srvSealUtil.getDocProperty(nObjId, "hidexml");
            if (xmlZip == null || "".equals(xmlZip) || xmlZip.startsWith("errorcode")) {
                System.out.println(oriFilePath + " \u83b7\u53d6\u9644\u4ef6\u4e3a\u7a7a");
                Response<String> xmlId = Response.of(1002, "\u6587\u4ef6\u4e2d\u6ca1\u6709xbrl\u9644\u4ef6");
                return xmlId;
            }
            byte[] unzip = EVoucherFileUtil.unzip(xmlZip);
            Response<String> response = Response.of(1, new String(unzip, StandardCharsets.UTF_8));
            return response;
        }
        finally {
            EVoucherFileUtil.closeFile(nObjId);
        }
    }

    public static boolean verifyXmlAndSign(String zipFilePath) throws IOException {
        EVoucherFileUtil.init();
        Map<String, String> zipFiles = EVoucherFileUtil.getZipFiles(zipFilePath);
        return EVoucherFileUtil.verifyXmlAndSign(zipFiles);
    }

    public static boolean verifyXmlAndSign(byte[] zipFileBytes) {
        EVoucherFileUtil.init();
        Map<String, String> zipFiles = EVoucherFileUtil.getZipFiles(zipFileBytes);
        return EVoucherFileUtil.verifyXmlAndSign(zipFiles);
    }

    private static boolean verifyXmlAndSign(Map<String, String> zipFileMap) {
        String signedValue = "";
        String xmlData = "";
        for (Map.Entry<String, String> entry : zipFileMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.endsWith(".xml")) {
                xmlData = value;
                continue;
            }
            signedValue = value;
        }
        return EVoucherFileUtil.verifyXmlAndSign(signedValue, xmlData);
    }

    public static boolean verifyXmlAndSign(String signedValue, String xmlData) {
        boolean ret;
        EVoucherFileUtil.init();
        if (signedValue == null || "".equals(signedValue) || xmlData == null || "".equals(xmlData)) {
            System.out.println("\u53c2\u6570\u9519\u8bef");
            return false;
        }
        try {
            byte[] srcData = xmlData.getBytes();
            ret = SM2Util.verifyP7(srcData, Base64.decode(signedValue));
            System.out.println("ret:" + ret);
            if (!ret) {
                srcData = xmlData.getBytes(StandardCharsets.UTF_8);
                ret = SM2Util.verifyP7(srcData, Base64.decode(signedValue));
                System.out.println("ret2:" + ret);
                if (!ret) {
                    srcData = xmlData.getBytes("GBK");
                    ret = SM2Util.verifyP7(srcData, Base64.decode(signedValue));
                    System.out.println("ret3:" + ret);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return ret;
    }

    public static Response<String> verifyFile(String filePath) {
        EVoucherFileUtil.init();
        try {
            EVoucherFileUtil.filePathCheck(filePath);
            if (filePath.endsWith(".ofd") || filePath.endsWith(".OFD")) {
                return new Response<String>(1, EVoucherFileUtil.verifyOfd(filePath));
            }
            return new Response<String>(1, EVoucherFileUtil.verifyPdf(filePath));
        }
        catch (DJCommonResponseException e) {
            System.err.println("\u9a8c\u8bc1\u6587\u6863:" + filePath + ":" + e.getMessage());
            return Response.of(400, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.of(1000, "\u5904\u7406\u9644\u4ef6\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String verifyOfd(String filePath) throws IOException {
        int nObjId = 0;
        try {
            String[] s;
            String verifyRes;
            nObjId = EVoucherFileUtil.ocxOpenObj(filePath);
            if (IS_WINDOWS) {
                verifyRes = srvSealUtil.verify(nObjId);
            } else {
                s = new StringBuilder();
                String sealVal = srvSealUtil.getNextSeal(nObjId, "");
                while (sealVal != null && !"".equals(sealVal)) {
                    String verifyRet = srvSealUtil.verifySeal(nObjId, sealVal);
                    s.append(verifyRet);
                    sealVal = srvSealUtil.getNextSeal(nObjId, sealVal);
                }
                verifyRes = s.toString();
            }
            if (null == verifyRes || "".equals(verifyRes)) {
                throw new DJCommonResponseException("\u9a8c\u8bc1\u8fc7\u7a0b\u5f02\u5e38:\u9a8c\u8bc1\u7ed3\u679c\u4e3a\u7a7a");
            }
            s = verifyRes.split("<+");
            for (int j = 1; j < s.length; ++j) {
                String s1 = s[j].substring(s[j].indexOf("+") + 1, s[j].indexOf("/;->"));
                for (String value : s1.split("/;")) {
                    String[] node = value.split("=");
                    if (node.length != 2 || !"RetCode".equals(node[0]) || "0".equals(node[1])) continue;
                    throw new DJCommonResponseException("\u6587\u6863\u9a8c\u8bc1\u4e0d\u901a\u8fc7:" + node[1]);
                }
            }
            EVoucherFileUtil.verifyCert(nObjId);
            String string = "\u6587\u6863\u9a8c\u8bc1\u901a\u8fc7";
            return string;
        }
        finally {
            EVoucherFileUtil.closeFile(nObjId);
        }
    }

    private static void verifyCert(int openObj) throws IOException {
        if (!checkCert) {
            return;
        }
        int nodeNum = EVoucherFileUtil.getNodeNum(openObj, 251);
        if (nodeNum <= 0) {
            throw new DJCommonResponseException("\u8be5\u6587\u6863\u4e0d\u5b58\u5728\u7535\u5b50\u5370\u7ae0:" + nodeNum);
        }
        for (int i = 0; i < nodeNum; ++i) {
            String m = EVoucherFileUtil.getNoteByIndex(openObj, i, 251);
            String certData = srvSealUtil.getValueEx(openObj, m, 39, "", 0, "");
            if (null == certData || "".equals(certData)) {
                throw new DJCommonResponseException("\u83b7\u53d6\u6587\u6863\u7b7e\u7ae0\u8bc1\u4e66\u5931\u8d25:" + m);
            }
            if (certData.startsWith("errorcode")) {
                throw new DJCommonResponseException("\u83b7\u53d6\u6587\u6863\u7b7e\u7ae0\u8bc1\u4e66\u5931\u8d25:" + certData);
            }
            EVoucherFileUtil.verifyCertIsTrust(certData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String verifyPdf(String filePath) throws IOException {
        int nObjId = 0;
        try {
            nObjId = EVoucherFileUtil.ocxOpenObj(filePath);
            if (IS_WINDOWS) {
                int nodeNum = EVoucherFileUtil.getNodeNum(nObjId, 251);
                if (nodeNum <= 0) {
                    throw new DJCommonResponseException("\u8be5\u6587\u6863\u4e0d\u5b58\u5728\u7535\u5b50\u5370\u7ae0:" + nodeNum);
                }
                for (int i = 0; i < nodeNum; ++i) {
                    String m = EVoucherFileUtil.getNoteByIndex(nObjId, i, 251);
                    System.out.println("getNoteByIndex:" + i + ",note:" + m);
                    String verifyState = srvSealUtil.getValueEx(nObjId, m, 34, "", 0, "");
                    if (!"1".equals(verifyState)) {
                        throw new DJCommonResponseException("\u6587\u6863\u9a8c\u8bc1\u5931\u8d25\uff0c\u6587\u6863\u88ab\u7be1\u6539:" + verifyState);
                    }
                    String certData = srvSealUtil.getValueEx(nObjId, m, 39, "", 0, "");
                    if (null == certData || "".equals(certData)) {
                        throw new DJCommonResponseException("\u83b7\u53d6\u6587\u6863\u7b7e\u7ae0\u8bc1\u4e66\u5931\u8d25:" + m);
                    }
                    if (!certData.startsWith("errorcode")) continue;
                    throw new DJCommonResponseException("\u83b7\u53d6\u6587\u6863\u7b7e\u7ae0\u8bc1\u4e66\u5931\u8d25:" + certData);
                }
            } else {
                String sealNode = srvSealUtil.getNextSeal(nObjId, "");
                if ("".equals(sealNode) || null == sealNode) {
                    throw new DJCommonResponseException("\u8be5\u6587\u6863\u4e0d\u5b58\u5728\u7535\u5b50\u5370\u7ae0:" + sealNode);
                }
                while ("".equals(sealNode) || null == sealNode) {
                    String sealType = srvSealUtil.getSealInfo(nObjId, sealNode, 0);
                    if ("1".equals(sealType)) {
                        throw new DJCommonResponseException("\u9a8c\u8bc1\u4e0d\u901a\u8fc7:\u6b64\u76d6\u7ae0pdf\u4e2d\u6709\u975e\u5370\u7ae0\u7684\u5143\u7d20");
                    }
                    String verifyRes = srvSealUtil.verifySeal(nObjId, sealNode);
                    String[] s = verifyRes.split("<+");
                    for (int j = 1; j < s.length; ++j) {
                        String s1 = s[j].substring(s[j].indexOf("+") + 1, s[j].indexOf("/;->"));
                        for (String value : s1.split("/;")) {
                            String[] node = value.split("=");
                            if (node.length != 2 || !"RetCode".equals(node[0]) || "0".equals(node[1])) continue;
                            throw new DJCommonResponseException("\u6587\u6863\u9a8c\u8bc1\u4e0d\u901a\u8fc7:" + node[1]);
                        }
                    }
                    sealNode = srvSealUtil.getNextSeal(nObjId, sealNode);
                }
                EVoucherFileUtil.verifyCert(nObjId);
            }
            String string = "\u6587\u6863\u9a8c\u8bc1\u901a\u8fc7";
            return string;
        }
        finally {
            EVoucherFileUtil.closeFile(nObjId);
        }
    }

    private static void filePathCheck(String filePath) throws DJCommonResponseException {
        if (null == filePath || "".equals(filePath)) {
            throw new DJCommonResponseException("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff0c\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", ExceptionEnum.PATH_ERR.getKey());
        }
        if (!(filePath.endsWith(".ofd") || filePath.endsWith(".OFD") || filePath.endsWith(".pdf") || filePath.endsWith(".PDF"))) {
            throw new DJCommonResponseException("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff0c\u6587\u4ef6\u9700\u8981pdf\u6216ofd\u683c\u5f0f", ExceptionEnum.PATH_ERR.getKey());
        }
    }

    private static int ocxOpenObj(String openPath) {
        if (openPath == null) {
            throw new DJCommonResponseException("openObj \u63a5\u53e3\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff0c \u53c2\u6570\u4e0d\u80fd\u4e3anull");
        }
        int openObjResult = IS_WINDOWS ? srvSealUtil.openObj(openPath, 0, 0) : srvSealUtil.openObj(openPath, 0);
        if (openObjResult <= 0) {
            throw new DJCommonResponseException("\u6587\u6863\u6253\u5f00\u5931\u8d25", openObjResult);
        }
        return openObjResult;
    }

    private static int getNodeNum(int nObjId, int nNoteType) {
        if (IS_WINDOWS) {
            return srvSealUtil.getNodeNum(nObjId, nNoteType);
        }
        return srvSealUtil.getNoteNum(nObjId, -1, nNoteType);
    }

    private static String getNoteByIndex(int nObjId, int index, int iNoteType) {
        if (IS_WINDOWS) {
            return srvSealUtil.getNoteByIndex(nObjId, index, iNoteType);
        }
        return srvSealUtil.getNoteByIndex(nObjId, index, -1, iNoteType);
    }

    private static void closeFile(int nObjId) {
        if (nObjId != 0) {
            EVoucherFileUtil.ocxSaveFile(nObjId, "", "", 0);
        }
    }

    private static void ocxSaveFile(int nObjId, String savePath, String saveType, int keepObj) {
        savePath = savePath == null ? "" : savePath;
        String string = saveType = saveType == null ? "" : saveType;
        int result = IS_WINDOWS ? srvSealUtil.saveFile(nObjId, savePath, saveType, keepObj) : (keepObj == 1 ? srvSealUtil.saveFileEx(nObjId, savePath, 0) : srvSealUtil.saveFile(nObjId, savePath));
        if (result <= 0) {
            throw new DJCommonResponseException("saveFile \u4fdd\u5b58\u6587\u6863\u5931\u8d25", result);
        }
    }

    private static Map<String, String> getZipFiles(String zipPath) throws IOException {
        return EVoucherFileUtil.getZipFiles(Files.newInputStream(Paths.get(zipPath, new String[0]), new OpenOption[0]));
    }

    private static Map<String, String> getZipFiles(byte[] zipBytes) {
        return EVoucherFileUtil.getZipFiles(new ByteArrayInputStream(zipBytes));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> getZipFiles(InputStream inputStream) {
        try (ZipInputStream zi = new ZipInputStream(inputStream);){
            HashMap<String, String> hashMap;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(zi));){
                ZipEntry entry;
                HashMap<String, String> ret = new HashMap<String, String>();
                while ((entry = zi.getNextEntry()) != null) {
                    String line;
                    StringBuilder s = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        s.append(line);
                    }
                    ret.put(entry.getName(), s.toString());
                }
                hashMap = ret;
            }
            return hashMap;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] unzip(String str) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static JSONObject xbrl2Json(String xbrlXml, String configId) {
        return XbrlUtil.xbrl2Json(xbrlXml, configId);
    }

    public static String json2Xbrl(String jsonValue, String configId) throws Exception {
        return XbrlUtil.json2Xbrl(jsonValue, configId);
    }

    private static void init() {
        SrvSealUtil.init(srvSealUtil);
    }

    static {
        ISSUER_MAP = new HashMap<String, String>();
        checkCert = false;
    }
}

