/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.x509.extension;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1OctetString;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.x509.AuthorityKeyIdentifier;
import xjyb.org.bjca.asn1.x509.SubjectKeyIdentifier;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.x509.extension.X509ExtensionUtil;

public class SubjectKeyIdentifierStructure
extends SubjectKeyIdentifier {
    private AuthorityKeyIdentifier authKeyID;

    public SubjectKeyIdentifierStructure(byte[] encodedValue) throws IOException {
        super((ASN1OctetString)X509ExtensionUtil.fromExtensionValue(encodedValue));
    }

    private static ASN1OctetString fromPublicKey(PublicKey pubKey) throws CertificateParsingException {
        try {
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(pubKey.getEncoded()).readObject());
            return (ASN1OctetString)new SubjectKeyIdentifier(info).toASN1Object();
        }
        catch (Exception e) {
            throw new CertificateParsingException("Exception extracting certificate details: " + e.toString());
        }
    }

    public SubjectKeyIdentifierStructure(PublicKey pubKey) throws CertificateParsingException {
        super(SubjectKeyIdentifierStructure.fromPublicKey(pubKey));
    }
}

