/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.util.test;

import java.io.PrintStream;
import xjyb.org.bjca.util.Arrays;
import xjyb.org.bjca.util.test.SimpleTestResult;
import xjyb.org.bjca.util.test.Test;
import xjyb.org.bjca.util.test.TestFailedException;
import xjyb.org.bjca.util.test.TestResult;

public abstract class SimpleTest
implements Test {
    @Override
    public abstract String getName();

    private TestResult success() {
        return SimpleTestResult.successful(this, "Okay");
    }

    protected void fail(String message) {
        throw new TestFailedException(SimpleTestResult.failed(this, message));
    }

    protected void fail(String message, Throwable throwable) {
        throw new TestFailedException(SimpleTestResult.failed(this, message, throwable));
    }

    protected void fail(String message, Object expected, Object found) {
        throw new TestFailedException(SimpleTestResult.failed(this, message, expected, found));
    }

    protected boolean areEqual(byte[] a, byte[] b) {
        return Arrays.areEqual(a, b);
    }

    @Override
    public TestResult perform() {
        try {
            this.performTest();
            return this.success();
        }
        catch (TestFailedException e) {
            return e.getResult();
        }
        catch (Exception e) {
            return SimpleTestResult.failed(this, "Exception: " + e, e);
        }
    }

    protected static void runTest(Test test2) {
        SimpleTest.runTest(test2, System.out);
    }

    protected static void runTest(Test test2, PrintStream out) {
        TestResult result = test2.perform();
        out.println(((Object)result).toString());
        if (result.getException() != null) {
            result.getException().printStackTrace(out);
        }
    }

    public abstract void performTest() throws Exception;
}

