/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.ocsp.test;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import xjyb.org.bjca.asn1.ASN1Object;
import xjyb.org.bjca.asn1.ASN1OctetString;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.ocsp.OCSPObjectIdentifiers;
import xjyb.org.bjca.asn1.x509.GeneralName;
import xjyb.org.bjca.asn1.x509.X509Extension;
import xjyb.org.bjca.asn1.x509.X509Extensions;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.jce.X509Principal;
import xjyb.org.bjca.jce.provider.BouncyCastleProvider;
import xjyb.org.bjca.ocsp.BasicOCSPResp;
import xjyb.org.bjca.ocsp.BasicOCSPRespGenerator;
import xjyb.org.bjca.ocsp.CertificateID;
import xjyb.org.bjca.ocsp.CertificateStatus;
import xjyb.org.bjca.ocsp.OCSPReq;
import xjyb.org.bjca.ocsp.OCSPReqGenerator;
import xjyb.org.bjca.ocsp.OCSPResp;
import xjyb.org.bjca.ocsp.OCSPRespGenerator;
import xjyb.org.bjca.ocsp.Req;
import xjyb.org.bjca.ocsp.SingleResp;
import xjyb.org.bjca.ocsp.test.OCSPTestUtil;
import xjyb.org.bjca.util.encoders.Base64;
import xjyb.org.bjca.util.test.SimpleTest;
import xjyb.org.bjca.x509.extension.X509ExtensionUtil;

public class OCSPTest
extends SimpleTest {
    byte[] testResp1 = Base64.decode("MIIFnAoBAKCCBZUwggWRBgkrBgEFBQcwAQEEggWCMIIFfjCCARehgZ8wgZwxCzAJBgNVBAYTAklOMRcwFQYDVQQIEw5BbmRocmEgcHJhZGVzaDESMBAGA1UEBxMJSHlkZXJhYmFkMQwwCgYDVQQKEwNUQ1MxDDAKBgNVBAsTA0FUQzEeMBwGA1UEAxMVVENTLUNBIE9DU1AgUmVzcG9uZGVyMSQwIgYJKoZIhvcNAQkBFhVvY3NwQHRjcy1jYS50Y3MuY28uaW4YDzIwMDMwNDAyMTIzNDU4WjBiMGAwOjAJBgUrDgMCGgUABBRs07IuoCWNmcEl1oHwIak1BPnX8QQUtGyl/iL9WJ1VxjxFj0hAwJ/s1AcCAQKhERgPMjAwMjA4MjkwNzA5MjZaGA8yMDAzMDQwMjEyMzQ1OFowDQYJKoZIhvcNAQEFBQADgYEAfbN0TCRFKdhsmvOdUoiJ+qvygGBzDxD/VWhXYA+16AphHLIWNABR3CgHB3zWtdy2j7DJmQ/R7qKj7dUhWLSqclAiPgFtQQ1YvSJAYfEIdyHkxv4NP0LSogxrumANcDyC9yt/W9yHjD2ICPBIqCsZLuLkOHYi5DlwWe9Zm9VFwCGgggPMMIIDyDCCA8QwggKsoAMCAQICAQYwDQYJKoZIhvcNAQEFBQAwgZQxFDASBgNVBAMTC1RDUy1DQSBPQ1NQMSYwJAYJKoZIhvcNAQkBFhd0Y3MtY2FAdGNzLWNhLnRjcy5jby5pbjEMMAoGA1UEChMDVENTMQwwCgYDVQQLEwNBVEMxEjAQBgNVBAcTCUh5ZGVyYWJhZDEXMBUGA1UECBMOQW5kaHJhIHByYWRlc2gxCzAJBgNVBAYTAklOMB4XDTAyMDgyOTA3MTE0M1oXDTAzMDgyOTA3MTE0M1owgZwxCzAJBgNVBAYTAklOMRcwFQYDVQQIEw5BbmRocmEgcHJhZGVzaDESMBAGA1UEBxMJSHlkZXJhYmFkMQwwCgYDVQQKEwNUQ1MxDDAKBgNVBAsTA0FUQzEeMBwGA1UEAxMVVENTLUNBIE9DU1AgUmVzcG9uZGVyMSQwIgYJKoZIhvcNAQkBFhVvY3NwQHRjcy1jYS50Y3MuY28uaW4wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAM+XWW4caMRv46D7L6Bv8iwtKgmQu0SAybmFRJiz12qXzdvTLt8C75OdgmUomxp0+gW/4XlTPUqOMQWv463aZRv9Ust4f8MHEJh4ekP/NS9+d8vEO3P40ntQkmSMcFmtA9E1koUtQ3MSJlcs441JjbgUaVnmjDmmniQnZY4bU3tVAgMBAAGjgZowgZcwDAYDVR0TAQH/BAIwADALBgNVHQ8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwkwNgYIKwYBBQUHAQEEKjAoMCYGCCsGAQUFBzABhhpodHRwOi8vMTcyLjE5LjQwLjExMDo3NzAwLzAtBgNVHR8EJjAkMCKgIKAehhxodHRwOi8vMTcyLjE5LjQwLjExMC9jcmwuY3JsMA0GCSqGSIb3DQEBBQUAA4IBAQB6FovM3B4VDDZ15o12gnADZsIk9fTAczLlcrmXLNN4PgmqgnwF0Ymj3bD5SavDOXxbA65AZJ7rBNAguLUo+xVkgxmoBH7R2sBxjTCcr07NEadxM3HQkt0aX5XYEl8eRoifwqYAI9h0ziZfTNes8elNfb3DoPPjqq6VmMg0f0iMS4W8LjNPorjRB+kIosa1deAGPhq0eJ8yr0/s2QR2/WFD5P4aXc8IKWleklnIImS3zqiPrq6tl2Bm8DZj7vXlTOwmraSQxUwzCKwYob1yGvNOUQTqpG6jxn7jgDawHU1+WjWQe4Q34/pWeGLysxTraMa+Ug9kPe+jy/qRX2xwvKBZ====");
    byte[] testResp2 = Base64.decode("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==");

    @Override
    public String getName() {
        return "OCSP";
    }

    private void testECDSA() throws Exception {
        byte[] extValue;
        ASN1Object extObj;
        Set extOids;
        byte[] reqEnc;
        OCSPReq newReq;
        Req[] requests;
        X509Certificate[] certs;
        String signDN = "O=Bouncy Castle, C=AU";
        KeyPair signKP = OCSPTestUtil.makeECKeyPair();
        X509Certificate testCert = OCSPTestUtil.makeECDSACertificate(signKP, signDN, signKP, signDN);
        String origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        GeneralName origName = new GeneralName(new X509Name(origDN));
        CertificateID id = new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L));
        OCSPReqGenerator gen = new OCSPReqGenerator();
        gen.addRequest(new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L)));
        OCSPReq req = gen.generate();
        if (req.isSigned()) {
            this.fail("signed but shouldn't be");
        }
        if ((certs = req.getCerts("BC")) != null) {
            this.fail("null certs expected, but not found");
        }
        if (!(requests = req.getRequestList())[0].getCertID().equals(id)) {
            this.fail("Failed isFor test");
        }
        X509Certificate[] chain = new X509Certificate[1];
        gen = new OCSPReqGenerator();
        gen.setRequestorName(new GeneralName(4, new X509Principal("CN=fred")));
        gen.addRequest(new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L)));
        chain[0] = testCert;
        req = gen.generate("SHA1withECDSA", signKP.getPrivate(), chain, "BC");
        if (!req.isSigned()) {
            this.fail("not signed but should be");
        }
        if (!req.verify(signKP.getPublic(), "BC")) {
            this.fail("signature failed to verify");
        }
        if (!(requests = req.getRequestList())[0].getCertID().equals(id)) {
            this.fail("Failed isFor test");
        }
        if ((certs = req.getCerts("BC")) == null) {
            this.fail("null certs found");
        }
        if (certs.length != 1 || !certs[0].equals(testCert)) {
            this.fail("incorrect certs found in request");
        }
        if (!(newReq = new OCSPReq(reqEnc = req.getEncoded())).verify(signKP.getPublic(), "BC")) {
            this.fail("newReq signature failed to verify");
        }
        chain = new X509Certificate[1];
        gen = new OCSPReqGenerator();
        Vector<DERObjectIdentifier> oids = new Vector<DERObjectIdentifier>();
        Vector<X509Extension> values = new Vector<X509Extension>();
        byte[] sampleNonce = new byte[16];
        Random rand = new Random();
        rand.nextBytes(sampleNonce);
        gen.setRequestorName(new GeneralName(4, new X509Principal("CN=fred")));
        oids.addElement(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        values.addElement(new X509Extension(false, (ASN1OctetString)new DEROctetString(new DEROctetString(sampleNonce))));
        gen.setRequestExtensions(new X509Extensions(oids, values));
        gen.addRequest(new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L)));
        chain[0] = testCert;
        req = gen.generate("SHA1withECDSA", signKP.getPrivate(), chain, "BC");
        if (!req.isSigned()) {
            this.fail("not signed but should be");
        }
        if (!req.verify(signKP.getPublic(), "BC")) {
            this.fail("signature failed to verify");
        }
        if ((extOids = req.getCriticalExtensionOIDs()).size() != 0) {
            this.fail("wrong number of critical extensions in OCSP request.");
        }
        if ((extOids = req.getNonCriticalExtensionOIDs()).size() != 1) {
            this.fail("wrong number of non-critical extensions in OCSP request.");
        }
        if (!((extObj = X509ExtensionUtil.fromExtensionValue(extValue = req.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId()))) instanceof ASN1OctetString)) {
            this.fail("wrong extension type found.");
        }
        if (!this.areEqual(((ASN1OctetString)extObj).getOctets(), sampleNonce)) {
            this.fail("wrong extension value found.");
        }
        if (!(requests = req.getRequestList())[0].getCertID().equals(id)) {
            this.fail("Failed isFor test");
        }
        BasicOCSPRespGenerator respGen = new BasicOCSPRespGenerator(signKP.getPublic());
        respGen.addResponse(id, CertificateStatus.GOOD);
        BasicOCSPResp resp = respGen.generate("SHA1withECDSA", signKP.getPrivate(), chain, new Date(), "BC");
    }

    private void testRSA() throws Exception {
        byte[] extValue;
        ASN1Object extObj;
        Set extOids;
        byte[] reqEnc;
        OCSPReq newReq;
        Req[] requests;
        X509Certificate[] certs;
        String signDN = "O=Bouncy Castle, C=AU";
        KeyPair signKP = OCSPTestUtil.makeKeyPair();
        X509Certificate testCert = OCSPTestUtil.makeCertificate(signKP, signDN, signKP, signDN);
        String origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        GeneralName origName = new GeneralName(new X509Name(origDN));
        CertificateID id = new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L));
        OCSPReqGenerator gen = new OCSPReqGenerator();
        gen.addRequest(new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L)));
        OCSPReq req = gen.generate();
        if (req.isSigned()) {
            this.fail("signed but shouldn't be");
        }
        if ((certs = req.getCerts("BC")) != null) {
            this.fail("null certs expected, but not found");
        }
        if (!(requests = req.getRequestList())[0].getCertID().equals(id)) {
            this.fail("Failed isFor test");
        }
        X509Certificate[] chain = new X509Certificate[1];
        gen = new OCSPReqGenerator();
        gen.setRequestorName(new GeneralName(4, new X509Principal("CN=fred")));
        gen.addRequest(new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L)));
        chain[0] = testCert;
        req = gen.generate("SHA1withRSA", signKP.getPrivate(), chain, "BC");
        if (!req.isSigned()) {
            this.fail("not signed but should be");
        }
        if (!req.verify(signKP.getPublic(), "BC")) {
            this.fail("signature failed to verify");
        }
        if (!(requests = req.getRequestList())[0].getCertID().equals(id)) {
            this.fail("Failed isFor test");
        }
        if ((certs = req.getCerts("BC")) == null) {
            this.fail("null certs found");
        }
        if (certs.length != 1 || !certs[0].equals(testCert)) {
            this.fail("incorrect certs found in request");
        }
        if (!(newReq = new OCSPReq(reqEnc = req.getEncoded())).verify(signKP.getPublic(), "BC")) {
            this.fail("newReq signature failed to verify");
        }
        chain = new X509Certificate[1];
        gen = new OCSPReqGenerator();
        Vector<DERObjectIdentifier> oids = new Vector<DERObjectIdentifier>();
        Vector<X509Extension> values = new Vector<X509Extension>();
        byte[] sampleNonce = new byte[16];
        Random rand = new Random();
        rand.nextBytes(sampleNonce);
        gen.setRequestorName(new GeneralName(4, new X509Principal("CN=fred")));
        oids.addElement(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        values.addElement(new X509Extension(false, (ASN1OctetString)new DEROctetString(new DEROctetString(sampleNonce))));
        gen.setRequestExtensions(new X509Extensions(oids, values));
        gen.addRequest(new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L)));
        chain[0] = testCert;
        req = gen.generate("SHA1withRSA", signKP.getPrivate(), chain, "BC");
        if (!req.isSigned()) {
            this.fail("not signed but should be");
        }
        if (!req.verify(signKP.getPublic(), "BC")) {
            this.fail("signature failed to verify");
        }
        if ((extOids = req.getCriticalExtensionOIDs()).size() != 0) {
            this.fail("wrong number of critical extensions in OCSP request.");
        }
        if ((extOids = req.getNonCriticalExtensionOIDs()).size() != 1) {
            this.fail("wrong number of non-critical extensions in OCSP request.");
        }
        if (!((extObj = X509ExtensionUtil.fromExtensionValue(extValue = req.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId()))) instanceof ASN1OctetString)) {
            this.fail("wrong extension type found.");
        }
        if (!this.areEqual(((ASN1OctetString)extObj).getOctets(), sampleNonce)) {
            this.fail("wrong extension value found.");
        }
        if (!(requests = req.getRequestList())[0].getCertID().equals(id)) {
            this.fail("Failed isFor test");
        }
        BasicOCSPRespGenerator respGen = new BasicOCSPRespGenerator(signKP.getPublic());
        respGen.addResponse(id, CertificateStatus.GOOD);
        BasicOCSPResp resp = respGen.generate("SHA1withRSA", signKP.getPrivate(), chain, new Date(), "BC");
        OCSPRespGenerator rGen = new OCSPRespGenerator();
        byte[] enc = rGen.generate(0, resp).getEncoded();
    }

    @Override
    public void performTest() throws Exception {
        BasicOCSPResp brep;
        OCSPResp response;
        byte[] extValue;
        ASN1Object extObj;
        Set extOids;
        byte[] reqEnc;
        OCSPReq newReq;
        Req[] requests;
        X509Certificate[] certs;
        String signDN = "O=Bouncy Castle, C=AU";
        KeyPair signKP = OCSPTestUtil.makeKeyPair();
        X509Certificate testCert = OCSPTestUtil.makeCertificate(signKP, signDN, signKP, signDN);
        String origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        GeneralName origName = new GeneralName(new X509Name(origDN));
        CertificateID id = new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L));
        OCSPReqGenerator gen = new OCSPReqGenerator();
        gen.addRequest(new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L)));
        OCSPReq req = gen.generate();
        if (req.isSigned()) {
            this.fail("signed but shouldn't be");
        }
        if ((certs = req.getCerts("BC")) != null) {
            this.fail("null certs expected, but not found");
        }
        if (!(requests = req.getRequestList())[0].getCertID().equals(id)) {
            this.fail("Failed isFor test");
        }
        X509Certificate[] chain = new X509Certificate[1];
        gen = new OCSPReqGenerator();
        gen.setRequestorName(new GeneralName(4, new X509Principal("CN=fred")));
        gen.addRequest(new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L)));
        chain[0] = testCert;
        req = gen.generate("SHA1withRSA", signKP.getPrivate(), chain, "BC");
        if (!req.isSigned()) {
            this.fail("not signed but should be");
        }
        if (!req.verify(signKP.getPublic(), "BC")) {
            this.fail("signature failed to verify");
        }
        if (!(requests = req.getRequestList())[0].getCertID().equals(id)) {
            this.fail("Failed isFor test");
        }
        if ((certs = req.getCerts("BC")) == null) {
            this.fail("null certs found");
        }
        if (certs.length != 1 || !certs[0].equals(testCert)) {
            this.fail("incorrect certs found in request");
        }
        if (!(newReq = new OCSPReq(reqEnc = req.getEncoded())).verify(signKP.getPublic(), "BC")) {
            this.fail("newReq signature failed to verify");
        }
        chain = new X509Certificate[1];
        gen = new OCSPReqGenerator();
        Vector<DERObjectIdentifier> oids = new Vector<DERObjectIdentifier>();
        Vector<X509Extension> values = new Vector<X509Extension>();
        byte[] sampleNonce = new byte[16];
        Random rand = new Random();
        rand.nextBytes(sampleNonce);
        gen.setRequestorName(new GeneralName(4, new X509Principal("CN=fred")));
        oids.addElement(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        values.addElement(new X509Extension(false, (ASN1OctetString)new DEROctetString(new DEROctetString(sampleNonce))));
        gen.setRequestExtensions(new X509Extensions(oids, values));
        gen.addRequest(new CertificateID("1.3.14.3.2.26", testCert, BigInteger.valueOf(1L)));
        chain[0] = testCert;
        req = gen.generate("SHA1withRSA", signKP.getPrivate(), chain, "BC");
        if (!req.isSigned()) {
            this.fail("not signed but should be");
        }
        if (!req.verify(signKP.getPublic(), "BC")) {
            this.fail("signature failed to verify");
        }
        if ((extOids = req.getCriticalExtensionOIDs()).size() != 0) {
            this.fail("wrong number of critical extensions in OCSP request.");
        }
        if ((extOids = req.getNonCriticalExtensionOIDs()).size() != 1) {
            this.fail("wrong number of non-critical extensions in OCSP request.");
        }
        if (!((extObj = X509ExtensionUtil.fromExtensionValue(extValue = req.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId()))) instanceof ASN1OctetString)) {
            this.fail("wrong extension type found.");
        }
        if (!this.areEqual(((ASN1OctetString)extObj).getOctets(), sampleNonce)) {
            this.fail("wrong extension value found.");
        }
        if (!(requests = req.getRequestList())[0].getCertID().equals(id)) {
            this.fail("Failed isFor test");
        }
        if ((response = new OCSPResp(new ByteArrayInputStream(this.testResp1))).getStatus() != 0) {
            this.fail("response status not zero.");
        }
        if (!(brep = (BasicOCSPResp)response.getResponseObject()).verify((chain = brep.getCerts("BC"))[0].getPublicKey(), "BC")) {
            this.fail("response 1 failed to verify.");
        }
        SingleResp[] singleResp = brep.getResponses();
        response = new OCSPResp(new ByteArrayInputStream(this.testResp2));
        if (response.getStatus() != 0) {
            this.fail("response status not zero.");
        }
        if (!(brep = (BasicOCSPResp)response.getResponseObject()).verify((chain = brep.getCerts("BC"))[0].getPublicKey(), "BC")) {
            this.fail("response 2 failed to verify.");
        }
        singleResp = brep.getResponses();
        OCSPRespGenerator respGen = new OCSPRespGenerator();
        OCSPResp resp = respGen.generate(0, response.getResponseObject());
        if (!resp.getResponseObject().equals(response.getResponseObject())) {
            this.fail("response fails to match");
        }
        this.testECDSA();
        this.testRSA();
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        OCSPTest.runTest(new OCSPTest());
    }
}

