/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider.test;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import xjyb.org.bjca.asn1.cryptopro.CryptoProObjectIdentifiers;
import xjyb.org.bjca.jce.interfaces.GOST3410PrivateKey;
import xjyb.org.bjca.jce.interfaces.GOST3410PublicKey;
import xjyb.org.bjca.jce.provider.BouncyCastleProvider;
import xjyb.org.bjca.jce.spec.ECParameterSpec;
import xjyb.org.bjca.jce.spec.ECPrivateKeySpec;
import xjyb.org.bjca.jce.spec.ECPublicKeySpec;
import xjyb.org.bjca.jce.spec.GOST3410ParameterSpec;
import xjyb.org.bjca.math.ec.ECCurve;
import xjyb.org.bjca.math.ec.ECFieldElement;
import xjyb.org.bjca.math.ec.ECPoint;
import xjyb.org.bjca.util.BigIntegers;
import xjyb.org.bjca.util.test.FixedSecureRandom;
import xjyb.org.bjca.util.test.SimpleTest;

public class GOST3410Test
extends SimpleTest {
    private void ecGOST3410Test() throws Exception {
        BigInteger[] sig;
        BigInteger r = new BigInteger("29700980915817952874371204983938256990422752107994319651632687982059210933395");
        BigInteger s = new BigInteger("46959264877825372965922731380059061821746083849389763294914877353246631700866");
        byte[] kData = BigIntegers.asUnsignedByteArray(new BigInteger("53854137677348463731403841147996619241504003434302020712960838528893196233395"));
        FixedSecureRandom k = new FixedSecureRandom(kData);
        BigInteger mod_p = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564821041");
        ECCurve.Fp curve = new ECCurve.Fp(mod_p, new BigInteger("7"), new BigInteger("43308876546767276905765904595650931995942111794451039583252968842033849580414"));
        ECParameterSpec spec = new ECParameterSpec(curve, new ECPoint.Fp(curve, new ECFieldElement.Fp(mod_p, new BigInteger("2")), new ECFieldElement.Fp(mod_p, new BigInteger("4018974056539037503335449422937059775635739389905545080690979365213431566280"))), new BigInteger("57896044618658097711785492504343953927082934583725450622380973592137631069619"));
        ECPrivateKeySpec priKey = new ECPrivateKeySpec(new BigInteger("55441196065363246126355624130324183196576709222340016572108097750006097525544"), spec);
        ECPublicKeySpec pubKey = new ECPublicKeySpec(new ECPoint.Fp(curve, new ECFieldElement.Fp(mod_p, new BigInteger("57520216126176808443631405023338071176630104906313632182896741342206604859403")), new ECFieldElement.Fp(mod_p, new BigInteger("17614944419213781543809391949654080031942662045363639260709847859438286763994"))), spec);
        Signature sgr = Signature.getInstance("ECGOST3410", "BC");
        KeyFactory f = KeyFactory.getInstance("ECGOST3410", "BC");
        PrivateKey sKey = f.generatePrivate(priKey);
        PublicKey vKey = f.generatePublic(pubKey);
        sgr.initSign(sKey, k);
        byte[] message = new byte[]{97, 98, 99};
        sgr.update(message);
        byte[] sigBytes = sgr.sign();
        sgr.initVerify(vKey);
        sgr.update(message);
        if (!sgr.verify(sigBytes)) {
            this.fail("ECGOST3410 verification failed");
        }
        if (!r.equals((sig = this.decode(sigBytes))[0])) {
            this.fail(": r component wrong." + System.getProperty("line.separator") + " expecting: " + r + System.getProperty("line.separator") + " got      : " + sig[0]);
        }
        if (!s.equals(sig[1])) {
            this.fail(": s component wrong." + System.getProperty("line.separator") + " expecting: " + s + System.getProperty("line.separator") + " got      : " + sig[1]);
        }
    }

    private void generationTest() throws Exception {
        PKCS8EncodedKeySpec pkcs8;
        GOST3410PrivateKey k2;
        X509EncodedKeySpec x509s;
        KeyFactory f;
        GOST3410PublicKey k1;
        Signature s = Signature.getInstance("GOST3410", "BC");
        KeyPairGenerator g = KeyPairGenerator.getInstance("GOST3410", "BC");
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        GOST3410ParameterSpec gost3410P = new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId());
        g.initialize(gost3410P, new SecureRandom());
        KeyPair p = g.generateKeyPair();
        PrivateKey sKey = p.getPrivate();
        PublicKey vKey = p.getPublic();
        s.initSign(sKey);
        s.update(data);
        byte[] sigBytes = s.sign();
        s = Signature.getInstance("GOST3410", "BC");
        s.initVerify(vKey);
        s.update(data);
        if (!s.verify(sigBytes)) {
            this.fail("GOST3410 verification failed");
        }
        s = Signature.getInstance("GOST3410", "BC");
        g = KeyPairGenerator.getInstance("GOST3410", "BC");
        p = g.generateKeyPair();
        sKey = p.getPrivate();
        vKey = p.getPublic();
        s.initSign(sKey);
        s.update(data);
        sigBytes = s.sign();
        s = Signature.getInstance("GOST3410", "BC");
        s.initVerify(vKey);
        s.update(data);
        if (!s.verify(sigBytes)) {
            this.fail("GOST3410 verification failed");
        }
        if (!(k1 = (GOST3410PublicKey)(f = KeyFactory.getInstance("GOST3410", "BC")).generatePublic(x509s = new X509EncodedKeySpec(vKey.getEncoded()))).getY().equals(((GOST3410PublicKey)vKey).getY())) {
            this.fail("public number not decoded properly");
        }
        if (!(k2 = (GOST3410PrivateKey)f.generatePrivate(pkcs8 = new PKCS8EncodedKeySpec(sKey.getEncoded()))).getX().equals(((GOST3410PrivateKey)sKey).getX())) {
            this.fail("private number not decoded properly");
        }
        s = Signature.getInstance("ECGOST3410", "BC");
        g = KeyPairGenerator.getInstance("ECGOST3410", "BC");
        BigInteger mod_p = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564821041");
        ECCurve.Fp curve = new ECCurve.Fp(mod_p, new BigInteger("7"), new BigInteger("43308876546767276905765904595650931995942111794451039583252968842033849580414"));
        ECParameterSpec ecSpec = new ECParameterSpec(curve, new ECPoint.Fp(curve, new ECFieldElement.Fp(mod_p, new BigInteger("2")), new ECFieldElement.Fp(mod_p, new BigInteger("4018974056539037503335449422937059775635739389905545080690979365213431566280"))), new BigInteger("57896044618658097711785492504343953927082934583725450622380973592137631069619"));
        g.initialize(ecSpec, new SecureRandom());
        p = g.generateKeyPair();
        sKey = p.getPrivate();
        vKey = p.getPublic();
        s.initSign(sKey);
        s.update(data);
        sigBytes = s.sign();
        s = Signature.getInstance("ECGOST3410", "BC");
        s.initVerify(vKey);
        s.update(data);
        if (!s.verify(sigBytes)) {
            this.fail("ECGOST3410 verification failed");
        }
    }

    private void parametersTest() throws Exception {
        GOST3410ParameterSpec gost3410P = new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_B.getId());
        KeyPairGenerator g = KeyPairGenerator.getInstance("GOST3410", "BC");
        g.initialize(gost3410P, new SecureRandom());
        KeyPair p = g.generateKeyPair();
        PrivateKey sKey = p.getPrivate();
        PublicKey vKey = p.getPublic();
        Signature s = Signature.getInstance("GOST3410", "BC");
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        s.initSign(sKey);
        s.update(data);
        byte[] sigBytes = s.sign();
        s = Signature.getInstance("GOST3410", "BC");
        s.initVerify(vKey);
        s.update(data);
        if (!s.verify(sigBytes)) {
            this.fail("GOST3410 verification failed");
        }
    }

    private BigInteger[] decode(byte[] encoding) {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        System.arraycopy(encoding, 0, s, 0, 32);
        System.arraycopy(encoding, 32, r, 0, 32);
        BigInteger[] sig = new BigInteger[]{new BigInteger(1, r), new BigInteger(1, s)};
        return sig;
    }

    @Override
    public String getName() {
        return "GOST3410/ECGOST3410";
    }

    @Override
    public void performTest() throws Exception {
        this.ecGOST3410Test();
        this.generationTest();
        this.parametersTest();
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        GOST3410Test.runTest(new GOST3410Test());
    }
}

