/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.fastparser.timestamp;

import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.Item;

public class TimeStampContentInfo {
    private boolean isTimeStampContent = false;
    private Item content = new Item();

    public TimeStampContentInfo(byte[] input, Item it) {
        this.parse(input, it.offset, it.length);
    }

    public TimeStampContentInfo(byte[] input, int offset, int length) {
        this.parse(input, offset, length);
    }

    public void parse(byte[] input, int offset, int length) {
        int position = 0;
        Item tmpitem = new Item();
        if (DerUtil.debug) {
            System.out.println("Entering ContentInfo parsing @ (" + offset + "," + length + ")");
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset;
        this.isTimeStampContent = DerUtil.isTimeStampContent(input, position + offset);
        if ((position += tmpitem.length) >= length || position + offset > input.length - 1 || (input[position + offset] & 0xA0) != 160) {
            if (DerUtil.debug) {
                System.out.println("No Explicit !\nposition=" + position + ",offset=" + offset + ",length=" + length);
            }
            return;
        }
        if (DerUtil.debug) {
            System.out.println("position=" + position + ",offset=" + offset + ",length=" + length);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        tmpitem.offset += offset;
        this.content = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("Content is " + this.content);
        }
    }

    public boolean isTimeStampContent() {
        return this.isTimeStampContent;
    }

    public final Item getContent() {
        return this.content;
    }
}

