/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce;

import java.security.BasicPermission;
import java.security.Permission;
import java.util.StringTokenizer;
import xjyb.org.bjca.util.Strings;

public class ProviderConfigurationPermission
extends BasicPermission {
    private static final int THREAD_LOCAL_EC_IMPLICITLY_CA = 1;
    private static final int EC_IMPLICITLY_CA = 2;
    private static final int ALL = 3;
    private static final String THREAD_LOCAL_EC_IMPLICITLY_CA_STR = "threadlocalecimplicitlyca";
    private static final String EC_IMPLICITLY_CA_STR = "ecimplicitlyca";
    private static final String ALL_STR = "all";
    private final String actions;
    private final int permissionMask;

    public ProviderConfigurationPermission(String name) {
        super(name);
        this.actions = ALL_STR;
        this.permissionMask = 3;
    }

    public ProviderConfigurationPermission(String name, String actions) {
        super(name, actions);
        this.actions = actions;
        this.permissionMask = this.calculateMask(actions);
    }

    private int calculateMask(String actions) {
        StringTokenizer tok = new StringTokenizer(Strings.toLowerCase(actions), " ,");
        int mask = 0;
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.equals(THREAD_LOCAL_EC_IMPLICITLY_CA_STR)) {
                mask |= 1;
                continue;
            }
            if (s.equals(EC_IMPLICITLY_CA_STR)) {
                mask |= 2;
                continue;
            }
            if (!s.equals(ALL_STR)) continue;
            mask |= 3;
        }
        if (mask == 0) {
            throw new IllegalArgumentException("unknown permissions passed to mask");
        }
        return mask;
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof ProviderConfigurationPermission)) {
            return false;
        }
        if (!this.getName().equals(permission.getName())) {
            return false;
        }
        ProviderConfigurationPermission other = (ProviderConfigurationPermission)permission;
        return (this.permissionMask & other.permissionMask) == other.permissionMask;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ProviderConfigurationPermission) {
            ProviderConfigurationPermission other = (ProviderConfigurationPermission)obj;
            return this.permissionMask == other.permissionMask && this.getName().equals(other.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() + this.permissionMask;
    }
}

