/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERConstructedSet;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DEROctetString_;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.DERSet;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.jce.exception.AlgorithmNotFoundException;
import xjyb.org.bjca.jce.exception.CertificateNotMatchException;
import xjyb.org.bjca.jce.exception.DecryptDataException;
import xjyb.org.bjca.jce.exception.DecryptKeyException;
import xjyb.org.bjca.jce.exception.EncryptAlgException;
import xjyb.org.bjca.jce.exception.EncryptDataException;
import xjyb.org.bjca.jce.exception.EncryptKeyException;
import xjyb.org.bjca.jce.exception.WriteEnvDataException;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.EncryptedContentInfo;
import xjyb.org.bjca.jce.fastparser.EnvelopedData;
import xjyb.org.bjca.jce.fastparser.FastPkcs7;
import xjyb.org.bjca.jce.fastparser.IssuerAndSerialNumber;
import xjyb.org.bjca.jce.fastparser.Item;
import xjyb.org.bjca.jce.fastparser.RecipientInfo;
import xjyb.org.bjca.sm4soft.crypto.ParameterException;
import xjyb.org.bjca.sm4soft.crypto.SM4Crypto;
import xjyb.org.bjca.util.encoders.Base64;
import xjyb.org.bjca.util.encoders.Hex;

public class CNEnvelopedData
implements PKCSObjectIdentifiers {
    public static SecretKey key;
    public static final int TRIPLE_DES_CBC = 1;
    public static final int DES_CBC = 2;
    public static final int RC2_CBC = 3;
    static final int MD5 = 1;
    static final int MD2 = 2;
    static final int SHA1 = 3;
    static final int RSA = 4;
    static final int DSA = 5;
    static final int SHA224 = 6;
    static final int SHA256 = 7;
    static final int SHA384 = 8;
    static final int SHA512 = 9;
    static final int RC4 = 10;
    static final int DES = 11;
    static final int DESEDE = 12;
    static final int RC2 = 13;
    static final int AES = 14;
    public static final int IV_LENGTH = 8;
    public static final int IV_LENGTH_SM4 = 16;
    static final String ID_SHA1 = "1.3.14.3.2.26";
    static final String ID_RSA = "1.2.840.113549.1.1.1";
    static final String ID_DSA = "1.2.840.10040.4.1";
    static final String ID_SHA256 = "2.16.840.1.101.3.4.2.1";
    static final String ID_SHA384 = "2.16.840.1.101.3.4.2.2";
    static final String ID_SHA512 = "2.16.840.1.101.3.4.2.3";
    static final String ID_DES = "1.3.14.3.2.7";
    static final String ID_DESEDE = "1.2.840.113549.3.7";
    byte[] bsPKCS7 = null;
    FastPkcs7 fxPKCS7 = new FastPkcs7();

    public byte[] decrypt(byte[] envelopeddata, byte[] privateKey, X509CertificateStructure cert) throws SecurityException, CertificateNotMatchException, DecryptKeyException, DecryptDataException, IOException {
        if (!this.fxPKCS7.pkcs7Data(envelopeddata)) {
            throw new SecurityException("can't decode PKCS7EnvlopedData object");
        }
        EnvelopedData ed = this.fxPKCS7.getEnvelopedData();
        if (ed == null) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - wrong header" + this.fxPKCS7.getContentType());
        }
        ArrayList riList = ed.getVRecipientInfo();
        RecipientInfo ri = (RecipientInfo)riList.get(0);
        Item item = ri.getIssuerAndSerialNumber();
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(envelopeddata, item);
        item = iasn.getIssuer();
        byte[] bs = new byte[item.length];
        bs = DerUtil.getItemDataAndTag(envelopeddata, item);
        ASN1InputStream in = new ASN1InputStream(bs);
        String issuer = "";
        try {
            DERObject obj = in.readObject();
            ASN1Sequence seq = ASN1Sequence.getInstance(obj);
            X509Name name = new X509Name(seq);
            issuer = name.toString();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sn = iasn.getSerialNumber().getSerialNumber().toString();
        String certSN = cert.getSerialNumber().toString();
        if (!certSN.equals(sn)) {
            throw new CertificateNotMatchException("Certificate is not match");
        }
        byte[] encKey = ri.getEncKey();
        EncryptedContentInfo eci = ed.getEncryptedContentInfoObject();
        item = eci.getContentEncryptionAlgorithm();
        item = eci.getIvParameter();
        bs = DerUtil.getItemDataAndTag(envelopeddata, item);
        byte[] tmpIV = new byte[16];
        if (bs.length != 0 && (bs[0] != 5 || bs[1] != 0)) {
            System.arraycopy(bs, 2, tmpIV, 0, tmpIV.length);
        }
        item = eci.getEncryptedContent();
        byte[] encdata = new byte[item.length];
        System.arraycopy(envelopeddata, item.offset, encdata, 0, encdata.length);
        byte[] key = null;
        try {
            WrapCard wCard = new WrapCard();
            key = wCard.sm2Decrypt(privateKey, encKey);
        }
        catch (Exception ex) {
            throw new DecryptKeyException(ex.getMessage());
        }
        byte[] out = null;
        try {
            WrapCard wCard = new WrapCard();
            out = wCard.sm4Decrypt(4098, true, key, tmpIV, encdata);
        }
        catch (Exception ex) {
            throw new DecryptDataException(ex.getMessage());
        }
        return out;
    }

    public byte[] decrypt(byte[] envelopeddata, byte[] privateKey, X509CertificateStructure cert, int mode) throws SecurityException, CertificateNotMatchException, DecryptKeyException, DecryptDataException, IOException {
        if (!this.fxPKCS7.pkcs7Data(envelopeddata)) {
            throw new SecurityException("can't decode PKCS7EnvlopedData object");
        }
        EnvelopedData ed = this.fxPKCS7.getEnvelopedData();
        if (ed == null) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - wrong header" + this.fxPKCS7.getContentType());
        }
        ArrayList riList = ed.getVRecipientInfo();
        RecipientInfo ri = (RecipientInfo)riList.get(0);
        Item item = ri.getIssuerAndSerialNumber();
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(envelopeddata, item);
        item = iasn.getIssuer();
        byte[] bs = new byte[item.length];
        bs = DerUtil.getItemDataAndTag(envelopeddata, item);
        ASN1InputStream in = new ASN1InputStream(bs);
        String issuer = "";
        try {
            DERObject obj = in.readObject();
            ASN1Sequence seq = ASN1Sequence.getInstance(obj);
            X509Name name = new X509Name(seq);
            issuer = name.toString();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sn = iasn.getSerialNumber().getSerialNumber().toString();
        String certSN = cert.getSerialNumber().toString();
        if (!certSN.equals(sn)) {
            throw new CertificateNotMatchException("Certificate is not match");
        }
        byte[] encKey = ri.getEncKey();
        EncryptedContentInfo eci = ed.getEncryptedContentInfoObject();
        item = eci.getContentEncryptionAlgorithm();
        item = eci.getIvParameter();
        bs = DerUtil.getItemDataAndTag(envelopeddata, item);
        byte[] tmpIV = null;
        if (mode == 2) {
            tmpIV = new byte[16];
            if (bs.length != 0 && (bs[0] != 5 || bs[1] != 0)) {
                System.arraycopy(bs, 2, tmpIV, 0, tmpIV.length);
            }
        }
        item = eci.getEncryptedContent();
        byte[] encdata = new byte[item.length];
        System.arraycopy(envelopeddata, item.offset, encdata, 0, encdata.length);
        byte[] key = null;
        try {
            WrapCard wCard = new WrapCard();
            key = wCard.sm2Decrypt(privateKey, encKey);
        }
        catch (Exception ex) {
            throw new DecryptKeyException(ex.getMessage());
        }
        byte[] out = null;
        try {
            WrapCard wCard = new WrapCard();
            out = wCard.sm4Decrypt(4098, true, key, tmpIV, encdata);
        }
        catch (Exception ex) {
            throw new DecryptDataException(ex.getMessage());
        }
        return out;
    }

    public static String bytesToHexStringSplit(byte[] src) {
        StringBuffer stringBuilder = new StringBuffer("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append("0x" + hv + ",");
        }
        return stringBuilder.toString();
    }

    private String getKeyMethodFromEncryMethod(String str) throws AlgorithmNotFoundException {
        if ("RSA-SHA1".equals(str)) {
            return "RSA";
        }
        if ("DES".equals(str)) {
            return "3DES";
        }
        if ("T-DES".equals(str)) {
            return "3DES";
        }
        throw new AlgorithmNotFoundException("\u6b64\u7b97\u6cd5\u65e0\u6548\uff01");
    }

    public byte[] encrypt(byte[] plaindata, X509CertificateStructure cert) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException, ParameterException {
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(cert.getIssuer(), cert.getSerialNumber());
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.301.3"), null);
        SecureRandom rand = new SecureRandom();
        byte[] keyData = new byte[16];
        rand.nextBytes(keyData);
        Object c = null;
        byte[] encKey = null;
        try {
            WrapCard wCard = new WrapCard();
            encKey = wCard.sm2Encrypt(cert, keyData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EncryptKeyException("enc key exception ," + ex.getMessage());
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier("1.2.156.10197.6.1.4.2.1");
        byte[] iv = new byte[16];
        SecureRandom ivRandom = new SecureRandom();
        ivRandom.nextBytes(iv);
        DEROctetString sIV = new DEROctetString(iv);
        AlgorithmIdentifier algID = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.104"), sIV);
        DERObject derParam = (DERObject)algID.getParameters();
        IvParameterSpec param = null;
        if (derParam != null) {
            param = new IvParameterSpec(((DEROctetString)derParam).getOctets());
        }
        byte[] encdata = null;
        try {
            WrapCard wCard = new WrapCard();
            encdata = wCard.sm4Encrypt(4098, true, keyData, iv, plaindata);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EncryptKeyException("enc data exception ," + ex.getMessage());
        }
        DEROctetString_ encContent = new DEROctetString_(encdata);
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(contentType);
        cont.addObject(algID);
        cont.addObject(encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject(version);
        env.addObject(recipientInfos);
        env.addObject(cont);
        String envdatatype = "1.2.156.10197.6.1.4.2.3";
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject(new DERObjectIdentifier(envdatatype));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
        p7.addObject(dtCont);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(baos);
        try {
            dout.writeObject(p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return bs;
    }

    public byte[] encrypt(byte[] plaindata, X509CertificateStructure cert, int mode) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException, ParameterException {
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(cert.getIssuer(), cert.getSerialNumber());
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.301.3"), null);
        SecureRandom rand = new SecureRandom();
        byte[] keyData = new byte[16];
        rand.nextBytes(keyData);
        Object c = null;
        byte[] encKey = null;
        try {
            WrapCard wCard = new WrapCard();
            encKey = wCard.sm2Encrypt(cert, keyData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EncryptKeyException("enc key exception ," + ex.getMessage());
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier("1.2.156.10197.6.1.4.2.1");
        byte[] iv = null;
        AlgorithmIdentifier algID = null;
        if (mode == 2) {
            iv = new byte[16];
            SecureRandom ivRandom = new SecureRandom();
            ivRandom.nextBytes(iv);
            DEROctetString sIV = new DEROctetString(iv);
            algID = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.104"), sIV);
        } else {
            algID = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.104"));
        }
        DERObject derParam = (DERObject)algID.getParameters();
        IvParameterSpec param = null;
        if (derParam != null) {
            param = new IvParameterSpec(((DEROctetString)derParam).getOctets());
        }
        byte[] encdata = null;
        try {
            WrapCard wCard = new WrapCard();
            encdata = wCard.sm4Encrypt(4098, true, keyData, iv, plaindata);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EncryptKeyException("enc data exception ," + ex.getMessage());
        }
        DEROctetString_ encContent = new DEROctetString_(encdata);
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(contentType);
        cont.addObject(algID);
        cont.addObject(encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject(version);
        env.addObject(recipientInfos);
        env.addObject(cont);
        String envdatatype = "1.2.156.10197.6.1.4.2.3";
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject(new DERObjectIdentifier(envdatatype));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
        p7.addObject(dtCont);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(baos);
        try {
            dout.writeObject(p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return bs;
    }

    public byte[] encrypt(long plaindataLen, X509CertificateStructure cert, byte[] key, byte[] iv) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException, ParameterException, IOException {
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(cert.getIssuer(), cert.getSerialNumber());
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.301.3"), null);
        byte[] keyData = key;
        byte[] encKey = null;
        try {
            WrapCard wCard = new WrapCard();
            encKey = wCard.sm2Encrypt(cert, keyData);
        }
        catch (Exception ex) {
            throw new EncryptKeyException("enc key exception ," + ex.getMessage());
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier("1.2.156.10197.6.1.4.2.1");
        DEROctetString sIV = new DEROctetString(iv);
        AlgorithmIdentifier algID = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.104"), sIV);
        byte[] lengthByte = DerUtil.getDerLength(plaindataLen);
        byte[] encdata = new byte[lengthByte.length + 1];
        encdata[0] = -128;
        System.arraycopy(lengthByte, 0, encdata, 1, lengthByte.length);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] contentTypeByte = contentType.getEncoded();
        byte[] algIDByte = algID.getEncoded();
        long contLeng = (long)(contentTypeByte.length + algIDByte.length + encdata.length) + plaindataLen;
        byteArrayOutputStream.write(48);
        byteArrayOutputStream.write(DerUtil.getDerLength(contLeng));
        byteArrayOutputStream.write(contentTypeByte);
        byteArrayOutputStream.write(algIDByte);
        byteArrayOutputStream.write(encdata);
        ByteArrayOutputStream envByteArrayOutputStream = new ByteArrayOutputStream();
        byte[] versionByte = version.getEncoded();
        byte[] recipientInfosByte = recipientInfos.getEncoded();
        long envLeng = (long)(versionByte.length + recipientInfosByte.length + byteArrayOutputStream.toByteArray().length) + plaindataLen;
        envByteArrayOutputStream.write(48);
        envByteArrayOutputStream.write(DerUtil.getDerLength(envLeng));
        envByteArrayOutputStream.write(versionByte);
        envByteArrayOutputStream.write(recipientInfosByte);
        envByteArrayOutputStream.write(byteArrayOutputStream.toByteArray());
        ByteArrayOutputStream derTagByteArrayOutputStream = new ByteArrayOutputStream();
        derTagByteArrayOutputStream.write(160);
        derTagByteArrayOutputStream.write(DerUtil.getDerLength((long)envByteArrayOutputStream.toByteArray().length + plaindataLen));
        derTagByteArrayOutputStream.write(envByteArrayOutputStream.toByteArray());
        ByteArrayOutputStream p7ByteArrayOutputStream = new ByteArrayOutputStream();
        String envdatatype = "1.2.156.10197.6.1.4.2.3";
        byte[] identifierByte = new DERObjectIdentifier(envdatatype).getEncoded();
        long p7Leng = (long)(identifierByte.length + derTagByteArrayOutputStream.toByteArray().length) + plaindataLen;
        p7ByteArrayOutputStream.write(48);
        p7ByteArrayOutputStream.write(DerUtil.getDerLength(p7Leng));
        p7ByteArrayOutputStream.write(identifierByte);
        p7ByteArrayOutputStream.write(derTagByteArrayOutputStream.toByteArray());
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.close();
        }
        if (envByteArrayOutputStream != null) {
            envByteArrayOutputStream.close();
        }
        if (derTagByteArrayOutputStream != null) {
            derTagByteArrayOutputStream.close();
        }
        if (p7ByteArrayOutputStream != null) {
            p7ByteArrayOutputStream.close();
        }
        return p7ByteArrayOutputStream.toByteArray();
    }

    public byte[] encrypt(byte[] plaindata, X509CertificateStructure cert, byte[] key, byte[] iv) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException, ParameterException {
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(cert.getIssuer(), cert.getSerialNumber());
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.301.3"), null);
        SecureRandom rand = new SecureRandom();
        byte[] keyData = key;
        Object c = null;
        byte[] encKey = null;
        try {
            WrapCard wCard = new WrapCard();
            encKey = wCard.sm2Encrypt(cert, keyData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EncryptKeyException("enc key exception ," + ex.getMessage());
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier("1.2.156.10197.6.1.4.2.1");
        DEROctetString sIV = new DEROctetString(iv);
        AlgorithmIdentifier algID = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.104"), sIV);
        DERObject derParam = (DERObject)algID.getParameters();
        IvParameterSpec param = null;
        if (derParam != null) {
            param = new IvParameterSpec(((DEROctetString)derParam).getOctets());
        }
        SM4Crypto sm4C = new SM4Crypto();
        byte[] encdata = sm4C.encrypt_pkcs5(2, keyData, iv, plaindata);
        DEROctetString_ encContent = new DEROctetString_(encdata);
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(contentType);
        cont.addObject(algID);
        cont.addObject(encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject(version);
        env.addObject(recipientInfos);
        env.addObject(cont);
        String envdatatype = "1.2.156.10197.6.1.4.2.3";
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject(new DERObjectIdentifier(envdatatype));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
        p7.addObject(dtCont);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(baos);
        try {
            dout.writeObject(p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return bs;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new CNEnvelopedData().getSerialNumFromEnvelopedData(Base64.decode("MIIBPQYKKoEcz1UGAQQCA6CCAS0wggEpAgEAMYHmMIHjAgEAMFIwRDELMAkGA1UEBhMCQ04xDTALBgNVBAoMBEJKQ0ExDTALBgNVBAsMBEJKQ0ExFzAVBgNVBAMMDkJlaWppbmcgU00yIENBAgoaEAAAAAAABRMlMA0GCSqBHM9VAYItAwUABHsweQIhALz1AbeoAlfI2G3b5isXYhzvHmlMR9jSsjta2PqDx3fKAiA5pnyEGFeOen7hSiN5wWN+6SJZlTfRYSV9tlBj9j3DqgQghiJLtVtRcjHt3iZ+m3F4Yzzg4Y6x+Pp3/i3ynOIYcAQEEDawux5AYL9YKKxmoir7k/owOwYKKoEcz1UGAQQCATAbBgcqgRzPVQFoBBCi7qMugrlGkssxClbv/FLPgBAmP/PEzLnmQKmCtsbIuyBa")));
    }

    public static boolean compereDN(String DN1, String JKSDN) {
        if (DN1 == null || JKSDN == null) {
            return false;
        }
        if (DN1.equals(JKSDN)) {
            return true;
        }
        String[] temp = JKSDN.split(",");
        String turnDN = temp[0].trim();
        for (int i = 1; i <= temp.length - 1; ++i) {
            turnDN = turnDN + "," + temp[i].trim();
        }
        return DN1.equals(turnDN);
    }

    public String getSerialNumFromEnvelopedData(byte[] envelopeData) throws Exception {
        DERConstructedSequence issuerAndSerialNumber;
        DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(envelopeData));
        if (derInputStream == null) {
            return null;
        }
        DERConstructedSequence p7 = (DERConstructedSequence)derInputStream.readObject();
        if (p7 == null) {
            return null;
        }
        DERTaggedObject dtCont = (DERTaggedObject)p7.getObjectAt(1);
        if (dtCont == null) {
            return null;
        }
        DERConstructedSequence env = (DERConstructedSequence)dtCont.getObject();
        if (env == null) {
            return null;
        }
        DERConstructedSet recipientInfos = (DERConstructedSet)env.getObjectAt(1);
        if (recipientInfos == null) {
            return null;
        }
        DERConstructedSequence recipientInfo = (DERConstructedSequence)recipientInfos.getObjectAt(0);
        if (recipientInfo == null) {
            return null;
        }
        if (recipientInfo.size() > 2 && (issuerAndSerialNumber = (DERConstructedSequence)recipientInfo.getObjectAt(1)) != null) {
            return new String(Hex.encode(issuerAndSerialNumber.getObjectAt(1).getDERObject().getEncoded(), 2, issuerAndSerialNumber.getObjectAt(1).getDERObject().getEncoded().length - 2));
        }
        return null;
    }
}

