/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.apache.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import xjyb.org.apache.http.HttpException;
import xjyb.org.apache.http.HttpHost;
import xjyb.org.apache.http.HttpRequest;
import xjyb.org.apache.http.annotation.Contract;
import xjyb.org.apache.http.annotation.ThreadingBehavior;
import xjyb.org.apache.http.client.ClientProtocolException;
import xjyb.org.apache.http.client.config.RequestConfig;
import xjyb.org.apache.http.client.methods.CloseableHttpResponse;
import xjyb.org.apache.http.client.methods.Configurable;
import xjyb.org.apache.http.client.methods.HttpExecutionAware;
import xjyb.org.apache.http.client.methods.HttpRequestWrapper;
import xjyb.org.apache.http.client.protocol.HttpClientContext;
import xjyb.org.apache.http.conn.ClientConnectionManager;
import xjyb.org.apache.http.conn.ClientConnectionRequest;
import xjyb.org.apache.http.conn.HttpClientConnectionManager;
import xjyb.org.apache.http.conn.ManagedClientConnection;
import xjyb.org.apache.http.conn.routing.HttpRoute;
import xjyb.org.apache.http.conn.scheme.SchemeRegistry;
import xjyb.org.apache.http.impl.DefaultConnectionReuseStrategy;
import xjyb.org.apache.http.impl.client.CloseableHttpClient;
import xjyb.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import xjyb.org.apache.http.impl.execchain.MinimalClientExec;
import xjyb.org.apache.http.params.BasicHttpParams;
import xjyb.org.apache.http.params.HttpParams;
import xjyb.org.apache.http.protocol.BasicHttpContext;
import xjyb.org.apache.http.protocol.HttpContext;
import xjyb.org.apache.http.protocol.HttpRequestExecutor;
import xjyb.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

