/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.mac;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.cn.org.bjca.exception.EncryptDataException;

public class ASN1Mac {
    public static byte[] ansiX9_9MAC(byte[] key, byte[] data) throws Exception {
        int dataLength = data.length;
        int lastLength = dataLength % 8;
        int lastBlockLength = lastLength == 0 ? 8 : lastLength;
        int blockCount = dataLength / 8 + (lastLength > 0 ? 1 : 0);
        byte[][] dataBlock = new byte[blockCount][8];
        for (int i = 0; i < blockCount; ++i) {
            int copyLength = i == blockCount - 1 ? lastBlockLength : 8;
            System.arraycopy(data, i * 8, dataBlock[i], 0, copyLength);
        }
        byte[] desXor = new byte[8];
        for (int i = 0; i < blockCount; ++i) {
            byte[] tXor = ASN1Mac.xOr(desXor, dataBlock[i]);
            desXor = ASN1Mac.symmEncryptDesEcbNoPadding(key, tXor);
        }
        return desXor;
    }

    private static byte[] xOr(byte[] x, byte[] y) {
        if (x.length != y.length) {
            return null;
        }
        byte[] xOrRes = new byte[x.length];
        for (int i = 0; i < x.length; ++i) {
            xOrRes[i] = (byte)(x[i] ^ y[i]);
        }
        return xOrRes;
    }

    private static byte[] symmEncryptDesEcbNoPadding(byte[] key, byte[] data) throws Exception {
        byte[] cipherData = null;
        try {
            SecretKeySpec desKey = new SecretKeySpec(key, "DES");
            Cipher cipher = Cipher.getInstance("DES/ECB/NOPadding");
            cipher.init(1, desKey);
            cipherData = cipher.doFinal(data);
        }
        catch (Exception e) {
            LoggerUtil.errorlog("error", "DES_ECB encrypt Exception:", e);
            throw new EncryptDataException("DES_ECB encrypt Exception:");
        }
        return cipherData;
    }
}

