/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.jni.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import xjyb.bjca.org.jdom.Document;
import xjyb.bjca.org.jdom.Element;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.jdom.input.SAXBuilder;
import xjyb.bjca.org.jdom.output.Format;
import xjyb.bjca.org.jdom.output.XMLOutputter;
import xjyb.bjcasafeapi.BjcaApiEngine;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.jni.security.SecurityEngine;
import xjyb.cn.org.bjca.jni.utils.RsaUtil;
import xjyb.cn.org.bjca.security.SecurityEngineDeal;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.HashUtil;

public class XMLSignUtil
extends SuperUtil {
    public XMLSignUtil(String appName) {
        super(appName);
    }

    private String CreateSignStr(String digVal) {
        String outstr = "<SignedInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\"><CanonicalizationMethod Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></CanonicalizationMethod>";
        outstr = outstr + "<SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#rsa-sha1\"></SignatureMethod>";
        outstr = outstr + "<Reference URI=\"#TheFirstObjcet\">";
        outstr = outstr + "<Transforms><Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments\"></Transform></Transforms>";
        outstr = outstr + "<DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></DigestMethod>";
        outstr = outstr + "<DigestValue>";
        outstr = outstr + digVal + "</DigestValue>";
        outstr = outstr + "</Reference></SignedInfo>";
        return outstr;
    }

    public static String jDomToXmlStr(Document icDoc) throws Exception {
        StringWriter lcOut = new StringWriter();
        try {
            new XMLOutputter().output(icDoc, (Writer)lcOut);
            return lcOut.toString();
        }
        catch (Exception e) {
            throw new Exception(new StringBuffer("JDom convert to XML string fail").append(e.getMessage()).toString());
        }
    }

    public static String jDomToXmlStr_noHead(Document icDoc) throws Exception {
        StringWriter lcOut = new StringWriter();
        try {
            new XMLOutputter().output(icDoc, (Writer)lcOut);
            String originalData = lcOut.toString();
            originalData = originalData.substring(originalData.indexOf(">"));
            String noHeadData = originalData = originalData.substring(originalData.indexOf("<"));
            return noHeadData;
        }
        catch (Exception e) {
            throw new Exception(new StringBuffer("JDom convert to XML string fail").append(e.getMessage()).toString());
        }
    }

    public String BJX_SignedDataXML_Sign(BjcaApiEngine apiengine, SecurityEngine safeEng, String xmlsrc, long signMethod, int m_Iinitmodel, String m_password, byte[] m_signPfx, String m_keyType, String m_container) throws XmlSignException {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        Base64Util base64U = new Base64Util(this.applicationName);
        try {
            String digxml;
            byte[] tmpbyte;
            byte[] hashedData;
            String digval;
            String sInfo;
            String sVal;
            String org_xml = xmlsrc.substring(xmlsrc.indexOf(">"));
            String xmlStr = org_xml = org_xml.substring(org_xml.indexOf("<"));
            if (org_xml.indexOf("http://www.w3.org/2000/09/xmldsig#") == -1) {
                Document node_tmp = this.getDocumentFromString(org_xml.getBytes("UTF-8"));
                xmlStr = this.getXMLTextByElement_noFormat(node_tmp.getRootElement());
                this.debuglog("xml\u7b7e\u540d\u4e4b\u524d\uff0c\u5bf9\u539f\u6587\u8fdb\u884c\u683c\u5f0f\u5316\u5904\u7406\uff0c\u5904\u7406\u7ed3\u679c == ");
                this.debuglog(xmlStr);
            }
            if ((sVal = rsaUtil.BJK_RsaSign(apiengine, (sInfo = this.CreateSignStr(digval = base64U.BJS_EncodeBase64(hashedData = hashUtil.BJS_HashBytes(signMethod, tmpbyte = (digxml = "<Object xmlns=\"http://www.w3.org/2000/09/xmldsig#\" id=\"TheFirstObjcet\">" + xmlStr + "</Object>").getBytes())))).getBytes(), signMethod, m_Iinitmodel, m_password, m_signPfx, m_keyType, m_container)) == null) {
                throw new Exception("Rsa\u7b7e\u540d\u51fa\u9519!");
            }
            String out = "<?xml version=\"1.0\" encoding=\"GB18030\"?>\n<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">";
            out = out + sInfo;
            out = out + "<SignatureValue>";
            out = out + sVal + "</SignatureValue>";
            String cert = safeEng.getSignCertString();
            if (cert == null) {
                throw new Exception("\u7b7e\u540d\u8bc1\u4e66\u4e0d\u5b58\u5728\uff01");
            }
            out = out + "<KeyInfo><X509Data><X509Certificate>";
            out = out + cert + "</X509Certificate></X509Data></KeyInfo>";
            out = out + "<Object id=\"TheFirstObjcet\">";
            out = out + xmlStr + "</Object></Signature>";
            return out;
        }
        catch (Exception e) {
            this.errorlog("xml\u7b7e\u540d\u51fa\u9519\uff01", e);
            this.debuglog("xml\u7b7e\u540d\u51fa\u9519\uff01", e);
            throw new XmlSignException("xml\u7b7e\u540d\u51fa\u9519\uff01");
        }
    }

    public boolean BJX_SignedDataXML_Verify(BjcaApiEngine apiengine, String xmlSign, long signMethod) throws XmlVerifySignException {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        try {
            Element node_tmp;
            String srcDigVal;
            byte[] tmpbyte;
            byte[] hashedData;
            String digval;
            Document doc = this.getDocumentFromString(xmlSign.getBytes());
            Element rootElement = doc.getRootElement();
            Element nodeElement = this.SelectNode(rootElement, "Object");
            String objStr = this.getNodeText_noFormatContent(nodeElement);
            if (xmlSign.indexOf("http://www.w3.org/2000/09/xmldsig#") != -1) {
                int start = xmlSign.indexOf("<Object id=\"TheFirstObjcet\">");
                int end = xmlSign.lastIndexOf("</Object>");
                objStr = xmlSign.substring(start + 28, end);
                this.debuglog("xml\u9a8c\u8bc1\u7b7e\u540d\u4e4b\u524d\uff0c\u5bf9\u539f\u6587\u8fdb\u884c\u975e\u683c\u5f0f\u5316\u5904\u7406\uff0c\u5904\u7406\u7ed3\u679c == ");
                this.debuglog(objStr);
            }
            if ((digval = base64Util.BJS_EncodeBase64(hashedData = hashUtil.BJS_HashBytes(signMethod, tmpbyte = (objStr = "<Object xmlns=\"http://www.w3.org/2000/09/xmldsig#\" id=\"TheFirstObjcet\">" + objStr + "</Object>").getBytes()))).compareToIgnoreCase(srcDigVal = this.getNodeText(node_tmp = this.SelectNode(rootElement, "SignedInfo/Reference/DigestValue"))) != 0) {
                return false;
            }
            node_tmp = this.SelectNode(rootElement, "SignedInfo");
            String signStr = this.getXMLTextByElement(node_tmp);
            node_tmp = this.SelectNode(rootElement, "KeyInfo/X509Data/X509Certificate");
            String certStr = this.getNodeText(node_tmp);
            node_tmp = this.SelectNode(rootElement, "SignatureValue");
            String signCode = this.getNodeText(node_tmp);
            byte[] certbuf = base64Util.BJS_DecodeBase64(certStr);
            boolean flag = rsaUtil.BJK_RsaVerify(apiengine, signStr.getBytes(), signCode, certbuf, signMethod);
            return flag;
        }
        catch (Exception e) {
            this.errorlog("xml\u9a8c\u7b7e\u540d\u51fa\u9519\uff01", e);
            this.debuglog("xml\u9a8c\u7b7e\u540d\u51fa\u9519\uff01", e);
            throw new XmlVerifySignException("xml\u9a8c\u7b7e\u540d\u51fa\u9519\uff01");
        }
    }

    private Element SelectNode(Element parentNode, String xpath) {
        String[] nodepath = xpath.split("/");
        Element tmpNode = parentNode;
        for (int i = 0; i < nodepath.length; ++i) {
            int j;
            List nlist = tmpNode.getChildren();
            for (j = 0; j < nlist.size(); ++j) {
                if (((Element)nlist.get(j)).getName().compareToIgnoreCase(nodepath[i]) != 0) continue;
                tmpNode = (Element)nlist.get(j);
                break;
            }
            if (j != nlist.size()) continue;
            return null;
        }
        return tmpNode;
    }

    private String getNodeText(Element objnode) {
        String ret = "";
        try {
            Format format = Format.getCompactFormat();
            XMLOutputter XMLOut = new XMLOutputter(format);
            ret = XMLOut.outputString(objnode);
        }
        catch (Exception e) {
            this.errorlog("", e);
            this.debuglog("", e);
        }
        int ind = ret.indexOf(62);
        ret = ret.substring(ind + 1);
        int end = ret.lastIndexOf(60);
        ret = ret.substring(0, end);
        String out = this.zryTrans(ret);
        return out;
    }

    private String getNodeText_noFormatContent(Element objnode) {
        String ret = "";
        try {
            XMLOutputter XMLOut = new XMLOutputter();
            ret = XMLOut.outputString(objnode);
        }
        catch (Exception e) {
            this.errorlog("", e);
            this.debuglog("", e);
        }
        int ind = ret.indexOf(62);
        ret = ret.substring(ind + 1);
        int end = ret.lastIndexOf(60);
        ret = ret.substring(0, end);
        String out = this.zryTrans(ret);
        return out;
    }

    private String getXMLTextByElement(Element objnode) {
        String ret = "";
        try {
            Format format = Format.getCompactFormat();
            XMLOutputter XMLOut = new XMLOutputter(format);
            ret = XMLOut.outputString(objnode);
        }
        catch (Exception e) {
            this.errorlog("", e);
            this.debuglog("", e);
        }
        String out = this.zryTrans(ret);
        return out;
    }

    private String getXMLTextByElement_noFormat(Element objnode) {
        String ret = "";
        try {
            XMLOutputter XMLOut = new XMLOutputter();
            ret = XMLOut.outputString(objnode);
        }
        catch (Exception e) {
            this.errorlog("", e);
            this.debuglog("", e);
        }
        String out = this.zryTrans(ret);
        return out;
    }

    private String getAttributeText(Element objnode, String attName) {
        String ret = objnode.getAttributeValue(attName);
        return ret;
    }

    private String zryTrans(String srcstr) {
        String tmpstr = srcstr;
        String nodestr = "";
        int endlen = 0;
        while (true) {
            if ((endlen = tmpstr.indexOf("/>", endlen)) < 1) {
                tmpstr = tmpstr.replaceAll(" >", ">");
                tmpstr = tmpstr.replaceAll(" >", ">");
                tmpstr = tmpstr.replaceAll(" >", ">");
                return tmpstr;
            }
            int startlen = tmpstr.lastIndexOf(60, endlen);
            int spacelen = tmpstr.indexOf(32, startlen);
            nodestr = spacelen < endlen && spacelen > 0 ? tmpstr.substring(startlen + 1, spacelen) : tmpstr.substring(startlen + 1, endlen);
            tmpstr = tmpstr.replaceFirst("/>", "></" + nodestr + ">");
        }
    }

    public String BJX_getXMLSignatureInfo(String xmlSign, int type) throws GetXMLSignInfoException, JDOMException {
        try {
            String ret = "";
            Document doc = this.getDocumentFromString(xmlSign.getBytes());
            Element rootElement = doc.getRootElement();
            Element nodeElement = this.SelectNode(rootElement, "Object");
            switch (type) {
                case 1: {
                    if (xmlSign.indexOf("http://www.w3.org/2000/09/xmldsig#") != -1) {
                        int start = xmlSign.indexOf("<Object id=\"TheFirstObjcet\">");
                        int end = xmlSign.lastIndexOf("</Object>");
                        ret = xmlSign.substring(start + 28, end);
                        break;
                    }
                    Element node_obj = this.SelectNode(rootElement, "Object");
                    ret = this.getNodeText(node_obj);
                    this.debuglog("xml\u7b7e\u540d\u503c\uff0c\u83b7\u53d6\u539f\u6587\u4fe1\u606f  == ");
                    this.debuglog(ret);
                    break;
                }
                case 2: {
                    Element node_obj = this.SelectNode(rootElement, "SignedInfo/Reference/DigestValue");
                    ret = this.getNodeText(node_obj);
                    break;
                }
                case 3: {
                    Element node_obj = this.SelectNode(rootElement, "SignatureValue");
                    ret = this.getNodeText(node_obj);
                    break;
                }
                case 4: {
                    Element node_obj = this.SelectNode(rootElement, "KeyInfo/X509Data/X509Certificate");
                    ret = this.getNodeText(node_obj);
                    break;
                }
                case 5: {
                    Element node_obj = this.SelectNode(rootElement, "SignedInfo/Reference/DigestMethod");
                    ret = this.getAttributeText(node_obj, "Algorithm");
                    break;
                }
                case 6: {
                    Element node_obj = this.SelectNode(rootElement, "SignedInfo/SignatureMethod");
                    ret = this.getAttributeText(node_obj, "Algorithm");
                    break;
                }
                default: {
                    ret = null;
                }
            }
            return ret;
        }
        catch (IOException e) {
            this.errorlog("\u83b7\u53d6XML\u7b7e\u540d\u4fe1\u606f\u51fa\u9519\uff01", e);
            this.debuglog("\u83b7\u53d6XML\u7b7e\u540d\u4fe1\u606f\u51fa\u9519\uff01", e);
            throw new GetXMLSignInfoException("\u83b7\u53d6XML\u7b7e\u540d\u4fe1\u606f\u51fa\u9519\uff01");
        }
    }

    public Document getDocumentFromString(byte[] xml) throws JDOMException, IOException {
        ByteArrayInputStream bips = new ByteArrayInputStream(xml);
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        Document doc = builder.build((InputStream)bips);
        return doc;
    }

    public static void main(String[] arg) {
        try {
            SecurityEngineDeal sed = SecurityEngineDeal.getInstance("purejava");
            String signData2 = sed.signDataXML("<sss><a>\u65fb\u73fa\u73a5\u5f22\u52bc\u749f\u7424\u8d5f\u5586\u5803\u7fc0\u74a0\u7526\u8653\u794e\u97e1\u8283\u6fdb\u6607</a>");
            System.out.println(signData2);
            boolean isSuccess = sed.verifySignedDataXML(signData2);
            System.out.println(isSuccess);
            for (int i = 1; i < 7; ++i) {
                System.out.println(sed.getXMLSignatureInfo(signData2, i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

