/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.jni.utils;

import xjyb.bjcasafeapi.BjcaApiEngine;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.jni.utils.HashUtil;
import xjyb.cn.org.bjca.utils.Base64Util;

public class RsaUtil
extends SuperUtil {
    public RsaUtil(String appName) {
        super(appName);
    }

    public byte[] BJK_RsaEncrypt(BjcaApiEngine apiengine, byte[] toBeEncryptedBlob, byte[] cert) throws GetCertInfoException, RsaEncryptException, Base64Exception {
        Object sdata = null;
        byte[] binfo = null;
        long[] infoLen = new long[1];
        int execflagCertInfo = 0;
        try {
            execflagCertInfo = apiengine.BCA_GetCertificateInfo(cert, cert.length, 20L, binfo, infoLen);
            if (execflagCertInfo == 0) {
                binfo = new byte[(int)infoLen[0]];
                execflagCertInfo = apiengine.BCA_GetCertificateInfo(cert, cert.length, 20L, binfo, infoLen);
            }
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01", e);
            throw new GetCertInfoException("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
        }
        if (execflagCertInfo != 0) {
            this.errorlog("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
            this.debuglog("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
            throw new GetCertInfoException("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
        }
        byte[] outData = null;
        long[] outDataLen = new long[1];
        int execflag = 0;
        try {
            execflag = apiengine.BCA_Pkcs1RsaPublicKeyEnc(binfo, infoLen[0], toBeEncryptedBlob, toBeEncryptedBlob.length, outData, outDataLen);
            if (execflag == 0) {
                outData = new byte[(int)outDataLen[0]];
                execflag = apiengine.BCA_Pkcs1RsaPublicKeyEnc(binfo, infoLen[0], toBeEncryptedBlob, toBeEncryptedBlob.length, outData, outDataLen);
            }
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u516c\u94a5\u52a0\u5bc6\u51fa\u9519\uff01", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u516c\u94a5\u52a0\u5bc6\u51fa\u9519\uff01", e);
            throw new RsaEncryptException("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u516c\u94a5\u52a0\u5bc6\u51fa\u9519\uff01");
        }
        if (execflag != 0) {
            this.errorlog("RSA\u516c\u94a5\u52a0\u5bc6\u51fa\u9519\uff01");
            this.debuglog("RSA\u516c\u94a5\u52a0\u5bc6\u51fa\u9519\uff01");
            throw new RsaEncryptException("RSA\u516c\u94a5\u52a0\u5bc6\u51fa\u9519\uff01");
        }
        return outData;
    }

    public String BJK_RsaDecrypt(BjcaApiEngine apiengine, String encryptedBlob, int m_Iinitmodel, String m_password, String m_container, byte[] m_encryptPfx) throws Base64Exception, RsaDecryptException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String sdata = null;
        byte[] encblob = base64Util.BJS_DecodeBase64(encryptedBlob);
        byte[] outData = null;
        long[] outDataLen = new long[1];
        int execflag = 0;
        try {
            if (m_Iinitmodel == 3) {
                this.debuglog("\u79c1\u94a5\u89e3\u5bc6\u8fdb\u5165P12\u6a21\u5f0f\u2014\u2014BJK_RsaDecrypt");
                this.debuglog("m_password == " + m_password);
                this.debuglog("m_container == " + m_container);
                byte[] bpix = m_encryptPfx;
                execflag = apiengine.BCA_Pkcs1RsaPrivateKeyDecByPkcs12(m_password.getBytes(), m_password.length(), bpix, bpix.length, encblob, encblob.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = apiengine.BCA_Pkcs1RsaPrivateKeyDecByPkcs12(m_password.getBytes(), m_password.length(), bpix, bpix.length, encblob, encblob.length, outData, outDataLen);
                }
            } else {
                this.debuglog("\u79c1\u94a5\u89e3\u5bc6\u8fdb\u5165P11\u6a21\u5f0f\u2014\u2014BJK_RsaDecrypt");
                this.debuglog("\u9700\u8981\u89e3\u5bc6\u7684\u6570\u636e == " + encryptedBlob);
                this.debuglog("m_password == " + m_password);
                this.debuglog("m_container == " + m_container);
                this.debuglog("encblob length == " + encblob.length);
                outData = new byte[256];
                execflag = apiengine.BCA_Pkcs1RsaPrivateKeyDec(m_container.getBytes(), m_container.length(), 1L, m_password.getBytes(), m_password.length(), encblob, encblob.length, outData, outDataLen);
                this.debuglog("\u7b2c\u4e00\u6b21\u89e3\u5bc6\u5b8c outDataLen == " + outDataLen[0]);
                this.debuglog("\u7b2c\u4e00\u6b21\u89e3\u5bc6\u6267\u884c\u7ed3\u679cexecflag == " + execflag);
                this.debuglog("\u7b2c\u4e00\u6b21\u89e3\u5bc6outData == " + new String(outData));
            }
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u79c1\u94a5\u89e3\u5bc6\u51fa\u9519\uff01", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u79c1\u94a5\u89e3\u5bc6\u51fa\u9519\uff01", e);
            throw new RsaDecryptException("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u79c1\u94a5\u89e3\u5bc6\u51fa\u9519\uff01");
        }
        if (execflag != 0) {
            this.errorlog("RSA\u79c1\u94a5\u89e3\u5bc6\u51fa\u9519\uff01");
            this.debuglog("RSA\u79c1\u94a5\u89e3\u5bc6\u51fa\u9519\uff01");
            throw new RsaDecryptException("RSA\u79c1\u94a5\u89e3\u5bc6\u51fa\u9519\uff01");
        }
        sdata = new String(outData, 0, (int)outDataLen[0]);
        return sdata;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] BJK_RsaSignNoHash(BjcaApiEngine apiengine, byte[] toBeSignedBlob, long hashAlgorithmType, int m_Iinitmodel, String m_password, byte[] m_signPfx, String m_keyType, String m_container) throws RsaSignException {
        sdata = null;
        outData = null;
        outDataLen = new long[1];
        execflag = 0;
        if (m_Iinitmodel == 3) {
            bpix = m_signPfx;
            if (bpix.length == 0) {
                this.errorlog("\u7b7e\u540d\u8bc1\u4e66\u6709\u8bef\uff01");
                this.debuglog("\u7b7e\u540d\u8bc1\u4e66\u6709\u8bef\uff01");
                throw new RsaSignException("\u7b7e\u540d\u8bc1\u4e66\u6709\u8bef\uff01");
            }
            try {
                execflag = apiengine.BCA_RsaSignByPkcs12(m_password.getBytes(), m_password.length(), bpix, bpix.length, hashAlgorithmType, toBeSignedBlob, toBeSignedBlob.length, outData, outDataLen);
                if (execflag != 0) ** GOTO lbl32
                outData = new byte[(int)outDataLen[0]];
                execflag = apiengine.BCA_RsaSignByPkcs12(m_password.getBytes(), m_password.length(), bpix, bpix.length, hashAlgorithmType, toBeSignedBlob, toBeSignedBlob.length, outData, outDataLen);
            }
            catch (Exception e) {
                this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                throw new RsaSignException("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01");
            }
        } else {
            try {
                keyUsage = Integer.parseInt(m_keyType) == 1 ? 1L : 2L;
                execflag = apiengine.BCA_RsaSign(m_container.getBytes(), m_container.length(), keyUsage, m_password.getBytes(), m_password.length(), hashAlgorithmType, toBeSignedBlob, toBeSignedBlob.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = apiengine.BCA_RsaSign(m_container.getBytes(), m_container.length(), keyUsage, m_password.getBytes(), m_password.length(), hashAlgorithmType, toBeSignedBlob, toBeSignedBlob.length, outData, outDataLen);
                }
            }
            catch (Exception e) {
                this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                throw new RsaSignException("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01");
            }
        }
lbl32:
        // 3 sources

        if (execflag != 0) {
            this.errorlog("RSA\u7b7e\u540d\u51fa\u9519\uff01");
            this.debuglog("RSA\u7b7e\u540d\u51fa\u9519\uff01");
            throw new RsaSignException("RSA\u7b7e\u540d\u51fa\u9519\uff01");
        }
        sdata = new byte[(int)outDataLen[0]];
        System.arraycopy(outData, 0, sdata, 0, (int)outDataLen[0]);
        return sdata;
    }

    /*
     * Unable to fully structure code
     */
    public String BJK_RsaSign(BjcaApiEngine apiengine, byte[] toBeSignedBlob, long hashAlgorithmType, int m_Iinitmodel, String m_password, byte[] m_signPfx, String m_keyType, String m_container) throws Base64Exception, HashException, RsaSignException {
        base64Util = new Base64Util(this.applicationName);
        hashUtil = new HashUtil(this.applicationName);
        sdata = null;
        outData = null;
        outDataLen = new long[1];
        hashData = hashUtil.BJS_HashBytes(apiengine, hashAlgorithmType, toBeSignedBlob, toBeSignedBlob.length);
        execflag = 0;
        if (m_Iinitmodel == 3) {
            bpix = m_signPfx;
            if (bpix.length == 0) {
                this.errorlog("error:length of cert is 0,\u7b7e\u540d\u8bc1\u4e66\u6709\u8bef\uff01");
                this.debuglog("error:length of cert is 0,\u7b7e\u540d\u8bc1\u4e66\u6709\u8bef\uff01");
                throw new RsaSignException("\u7b7e\u540d\u8bc1\u4e66\u6709\u8bef\uff01");
            }
            try {
                execflag = apiengine.BCA_RsaSignByPkcs12(m_password.getBytes(), m_password.length(), bpix, bpix.length, hashAlgorithmType, hashData, hashData.length, outData, outDataLen);
                if (execflag != 0) ** GOTO lbl35
                outData = new byte[(int)outDataLen[0]];
                execflag = apiengine.BCA_RsaSignByPkcs12(m_password.getBytes(), m_password.length(), bpix, bpix.length, hashAlgorithmType, hashData, hashData.length, outData, outDataLen);
            }
            catch (Exception e) {
                this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                throw new RsaSignException("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01");
            }
        } else {
            try {
                keyUsage = Integer.parseInt(m_keyType) == 1 ? 1L : 2L;
                execflag = apiengine.BCA_RsaSign(m_container.getBytes(), m_container.length(), keyUsage, m_password.getBytes(), m_password.length(), hashAlgorithmType, hashData, hashData.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = apiengine.BCA_RsaSign(m_container.getBytes(), m_container.length(), keyUsage, m_password.getBytes(), m_password.length(), hashAlgorithmType, hashData, hashData.length, outData, outDataLen);
                }
            }
            catch (Exception e) {
                this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                throw new RsaSignException("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01");
            }
        }
lbl35:
        // 3 sources

        if (execflag != 0) {
            this.errorlog("RSA\u7b7e\u540d\u51fa\u9519\uff01");
            this.debuglog("RSA\u7b7e\u540d\u51fa\u9519\uff01");
            throw new RsaSignException("RSA\u7b7e\u540d\u51fa\u9519\uff01");
        }
        sdata = base64Util.BJS_EncodeBase64(outData);
        return sdata;
    }

    /*
     * Unable to fully structure code
     */
    public String BJK_RsaSign_File(BjcaApiEngine apiengine, String toBeSignedFileName, long signMethod, int m_Iinitmodel, String m_password, byte[] m_signPfx, String m_keyType, String m_container) throws HashException, RsaSignException, Base64Exception {
        base64Util = new Base64Util(this.applicationName);
        sdata = null;
        outData = null;
        outDataLen = new long[1];
        hashUtil = new HashUtil(this.applicationName);
        hashData = hashUtil.BJS_HashFile(apiengine, (int)signMethod, toBeSignedFileName);
        execflag = 0;
        if (m_Iinitmodel == 3) {
            bpix = m_signPfx;
            if (bpix.length == 0) {
                this.errorlog("\u7b7e\u540d\u8bc1\u4e66\u6709\u8bef\uff01");
                this.debuglog("\u7b7e\u540d\u8bc1\u4e66\u6709\u8bef\uff01");
                throw new RsaSignException("\u7b7e\u540d\u8bc1\u4e66\u6709\u8bef\uff01");
            }
            try {
                execflag = apiengine.BCA_RsaSignByPkcs12(m_password.getBytes(), m_password.length(), bpix, bpix.length, signMethod, hashData, hashData.length, outData, outDataLen);
                if (execflag != 0) ** GOTO lbl35
                outData = new byte[(int)outDataLen[0]];
                execflag = apiengine.BCA_RsaSignByPkcs12(m_password.getBytes(), m_password.length(), bpix, bpix.length, signMethod, hashData, hashData.length, outData, outDataLen);
            }
            catch (Exception e) {
                this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                throw new RsaSignException("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01");
            }
        } else {
            try {
                keyUsage = Integer.parseInt(m_keyType) == 1 ? 1L : 2L;
                execflag = apiengine.BCA_RsaSign(m_container.getBytes(), m_container.length(), keyUsage, m_password.getBytes(), m_password.length(), signMethod, hashData, hashData.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = apiengine.BCA_RsaSign(m_container.getBytes(), m_container.length(), keyUsage, m_password.getBytes(), m_password.length(), signMethod, hashData, hashData.length, outData, outDataLen);
                }
            }
            catch (Exception e) {
                this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01", e);
                throw new RsaSignException("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u7b7e\u540d\u51fa\u9519\uff01");
            }
        }
lbl35:
        // 3 sources

        if (execflag != 0) {
            this.errorlog("RSA\u7b7e\u540d\u51fa\u9519\uff01");
            this.debuglog("RSA\u7b7e\u540d\u51fa\u9519\uff01");
            throw new RsaSignException("RSA\u7b7e\u540d\u51fa\u9519\uff01");
        }
        sdata = base64Util.BJS_EncodeBase64(outData);
        return sdata;
    }

    public boolean BJK_RsaVerify_File(BjcaApiEngine apiengine, String toBeSignedFile, String beSignedBlob, String cert, long signMethod) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        boolean succ = true;
        HashUtil hashUtil = new HashUtil(this.applicationName);
        byte[] bdecodeBlob = base64Util.BJS_DecodeBase64(beSignedBlob);
        byte[] hashData = hashUtil.BJS_HashFile(apiengine, (int)signMethod, toBeSignedFile);
        byte[] bcert = base64Util.BJS_DecodeBase64(cert);
        byte[] binfo = null;
        long[] infoLen = new long[1];
        int execflag = 0;
        try {
            execflag = apiengine.BCA_GetCertificateInfo(bcert, bcert.length, 20L, binfo, infoLen);
            if (execflag == 0) {
                binfo = new byte[(int)infoLen[0]];
                execflag = apiengine.BCA_GetCertificateInfo(bcert, bcert.length, 20L, binfo, infoLen);
            }
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01", e);
            throw new GetCertInfoException("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
        }
        if (execflag != 0) {
            this.errorlog("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
            this.debuglog("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
            throw new GetCertInfoException("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
        }
        try {
            execflag = apiengine.BCA_RsaVerifySign(signMethod, hashData, hashData.length, binfo, infoLen[0], bdecodeBlob, bdecodeBlob.length);
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01", e);
            throw new VerifySignDataException("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01");
        }
        if (execflag != 0) {
            this.errorlog("RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01");
            this.debuglog("RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01");
            return false;
        }
        return succ;
    }

    public boolean BJK_RsaVerifyNoHash(BjcaApiEngine apiengine, byte[] toBeSignedBlob, byte[] beSignedBlob, byte[] cert, long signMethod) throws GetCertInfoException, VerifySignDataException {
        boolean succ = true;
        byte[] binfo = null;
        long[] infoLen = new long[1];
        int execflag = 0;
        try {
            execflag = apiengine.BCA_GetCertificateInfo(cert, cert.length, 20L, binfo, infoLen);
            if (execflag == 0) {
                binfo = new byte[(int)infoLen[0]];
                execflag = apiengine.BCA_GetCertificateInfo(cert, cert.length, 20L, binfo, infoLen);
            }
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01", e);
            throw new GetCertInfoException("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
        }
        if (execflag != 0) {
            this.errorlog("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
            this.debuglog("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
            throw new GetCertInfoException("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
        }
        try {
            execflag = apiengine.BCA_RsaVerifySign(signMethod, toBeSignedBlob, toBeSignedBlob.length, binfo, infoLen[0], beSignedBlob, beSignedBlob.length);
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01", e);
            throw new VerifySignDataException("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01");
        }
        if (execflag != 0) {
            this.errorlog("RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01");
            this.debuglog("RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01");
            return false;
        }
        return succ;
    }

    public boolean BJK_RsaVerify(BjcaApiEngine apiengine, byte[] toBeSignedBlob, String beSignedBlob, byte[] cert, long hashAlgorithmType) throws HashException, GetCertInfoException, Base64Exception, VerifySignDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        HashUtil hashUtil = new HashUtil(this.applicationName);
        boolean succ = true;
        byte[] hashData = hashUtil.BJS_HashBytes(apiengine, hashAlgorithmType, toBeSignedBlob, toBeSignedBlob.length);
        byte[] binfo = null;
        long[] infoLen = new long[1];
        int execflag = 0;
        try {
            execflag = apiengine.BCA_GetCertificateInfo(cert, cert.length, 20L, binfo, infoLen);
            if (execflag == 0) {
                binfo = new byte[(int)infoLen[0]];
                execflag = apiengine.BCA_GetCertificateInfo(cert, cert.length, 20L, binfo, infoLen);
            }
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01", e);
            throw new GetCertInfoException("\u5e95\u5c42\u5e93\u51fa\u9519,\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
        }
        if (execflag != 0) {
            this.errorlog("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
            this.debuglog("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
            throw new GetCertInfoException("\u53d6\u8bc1\u4e66\u4fe1\u606f\u51fa\u9519\uff01");
        }
        byte[] beSignBuf = base64Util.BJS_DecodeBase64(beSignedBlob);
        try {
            execflag = apiengine.BCA_RsaVerifySign(hashAlgorithmType, hashData, hashData.length, binfo, infoLen[0], beSignBuf, beSignBuf.length);
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01", e);
            throw new VerifySignDataException("\u5e95\u5c42\u5e93\u51fa\u9519,RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01");
        }
        if (execflag != 0) {
            this.errorlog("RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01,\u9519\u8bef\u7801 == " + execflag);
            this.debuglog("RSA\u9a8c\u7b7e\u540d\u51fa\u9519\uff01");
            return false;
        }
        return succ;
    }
}

