/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.jni.utils;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import xjyb.bjcasafeapi.BjcaApiEngine;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.jni.utils.NumberUtil;
import xjyb.cn.org.bjca.utils.Base64Util;

public class Pkcs7Util
extends SuperUtil {
    public Pkcs7Util(String appName) {
        super(appName);
    }

    public byte[] BJE_Pkcs7Encode(BjcaApiEngine apiengine, byte[] toBeEncodedBlob, long toBlen) throws Pkcs7EncodeException {
        byte[] dPkcs7 = null;
        byte[] btemp = null;
        long[] ltemp = new long[1];
        int execflag = 0;
        try {
            execflag = apiengine.BCA_Pkcs7_EncodeData(toBeEncodedBlob, toBlen, btemp, ltemp);
            if (execflag == 0) {
                btemp = new byte[(int)ltemp[0]];
                execflag = apiengine.BCA_Pkcs7_EncodeData(toBeEncodedBlob, toBlen, btemp, ltemp);
            }
        }
        catch (Exception e) {
            dPkcs7 = null;
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,PKCS7\u7f16\u7801\u51fa\u9519!", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,PKCS7\u7f16\u7801\u51fa\u9519!", e);
            throw new Pkcs7EncodeException("\u5e95\u5c42\u5e93\u51fa\u9519,PKCS7\u7f16\u7801\u51fa\u9519!");
        }
        if (execflag != 0) {
            this.errorlog("PKCS7\u7f16\u7801\u51fa\u9519 \uff1a" + execflag);
            this.debuglog("PKCS7\u7f16\u7801\u51fa\u9519 \uff1a" + execflag);
            throw new Pkcs7EncodeException("PKCS7\u7f16\u7801\u51fa\u9519\uff01");
        }
        dPkcs7 = new byte[(int)ltemp[0]];
        System.arraycopy(btemp, 0, dPkcs7, 0, (int)ltemp[0]);
        return dPkcs7;
    }

    public byte[] BJE_Pkcs7Encode(BjcaApiEngine apiengine, String toBeEncodedBlob) throws Pkcs7EncodeException {
        byte[] dPkcs7 = null;
        byte[] btemp = null;
        long[] ltemp = new long[1];
        byte[] braw = toBeEncodedBlob.getBytes();
        int execflag = 0;
        try {
            execflag = apiengine.BCA_Pkcs7_EncodeData(braw, braw.length, btemp, ltemp);
            if (execflag == 0) {
                btemp = new byte[(int)ltemp[0]];
                execflag = apiengine.BCA_Pkcs7_EncodeData(braw, braw.length, btemp, ltemp);
            }
        }
        catch (Exception e) {
            dPkcs7 = null;
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,PKCS7\u7f16\u7801\u51fa\u9519\uff01", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,PKCS7\u7f16\u7801\u51fa\u9519\uff01", e);
            throw new Pkcs7EncodeException("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,PKCS7\u7f16\u7801\u51fa\u9519\uff01");
        }
        if (execflag != 0) {
            this.errorlog("PKCS7\u7f16\u7801\u51fa\u9519 \uff1a" + execflag);
            this.debuglog("PKCS7\u7f16\u7801\u51fa\u9519 \uff1a" + execflag);
            throw new Pkcs7EncodeException("PKCS7\u7f16\u7801\u51fa\u9519\uff01");
        }
        dPkcs7 = new byte[(int)ltemp[0]];
        System.arraycopy(btemp, 0, dPkcs7, 0, (int)ltemp[0]);
        return dPkcs7;
    }

    public String BJE_Pkcs7Decode(BjcaApiEngine apiengine, byte[] BeEncodedBlob, long BeEncodedBlobLen) throws Pkcs7DecodeException {
        String sdata = null;
        if (BeEncodedBlob == null) {
            return null;
        }
        byte[] btemp = null;
        long[] ltemp = new long[1];
        int execflag = 0;
        try {
            execflag = apiengine.BCA_Pkcs7_DecodeData(BeEncodedBlob, BeEncodedBlobLen, btemp, ltemp);
            if (execflag == 0) {
                btemp = new byte[(int)ltemp[0]];
                execflag = apiengine.BCA_Pkcs7_DecodeData(BeEncodedBlob, BeEncodedBlobLen, btemp, ltemp);
            }
        }
        catch (Exception e) {
            sdata = null;
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef\uff0cPKCS7\u89e3\u7801\u51fa\u9519\uff01", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef\uff0cPKCS7\u89e3\u7801\u51fa\u9519\uff01", e);
            throw new Pkcs7DecodeException("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef\uff0cPKCS7\u89e3\u7801\u51fa\u9519\uff01");
        }
        if (execflag != 0) {
            this.errorlog("PKCS7\u89e3\u7801\u51fa\u9519 \uff1a" + execflag);
            this.debuglog("PKCS7\u89e3\u7801\u51fa\u9519 \uff1a" + execflag);
            throw new Pkcs7DecodeException("PKCS7\u89e3\u7801\u51fa\u9519\uff01");
        }
        sdata = new String(btemp, 0, (int)ltemp[0]);
        return sdata;
    }

    /*
     * Unable to fully structure code
     */
    public String BJE_Pkcs7Sign(BjcaApiEngine apiengine, byte[] toBeSignedBlob, long toBlen, long signMethod, int m_Iinitmodel, String m_password, byte[] m_signPfx, byte[] m_signCertBytes, String m_keyType, String m_container) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        base64Util = new Base64Util(this.applicationName);
        sdata = null;
        outData = null;
        outDataLen = new long[1];
        bp7data = this.BJE_Pkcs7Encode(apiengine, toBeSignedBlob, toBlen);
        execflag = 0;
        if (m_Iinitmodel == 3) {
            pin = m_password.getBytes();
            bpix = m_signPfx;
            bder = m_signCertBytes;
            try {
                execflag = apiengine.BCA_Pkcs7_EncodeSignedDataByP12(bpix, bpix.length, pin, pin.length, signMethod, bder, bder.length, bp7data, bp7data.length, outData, outDataLen);
                if (execflag != 0) ** GOTO lbl35
                outData = new byte[(int)outDataLen[0]];
                execflag = apiengine.BCA_Pkcs7_EncodeSignedDataByP12(bpix, bpix.length, pin, pin.length, signMethod, bder, bder.length, bp7data, bp7data.length, outData, outDataLen);
            }
            catch (Exception e) {
                sdata = null;
                this.errorlog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u7f16\u7801\u51fa\u9519!", e);
                this.debuglog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u7f16\u7801\u51fa\u9519!", e);
                throw new Pkcs7SignException("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u7f16\u7801\u51fa\u9519!");
            }
        } else {
            bder = m_signCertBytes;
            keyUsage = Integer.parseInt(m_keyType) == 1 ? 1L : 2L;
            try {
                execflag = apiengine.BCA_Pkcs7_EncodeSignedData(m_container.getBytes(), m_container.length(), keyUsage, bder, bder.length, signMethod, bp7data, bp7data.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = apiengine.BCA_Pkcs7_EncodeSignedData(m_container.getBytes(), m_container.length(), keyUsage, bder, bder.length, signMethod, bp7data, bp7data.length, outData, outDataLen);
                }
            }
            catch (Exception e) {
                sdata = null;
                this.errorlog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u7f16\u7801\u51fa\u9519!", e);
                this.debuglog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u7f16\u7801\u51fa\u9519!", e);
                throw new Pkcs7SignException("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u7f16\u7801\u51fa\u9519!");
            }
        }
lbl35:
        // 3 sources

        if (execflag != 0) {
            this.errorlog("\u7b7e\u540d\u4fe1\u5c01\u7f16\u7801\u51fa\u9519 \uff1a" + execflag);
            this.debuglog("\u7b7e\u540d\u4fe1\u5c01\u7f16\u7801\u51fa\u9519 \uff1a" + execflag);
            throw new Pkcs7SignException("\u7b7e\u540d\u4fe1\u5c01\u7f16\u7801\u51fa\u9519!");
        }
        sdata = base64Util.BJS_EncodeBase64(outData);
        return sdata;
    }

    public boolean BJE_Pkcs7Verify(BjcaApiEngine apiengine, String beSignedBlob) throws Base64Exception, Pkcs7VerifySignException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] bdecodeBlob = base64Util.BJS_DecodeBase64(beSignedBlob);
        byte[] signerCertificate = null;
        long[] signerCertificateLen = new long[1];
        byte[] p7data = null;
        long[] p7dataLen = new long[1];
        byte[] sign = null;
        long[] signLen = new long[1];
        long[] digestAlgorithms = new long[1];
        int execflag = 0;
        try {
            execflag = apiengine.BCA_Pkcs7_DecodeSignedData(bdecodeBlob, bdecodeBlob.length, signerCertificate, signerCertificateLen, digestAlgorithms, p7data, p7dataLen, sign, signLen);
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u89e3\u7801\u51fa\u9519!", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u89e3\u7801\u51fa\u9519!", e);
            throw new Pkcs7VerifySignException("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u89e3\u7801\u51fa\u9519!");
        }
        return execflag == 0;
    }

    public String BJE_Pkcs7Verify_Cert(BjcaApiEngine apiengine, String beSignedBlob) throws Base64Exception, Pkcs7VerifySignException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] bdecodeBlob = base64Util.BJS_DecodeBase64(beSignedBlob);
        byte[] signerCertificate = null;
        long[] signerCertificateLen = new long[1];
        byte[] p7data = null;
        long[] p7dataLen = new long[1];
        byte[] sign = null;
        long[] signLen = new long[1];
        long[] digestAlgorithms = new long[1];
        int execflag = 0;
        try {
            execflag = apiengine.BCA_Pkcs7_DecodeSignedData(bdecodeBlob, bdecodeBlob.length, signerCertificate, signerCertificateLen, digestAlgorithms, p7data, p7dataLen, sign, signLen);
            if (execflag != 0) {
                return null;
            }
            signerCertificate = new byte[(int)signerCertificateLen[0]];
            p7data = new byte[(int)p7dataLen[0]];
            sign = new byte[(int)signLen[0]];
            execflag = apiengine.BCA_Pkcs7_DecodeSignedData(bdecodeBlob, bdecodeBlob.length, signerCertificate, signerCertificateLen, digestAlgorithms, p7data, p7dataLen, sign, signLen);
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u89e3\u7801\u51fa\u9519!", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u89e3\u7801\u51fa\u9519!", e);
            throw new Pkcs7VerifySignException("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u7b7e\u540d\u4fe1\u5c01\u89e3\u7801\u51fa\u9519!");
        }
        String sdata = base64Util.BJS_EncodeBase64(signerCertificate);
        return sdata;
    }

    public ArrayList BJE_getP7SignDataInfo(BjcaApiEngine apiengine, String beSignedBlob) throws Base64Exception, Pkcs7DecodeException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        ArrayList<String> infoList = new ArrayList<String>();
        byte[] bdecodeBlob = base64Util.BJS_DecodeBase64(beSignedBlob);
        byte[] signerCertificate = null;
        long[] signerCertificateLen = new long[1];
        byte[] p7data = null;
        long[] p7dataLen = new long[1];
        byte[] sign = null;
        long[] signLen = new long[1];
        long[] digestAlgorithms = new long[1];
        int execflag = 0;
        try {
            execflag = apiengine.BCA_Pkcs7_DecodeSignedData(bdecodeBlob, bdecodeBlob.length, signerCertificate, signerCertificateLen, digestAlgorithms, p7data, p7dataLen, sign, signLen);
            if (execflag == 0) {
                signerCertificate = new byte[(int)signerCertificateLen[0]];
                p7data = new byte[(int)p7dataLen[0]];
                sign = new byte[(int)signLen[0]];
                execflag = apiengine.BCA_Pkcs7_DecodeSignedData(bdecodeBlob, bdecodeBlob.length, signerCertificate, signerCertificateLen, digestAlgorithms, p7data, p7dataLen, sign, signLen);
            }
        }
        catch (Exception e) {
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u53d6\u7b7e\u540d\u4fe1\u5c01\u4fe1\u606f\u51fa\u9519!", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u53d6\u7b7e\u540d\u4fe1\u5c01\u4fe1\u606f\u51fa\u9519!", e);
            throw new Pkcs7DecodeException("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef,\u53d6\u7b7e\u540d\u4fe1\u5c01\u4fe1\u606f\u51fa\u9519!");
        }
        if (execflag != 0) {
            this.errorlog("\u53d6\u7b7e\u540d\u4fe1\u5c01\u4fe1\u606f\u51fa\u9519!");
            this.debuglog("\u53d6\u7b7e\u540d\u4fe1\u5c01\u4fe1\u606f\u51fa\u9519!");
            throw new Pkcs7DecodeException("\u53d6\u7b7e\u540d\u4fe1\u5c01\u4fe1\u606f\u51fa\u9519!");
        }
        String p7dataString = this.BJE_Pkcs7Decode(apiengine, p7data, p7data.length);
        String signerCertificateString = base64Util.BJS_EncodeBase64(signerCertificate);
        String signString = base64Util.BJS_EncodeBase64(sign);
        infoList.add(p7dataString);
        infoList.add(signerCertificateString);
        infoList.add(signString);
        return infoList;
    }

    public String BJE_Pkcs7EncodeEnvelope(BjcaApiEngine apiengine, String toBeEncryptedBlob, byte[] cert, long encryptMethod) throws Base64Exception, Pkcs7EncodeException, Pkcs7EncodeEnvelopeException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String sdata = null;
        byte[] outData = null;
        long[] outDataLen = new long[1];
        byte[] bp7data = this.BJE_Pkcs7Encode(apiengine, toBeEncryptedBlob);
        int execflag = 0;
        try {
            execflag = apiengine.BCA_Pkcs7_EncodeEnvelopedData(bp7data, bp7data.length, cert, cert.length, encryptMethod, outData, outDataLen);
            if (execflag == 0) {
                outData = new byte[(int)outDataLen[0]];
                execflag = apiengine.BCA_Pkcs7_EncodeEnvelopedData(bp7data, bp7data.length, cert, cert.length, encryptMethod, outData, outDataLen);
            }
        }
        catch (Exception e) {
            sdata = null;
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,\u751f\u6210\u6570\u5b57\u4fe1\u5c01\u51fa\u9519!", e);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,\u751f\u6210\u6570\u5b57\u4fe1\u5c01\u51fa\u9519!", e);
            throw new Pkcs7EncodeEnvelopeException("\u5e95\u5c42\u5e93\u51fa\u9519,\u751f\u6210\u6570\u5b57\u4fe1\u5c01\u51fa\u9519!");
        }
        if (execflag != 0) {
            sdata = null;
            this.errorlog("\u751f\u6210\u6570\u5b57\u4fe1\u5c01\u51fa\u9519!");
            this.debuglog("\u751f\u6210\u6570\u5b57\u4fe1\u5c01\u51fa\u9519!");
            throw new Pkcs7EncodeEnvelopeException("\u751f\u6210\u6570\u5b57\u4fe1\u5c01\u51fa\u9519!");
        }
        sdata = base64Util.BJS_EncodeBase64(outData);
        return sdata;
    }

    /*
     * Unable to fully structure code
     */
    public String BJE_Pkcs7DecodeEnvelope(BjcaApiEngine apiengine, String beEncryptedBlob, int m_Iinitmodel, String m_password, byte[] m_encryptPfx, String m_container) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException {
        base64Util = new Base64Util(this.applicationName);
        sdata = null;
        outData = null;
        outDataLen = new long[1];
        bdecodeBlob = base64Util.BJS_DecodeBase64(beEncryptedBlob);
        execflag = 0;
        if (m_Iinitmodel == 3) {
            pin = m_password.getBytes();
            bpix = m_encryptPfx;
            try {
                execflag = apiengine.BCA_Pkcs7_DecodeEnvelopedDataByP12(bpix, bpix.length, pin, pin.length, bdecodeBlob, bdecodeBlob.length, outData, outDataLen);
                if (execflag != 0) ** GOTO lbl45
                outData = new byte[(int)outDataLen[0]];
                execflag = apiengine.BCA_Pkcs7_DecodeEnvelopedDataByP12(bpix, bpix.length, pin, pin.length, bdecodeBlob, bdecodeBlob.length, outData, outDataLen);
            }
            catch (Exception e) {
                sdata = null;
                this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01", e);
                this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01", e);
                throw new Pkcs7DecodeEnvelopeException("\u5e95\u5c42\u5e93\u51fa\u9519,\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01");
            }
        } else if (m_Iinitmodel == 2) {
            try {
                System.out.println("0000");
                execflag = apiengine.BCA_Pkcs7_DecodeEnvelopedData(m_container.getBytes(), m_container.length(), 0L, bdecodeBlob, bdecodeBlob.length, outData, outDataLen);
                if (execflag != 0) ** GOTO lbl45
                outData = new byte[(int)outDataLen[0]];
                execflag = apiengine.BCA_Pkcs7_DecodeEnvelopedData(m_container.getBytes(), m_container.length(), 0L, bdecodeBlob, bdecodeBlob.length, outData, outDataLen);
            }
            catch (Exception e) {
                sdata = null;
                this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01", e);
                this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01", e);
                throw new Pkcs7DecodeEnvelopeException("\u5e95\u5c42\u5e93\u51fa\u9519,\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01");
            }
        } else {
            try {
                execflag = apiengine.BCA_Pkcs7_DecodeEnvelopedData(m_container.getBytes(), m_container.length(), 1L, bdecodeBlob, bdecodeBlob.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = apiengine.BCA_Pkcs7_DecodeEnvelopedData(m_container.getBytes(), m_container.length(), 1L, bdecodeBlob, bdecodeBlob.length, outData, outDataLen);
                }
            }
            catch (Exception e) {
                sdata = null;
                this.errorlog("\u5e95\u5c42\u5e93\u51fa\u9519,\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01", e);
                this.debuglog("\u5e95\u5c42\u5e93\u51fa\u9519,\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01", e);
                throw new Pkcs7DecodeEnvelopeException("\u5e95\u5c42\u5e93\u51fa\u9519,\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01");
            }
        }
lbl45:
        // 5 sources

        if (execflag != 0) {
            sdata = null;
            this.errorlog("\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01");
            this.debuglog("\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01");
            throw new Pkcs7DecodeEnvelopeException("\u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u51fa\u9519\uff01");
        }
        sdata = this.BJE_Pkcs7Decode(apiengine, outData, outDataLen[0]);
        return sdata;
    }

    public String BJE_Pkcs7EncodeEnvelopeEx(BjcaApiEngine apiengine, String toBeEncryptedBlob, byte[] cert) {
        Base64Util base64Util = new Base64Util(this.applicationName);
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        String sdata = null;
        try {
            byte[] key = numberUtil.BJK_GenRandomBytes(apiengine, 8);
            byte[] binfo = null;
            long[] infoLen = new long[1];
            int execflag = apiengine.BCA_GetCertificateInfo(cert, cert.length, 20L, binfo, infoLen);
            if (execflag == 0) {
                binfo = new byte[(int)infoLen[0]];
                execflag = apiengine.BCA_GetCertificateInfo(cert, cert.length, 20L, binfo, infoLen);
            }
            if (execflag != 0) {
                this.errorlog("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
                this.debuglog("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
                throw new Exception("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
            }
            byte[] outData = null;
            long[] outDataLen = new long[1];
            execflag = apiengine.BCA_Pkcs1RsaPublicKeyEnc(binfo, infoLen[0], key, key.length, outData, outDataLen);
            if (execflag == 0) {
                outData = new byte[(int)outDataLen[0]];
                execflag = apiengine.BCA_Pkcs1RsaPublicKeyEnc(binfo, infoLen[0], key, key.length, outData, outDataLen);
            }
            if (execflag != 0) {
                this.errorlog("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
                this.debuglog("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
                throw new Exception("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
            }
            long[] SymmKeyObj = new long[1];
            byte[] iv = new byte[8];
            for (int i = 0; i < 8; ++i) {
                iv[i] = 49;
            }
            execflag = apiengine.BCA_CreateSymmKeyObj(SymmKeyObj, 100L, 1L, 1L, key, key.length, iv);
            if (execflag != 0) {
                this.errorlog("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
                this.debuglog("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
                throw new Exception("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
            }
            byte[] symOutData = null;
            long[] symOutDataLen = new long[1];
            execflag = apiengine.BCA_SymmEncrypt(SymmKeyObj[0], toBeEncryptedBlob.getBytes(), toBeEncryptedBlob.length(), symOutData, symOutDataLen);
            if (execflag == 0) {
                symOutData = new byte[(int)symOutDataLen[0]];
                execflag = apiengine.BCA_SymmEncrypt(SymmKeyObj[0], toBeEncryptedBlob.getBytes(), toBeEncryptedBlob.length(), symOutData, symOutDataLen);
            }
            if (execflag != 0) {
                this.errorlog("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
                this.debuglog("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
                throw new Exception("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519");
            }
            apiengine.BCA_DestroySymmKeyObj(SymmKeyObj[0]);
            int p7outDataLen = 4 + (int)outDataLen[0] + (int)symOutDataLen[0];
            byte[] p7outData = new byte[p7outDataLen];
            ByteBuffer buf = ByteBuffer.allocate(p7outDataLen);
            String strKeyLen = String.valueOf((int)outDataLen[0]);
            buf.put(strKeyLen.getBytes());
            buf.position(4);
            buf.put(outData, 0, (int)outDataLen[0]);
            buf.put(symOutData, 0, (int)symOutDataLen[0]);
            p7outData = buf.array();
            sdata = base64Util.BJS_EncodeBase64(p7outData);
        }
        catch (Exception e) {
            sdata = null;
            this.errorlog("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519", e);
            this.debuglog("\u751f\u6210\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01\u51fa\u9519", e);
        }
        return sdata;
    }

    public String BJE_Pkcs7DecodeEnvelopeEx(BjcaApiEngine apiengine, String beEncryptedBlob, int m_Iinitmodel, String m_password, String m_container, byte[] m_encryptPfx) {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String sdata = null;
        try {
            byte[] outData = null;
            long[] outDataLen = new long[1];
            byte[] bdecodeBlob = base64Util.BJS_DecodeBase64(beEncryptedBlob);
            ByteBuffer buf = ByteBuffer.wrap(bdecodeBlob);
            byte[] strKeyLen = new byte[4];
            buf.get(strKeyLen, 0, 4);
            int keyLen = Integer.parseInt(new String(strKeyLen, 0, 3));
            buf.position(4);
            byte[] key = new byte[keyLen];
            buf.get(key, 0, keyLen);
            byte[] symData = new byte[bdecodeBlob.length - 4 - keyLen];
            buf.get(symData);
            if (m_Iinitmodel == 3) {
                byte[] bpix = m_encryptPfx;
                int execflag = apiengine.BCA_Pkcs1RsaPrivateKeyDecByPkcs12(m_password.getBytes(), m_password.length(), bpix, bpix.length, key, key.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = apiengine.BCA_Pkcs1RsaPrivateKeyDecByPkcs12(m_password.getBytes(), m_password.length(), bpix, bpix.length, key, key.length, outData, outDataLen);
                }
                if (execflag != 0) {
                    this.errorlog("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
                    this.debuglog("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
                    throw new Exception("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
                }
            } else {
                int execflag = apiengine.BCA_Pkcs1RsaPrivateKeyDec(m_container.getBytes(), m_container.length(), 1L, m_password.getBytes(), m_password.length(), key, key.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = apiengine.BCA_Pkcs1RsaPrivateKeyDec(m_container.getBytes(), m_container.length(), 1L, m_password.getBytes(), m_password.length(), key, key.length, outData, outDataLen);
                }
                if (execflag != 0) {
                    this.errorlog("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
                    this.debuglog("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
                    throw new Exception("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
                }
            }
            byte[] symkey = new byte[(int)outDataLen[0]];
            System.arraycopy(outData, 0, symkey, 0, (int)outDataLen[0]);
            byte[] iv = new byte[8];
            for (int i = 0; i < 8; ++i) {
                iv[i] = 49;
            }
            long[] SymmKeyObj = new long[1];
            int execflag = apiengine.BCA_CreateSymmKeyObj(SymmKeyObj, 100L, 1L, 1L, symkey, symkey.length, iv);
            if (execflag != 0) {
                this.errorlog("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
                this.debuglog("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
                throw new Exception("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
            }
            byte[] symOutData = null;
            long[] symOutDataLen = new long[1];
            execflag = apiengine.BCA_SymmDecrypt(SymmKeyObj[0], symData, symData.length, symOutData, symOutDataLen);
            if (execflag == 0) {
                symOutData = new byte[(int)symOutDataLen[0]];
                execflag = apiengine.BCA_SymmDecrypt(SymmKeyObj[0], symData, symData.length, symOutData, symOutDataLen);
            }
            if (execflag != 0) {
                this.errorlog("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
                this.debuglog("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
                throw new Exception("\u89e3\u5bc6\u81ea\u5b9a\u4e49\u6570\u5b57\u4fe1\u5c01,\u51fa\u9519");
            }
            sdata = new String(symOutData, 0, (int)symOutDataLen[0]);
            apiengine.BCA_DestroySymmKeyObj(SymmKeyObj[0]);
        }
        catch (Exception e) {
            sdata = null;
            this.errorlog("", e);
            this.debuglog("", e);
        }
        return sdata;
    }

    public String BJE_Pkcs7EncodeSignAndEnvelope(BjcaApiEngine apiengine, String toBeEncodedBlob, byte[] cert, int m_Iinitmodel, String m_password, byte[] m_signPfx, byte[] m_signCertBytes, String m_keyType, String m_container) {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String sdata = null;
        try {
            byte[] outData = null;
            long[] outDataLen = new long[1];
            byte[] bp7data = this.BJE_Pkcs7Encode(apiengine, toBeEncodedBlob);
            if (m_Iinitmodel == 3) {
                byte[] bder;
                byte[] bpix = m_signPfx;
                byte[] pin = m_password.getBytes();
                int execflag = apiengine.BCA_Pkcs7_EncodeSignAndEnvelopedDataByP12(bpix, bpix.length, pin, pin.length, 3L, bder = m_signCertBytes, bder.length, 100L, cert, cert.length, bp7data, bp7data.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = apiengine.BCA_Pkcs7_EncodeSignAndEnvelopedDataByP12(bpix, bpix.length, pin, pin.length, 3L, bder, bder.length, 100L, cert, cert.length, bp7data, bp7data.length, outData, outDataLen);
                }
                if (execflag != 0) {
                    this.errorlog("\u751f\u6210P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                    this.debuglog("\u751f\u6210P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                    throw new Exception("\u751f\u6210P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                }
            } else {
                byte[] bder = m_signCertBytes;
                long keyUsage = Integer.parseInt(m_keyType) == 1 ? 1L : 2L;
                int execflag = apiengine.BCA_Pkcs7_EncodeSignAndEnvelopedData(m_container.getBytes(), m_container.length(), keyUsage, bder, bder.length, 3L, 100L, cert, cert.length, bp7data, bp7data.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = apiengine.BCA_Pkcs7_EncodeSignAndEnvelopedData(m_container.getBytes(), m_container.length(), keyUsage, bder, bder.length, 3L, 100L, cert, cert.length, bp7data, bp7data.length, outData, outDataLen);
                }
                if (execflag != 0) {
                    this.errorlog("\u751f\u6210P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                    this.debuglog("\u751f\u6210P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                    throw new Exception("\u751f\u6210P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                }
            }
            sdata = base64Util.BJS_EncodeBase64(outData);
        }
        catch (Exception e) {
            sdata = null;
            this.errorlog("\u751f\u6210P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519", e);
            this.debuglog("\u751f\u6210P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519", e);
        }
        return sdata;
    }

    public String BJE_Pkcs7DecodeSignAndEnvelope(BjcaApiEngine apiengine, String beEncodedBlob, int m_Iinitmodel, String m_password, String m_container, byte[] m_encryptPfx) {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String sdata = null;
        try {
            byte[] signerCertificate = null;
            long[] signerCertificateLen = new long[1];
            byte[] p7data = null;
            long[] p7dataLen = new long[1];
            byte[] sign = null;
            long[] signLen = new long[1];
            long[] digestAlgorithms = new long[1];
            byte[] bdecodeBlob = base64Util.BJS_DecodeBase64(beEncodedBlob);
            if (m_Iinitmodel == 3) {
                byte[] bpix = m_encryptPfx;
                byte[] pin = m_password.getBytes();
                int execflag = apiengine.BCA_Pkcs7_DecodeSignAndEnvelopedDataByP12(bdecodeBlob, bdecodeBlob.length, bpix, bpix.length, pin, pin.length, signerCertificate, signerCertificateLen, digestAlgorithms, sign, signLen, p7data, p7dataLen);
                if (execflag == 0) {
                    signerCertificate = new byte[(int)signerCertificateLen[0]];
                    p7data = new byte[(int)p7dataLen[0]];
                    sign = new byte[(int)signLen[0]];
                    execflag = apiengine.BCA_Pkcs7_DecodeSignAndEnvelopedDataByP12(bdecodeBlob, bdecodeBlob.length, bpix, bpix.length, pin, pin.length, signerCertificate, signerCertificateLen, digestAlgorithms, sign, signLen, p7data, p7dataLen);
                }
                if (execflag != 0) {
                    this.errorlog("\u89e3\u5bc6P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                    this.debuglog("\u89e3\u5bc6P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                    throw new Exception("\u89e3\u5bc6P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                }
            } else {
                int execflag = apiengine.BCA_Pkcs7_DecodeSignAndEnvelopedData(bdecodeBlob, bdecodeBlob.length, m_container.getBytes(), m_container.length(), 1L, signerCertificate, signerCertificateLen, digestAlgorithms, sign, signLen, p7data, p7dataLen);
                if (execflag == 0) {
                    signerCertificate = new byte[(int)signerCertificateLen[0]];
                    p7data = new byte[(int)p7dataLen[0]];
                    sign = new byte[(int)signLen[0]];
                    execflag = apiengine.BCA_Pkcs7_DecodeSignAndEnvelopedData(bdecodeBlob, bdecodeBlob.length, m_container.getBytes(), m_container.length(), 1L, signerCertificate, signerCertificateLen, digestAlgorithms, sign, signLen, p7data, p7dataLen);
                }
                if (execflag != 0) {
                    this.errorlog("\u89e3\u5bc6P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                    this.debuglog("\u89e3\u5bc6P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                    throw new Exception("\u89e3\u5bc6P7\u7b7e\u540d\u52a0\u5bc6\u51fa\u9519");
                }
            }
            sdata = this.BJE_Pkcs7Decode(apiengine, p7data, p7dataLen[0]);
        }
        catch (Exception e) {
            sdata = null;
            this.errorlog("", e);
            this.debuglog("", e);
        }
        return sdata;
    }
}

