/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.jni.security;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import sun.misc.BASE64Decoder;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.bjcasafeapi.BjcaApiEngine;
import xjyb.cn.org.bjca.config.ValueProvider;
import xjyb.cn.org.bjca.config.XmlConfig;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.exception.FinalizeException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.InitException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.RandomNumberException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.SecretRecoveryException;
import xjyb.cn.org.bjca.exception.SecretSegmentException;
import xjyb.cn.org.bjca.exception.TsException;
import xjyb.cn.org.bjca.exception.ValidateCertException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.framework.Log;
import xjyb.cn.org.bjca.jni.utils.CryptoUtil;
import xjyb.cn.org.bjca.jni.utils.FileUtil;
import xjyb.cn.org.bjca.jni.utils.HashUtil;
import xjyb.cn.org.bjca.jni.utils.NumberUtil;
import xjyb.cn.org.bjca.jni.utils.Pkcs7Util;
import xjyb.cn.org.bjca.jni.utils.RsaUtil;
import xjyb.cn.org.bjca.jni.utils.SecretUtil;
import xjyb.cn.org.bjca.jni.utils.TsUtil;
import xjyb.cn.org.bjca.jni.utils.XMLSignUtil;
import xjyb.cn.org.bjca.security.SecurityUtil;
import xjyb.cn.org.bjca.security.SuperEngine;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.CertificateUtil;
import xjyb.cn.org.bjca.utils.GetPathUtil;
import xjyb.com.bjca.security.exception.SecurityEngineException;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.util.P7bUtil;

public class SecurityEngine
extends Log {
    private BjcaApiEngine apiEngine = null;
    private static final int logon_mode = 1;
    public int m_Iinitmodel = 3;
    private String debug = "false";
    private String m_container = null;
    private String m_appName = null;
    private String m_devType = null;
    private String m_password = null;
    private String m_keyType = null;
    private String m_provider = null;
    private String m_privateDll = null;
    private int m_policytype = 2;
    private ArrayList m_catypeList = null;
    private ArrayList trustObjectList = null;
    private Properties m_appProhibitsList = null;
    private String m_verifyTime = null;
    private String m_uniqidoid = null;
    private byte[] m_signCertBytes = null;
    private byte[] m_encryptCertBytes = null;
    private byte[] m_encryptPfx = null;
    private byte[] m_signPfx = null;
    private ArrayList p7List;
    private String allP7b;

    public SecurityEngine(String appName) {
        super(appName);
    }

    public BjcaApiEngine initialApp(String appName) throws JDOMException, IOException, InitException {
        if (XmlConfig.version == null) {
            XmlConfig.loadConfig();
        }
        this.setAppValue(appName);
        this.debuglog("\u521d\u59cb\u5316JNI\u51fd\u6570\u53c2\u6570 == ");
        this.debuglog("m_Iinitmodel == " + this.m_Iinitmodel);
        this.debuglog("m_provider == " + this.m_provider);
        this.debuglog("logon_mode == 1");
        this.debuglog("m_privateDll == " + this.m_privateDll);
        this.apiEngine = new BjcaApiEngine();
        long execflag = this.apiEngine.BCA_Initialize(this.m_Iinitmodel, this.m_provider, 1, this.m_privateDll);
        if (execflag != 0L) {
            this.errorlog("Fail to initialize dynamic link libraries");
            this.debuglog("Fail to initialize dynamic link libraries");
            return null;
        }
        boolean isCertSuccess = false;
        if (this.m_encryptCertBytes == null) {
            isCertSuccess = this.initSvrCert();
        }
        boolean isP7Success = this.initP7Cert();
        if (!isCertSuccess || !isP7Success) {
            return null;
        }
        return this.apiEngine;
    }

    public void setAppValue(String appName) {
        Properties webApp = (Properties)XmlConfig.getListWebapps().get(appName);
        this.m_appName = appName;
        this.debug = webApp.getProperty("debug");
        if ("false".equals(this.debug)) {
            LoggerUtil.setDebug(this.m_appName, "false");
            this.debuglog("Debug log closed!");
        } else if ("true".equals(this.debug)) {
            LoggerUtil.setDebug(this.m_appName, "true");
            this.debuglog("Debug log opened!");
        }
        this.m_container = webApp.getProperty("container");
        this.m_password = ((Properties)XmlConfig.getListCerts().get(this.m_container)).getProperty("password");
        this.m_keyType = ((Properties)XmlConfig.getListCerts().get(this.m_container)).getProperty("keytype");
        String devicename = ((Properties)XmlConfig.getListCerts().get(this.m_container)).getProperty("devicename");
        this.m_devType = ((Properties)XmlConfig.getListDevices().get(devicename)).getProperty("providertype");
        this.m_Iinitmodel = Integer.parseInt(this.m_devType);
        this.m_provider = ((Properties)XmlConfig.getListDevices().get(devicename)).getProperty("provider");
        this.m_privateDll = ((Properties)XmlConfig.getListDevices().get(devicename)).getProperty("privatedll");
        this.m_verifyTime = webApp.getProperty("verifytime");
        String policytype = webApp.getProperty("policytype");
        if (policytype != null) {
            this.m_policytype = Integer.parseInt(policytype);
        }
        this.m_catypeList = ValueProvider.getAllTrustName(appName);
        this.trustObjectList = ValueProvider.getAllTrust(appName);
        this.m_appProhibitsList = (Properties)XmlConfig.getListWebappsProhibits().get(appName);
        this.m_uniqidoid = webApp.getProperty("uniqidoid");
    }

    public boolean loginApp() throws InitException {
        byte[] bp;
        int execflag;
        if (this.apiEngine == null) {
            this.errorlog("Failed to initialize,apiEngine is null !");
            this.debuglog("Failed to initialize,apiEngine is null !");
            return false;
        }
        if (this.m_Iinitmodel != 3 && (execflag = this.apiEngine.BCA_Login(bp = this.m_password.getBytes(), bp.length)) != 0) {
            this.errorlog("Failed to initialize,Login error");
            this.debuglog("Failed to initialize,Login error");
            return false;
        }
        return true;
    }

    private boolean initSvrCert() {
        GetPathUtil getPathUtil = new GetPathUtil(this.applicationName);
        FileUtil fileUtil = new FileUtil(this.applicationName);
        boolean succ = true;
        byte[] certificate = null;
        long[] certificateLen = new long[1];
        byte[] signcertificate = null;
        long[] signcertificateLen = new long[1];
        int keyUsage = Integer.parseInt(this.m_keyType);
        if (this.m_Iinitmodel == 3) {
            String pixpath = null;
            String derpath = null;
            pixpath = getPathUtil.getDiskExchPfx(this.m_container);
            derpath = getPathUtil.getDiskExchCert(this.m_container);
            this.m_encryptCertBytes = fileUtil.readFile(derpath);
            this.m_encryptPfx = fileUtil.readFile(pixpath);
            if (keyUsage == 1) {
                this.m_signCertBytes = this.m_encryptCertBytes;
                this.m_signPfx = this.m_encryptPfx;
            } else {
                pixpath = getPathUtil.getDiskSignPfx(this.m_container);
                derpath = getPathUtil.getDiskSignCert(this.m_container);
                this.m_signCertBytes = fileUtil.readFile(derpath);
                this.m_signPfx = fileUtil.readFile(pixpath);
            }
        } else {
            int execflag = this.apiEngine.BCA_GetUsrCertificate(this.m_container.getBytes(), this.m_container.getBytes().length, 0L, certificate, certificateLen);
            if (execflag == 0) {
                certificate = new byte[(int)certificateLen[0]];
                execflag = this.apiEngine.BCA_GetUsrCertificate(this.m_container.getBytes(), this.m_container.getBytes().length, 0L, certificate, certificateLen);
            }
            if (execflag != 0) {
                this.errorlog("Failed to initialize the encipherment certificate!");
                this.debuglog("Failed to initialize the encipherment certificate\uff01");
                return false;
            }
            this.m_encryptCertBytes = certificate;
            if (keyUsage == 1) {
                this.m_signCertBytes = this.m_encryptCertBytes;
            } else {
                execflag = this.apiEngine.BCA_GetUsrCertificate(this.m_container.getBytes(), this.m_container.getBytes().length, 2L, signcertificate, signcertificateLen);
                if (execflag == 0) {
                    signcertificate = new byte[(int)signcertificateLen[0]];
                    execflag = this.apiEngine.BCA_GetUsrCertificate(this.m_container.getBytes(), this.m_container.getBytes().length, 2L, signcertificate, signcertificateLen);
                }
                if (execflag != 0) {
                    this.errorlog("Fail to initialize the signature certificate!");
                    this.debuglog("Fail to initialize the signature certificate!");
                    return false;
                }
                this.m_signCertBytes = signcertificate;
            }
        }
        return succ;
    }

    public boolean initP7Cert() {
        try {
            FileUtil fileU = new FileUtil(this.applicationName);
            Base64Util base64Util = new Base64Util(this.applicationName);
            String path = GetPathUtil.getConfigPath();
            String realPath = path + "/Trust/p7b/" + this.applicationName;
            byte[] allP7file = fileU.readFile(realPath);
            String p7allInOne = new String(allP7file);
            ArrayList<X509CertificateStructure> appP7List = new ArrayList<X509CertificateStructure>();
            String realP7All = null;
            if (p7allInOne.substring(0, 1).equals("1")) {
                String p7All = p7allInOne.substring(4);
                realP7All = SecurityUtil.getInstance().encryptData("LjkyMDU2MjA2Ni42MDE3Mjk2NTkwODEy", p7All);
            } else {
                realP7All = this.decodeP7EnvelopedData(p7allInOne);
            }
            realP7All = this.decodeP7EnvelopedData(p7allInOne);
            StringTokenizer p7allOneSt = new StringTokenizer(realP7All, "###");
            while (p7allOneSt.hasMoreElements()) {
                String realp7 = p7allOneSt.nextElement().toString();
                byte[] p7Byte = base64Util.BJS_DecodeBase64(realp7);
                X509CertificateStructure[] p7certList = P7bUtil.getCertChain(p7Byte);
                int p7Len = p7certList.length;
                for (int i = 0; i < p7Len; ++i) {
                    if (p7certList[i] != null) continue;
                    fileU.writeFile((realp7 + "###").getBytes(), GetPathUtil.getConfigPath() + "/Trust/errorp7");
                    System.out.println("FIND ONE P7 CERT IS NULL!!!, MAYBE THE P7 CERT IS ERROR!!!");
                    this.debuglog("FIND ONE P7 CERT IS NULL!!!, MAYBE THE P7 CERT IS ERROR!!!");
                    this.errorlog("FIND ONE P7 CERT IS NULL!!!, MAYBE THE P7 CERT IS ERROR!!!");
                    break;
                }
                if (p7certList[0] == null) continue;
                appP7List.add(p7certList[0]);
            }
            this.allP7b = realP7All;
            this.p7List = appP7List;
        }
        catch (Exception e) {
            this.errorlog("Exception in initializing P7 certificate", e);
            this.debuglog("Exception in initializing P7 certificate");
            return false;
        }
        return true;
    }

    public void verifyCRL() {
        boolean isSuccess = false;
        ArrayList cloneP7List = (ArrayList)this.p7List.clone();
        Hashtable listCrl = (Hashtable)SuperEngine.listCrl.clone();
        for (int i = 0; i < this.m_catypeList.size(); ++i) {
            String caName = (String)this.m_catypeList.get(i);
            X509CRL crlObj = null;
            try {
                crlObj = (X509CRL)listCrl.get(caName);
            }
            catch (Exception e) {
                crlObj = null;
                this.errorlog("Exception in getting crl object from list", e);
                this.debuglog("Exception in getting crl object from list");
            }
            if (crlObj == null) {
                this.debuglog(caName + " CRL in memory is null !!!");
                System.out.println(caName + " CRL IS NULL !");
                isSuccess = true;
            } else {
                int p7Length = cloneP7List.size();
                for (int j = 0; j < p7Length; ++j) {
                    Certificate p7Obj = (Certificate)cloneP7List.get(j);
                    this.debuglog("P7 content in verifying CRL == " + p7Obj.hashCode());
                    PublicKey oPbKey = p7Obj.getPublicKey();
                    try {
                        crlObj.verify(oPbKey);
                        isSuccess = true;
                        break;
                    }
                    catch (Exception ex) {
                        isSuccess = false;
                        continue;
                    }
                }
            }
            this.debuglog(caName + " CRL verification result == " + isSuccess);
            if (isSuccess) continue;
            this.errorlog(caName + " crl is invalid !!!, need to update crl again!!!");
            System.out.println(caName + " CRL IS NOT VERIFIED!!! MUST UPDATE THE CRL AGAIN!!!");
        }
    }

    public boolean finalizeApp() {
        boolean isSuccess = true;
        try {
            if (this.apiEngine == null) {
                return true;
            }
            int execflag = this.apiEngine.BCA_Finalize();
            if (execflag != 0) {
                throw new FinalizeException("\u672c\u5730\u5e93\u91ca\u653e\u73af\u5883\u5931\u8d25");
            }
            this.apiEngine = null;
        }
        catch (FinalizeException fe) {
            isSuccess = false;
            this.errorlog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef\uff1a" + fe.getMessage(), fe);
            this.debuglog("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef\uff1a" + fe.getMessage());
        }
        catch (Exception e) {
            isSuccess = false;
            this.errorlog("\u9519\u8bef\u539f\u56e0\u662f\uff1a" + e.getMessage(), e);
            this.debuglog("\u9519\u8bef\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
        return isSuccess;
    }

    public int BJC_CheckCertValidaty(byte[] usrCert, String sDate) {
        int idate = 0;
        try {
            if (this.apiEngine == null) {
                throw new Exception("\u521d\u59cb\u5316\u5de5\u4f5c\u672a\u5b8c\u6210\uff01");
            }
            byte[] binfo = null;
            long[] infoLen = new long[1];
            String strdatefrom = null;
            String strdateto = null;
            int execflag = this.apiEngine.BCA_GetCertificateInfo(usrCert, usrCert.length, 11L, binfo, infoLen);
            if (execflag == 0) {
                binfo = new byte[(int)infoLen[0]];
                execflag = this.apiEngine.BCA_GetCertificateInfo(usrCert, usrCert.length, 11L, binfo, infoLen);
                strdatefrom = new String(binfo);
            }
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd");
            Date compDate = null;
            compDate = sDate == null || sDate.equals("") ? new Date() : dateformat.parse(sDate);
            Date datefrom = dateformat.parse(strdatefrom.substring(0, 4) + "/" + strdatefrom.substring(4, 6) + "/" + strdatefrom.substring(6, 8));
            long ldate = (compDate.getTime() - datefrom.getTime()) / 86400000L;
            if (ldate < 0L) {
                return (int)ldate;
            }
            execflag = this.apiEngine.BCA_GetCertificateInfo(usrCert, usrCert.length, 12L, binfo, infoLen);
            if (execflag == 0) {
                binfo = new byte[(int)infoLen[0]];
                execflag = this.apiEngine.BCA_GetCertificateInfo(usrCert, usrCert.length, 12L, binfo, infoLen);
                strdateto = new String(binfo);
            }
            Date dateto = dateformat.parse(strdateto.substring(0, 4) + "/" + strdateto.substring(4, 6) + "/" + strdateto.substring(6, 8));
            ldate = (dateto.getTime() - compDate.getTime()) / 86400000L;
            idate = (int)ldate;
            if (execflag != 0) {
                this.errorlog("\u53d6\u8bc1\u4e66\u6709\u6548\u671f\u65f6\u95f4\u51fa\u9519\uff01");
                this.debuglog("\u53d6\u8bc1\u4e66\u6709\u6548\u671f\u65f6\u95f4\u51fa\u9519\uff01");
                throw new Exception("\u53d6\u8bc1\u4e66\u6709\u6548\u671f\u65f6\u95f4\u51fa\u9519\uff01");
            }
        }
        catch (Exception e) {
            this.errorlog("\u9519\u8bef\u539f\u56e0\u662f\uff1a" + e.getMessage());
            this.debuglog("\u9519\u8bef\u539f\u56e0\u662f\uff1a" + e.getMessage());
            idate = 0;
        }
        return idate;
    }

    public String getRandomString() throws RandomNumberException, Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(this.apiEngine, 10);
        String randomString = base64Util.BJS_EncodeBase64(random);
        return randomString;
    }

    public byte[] getRandomByte() throws RandomNumberException {
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(this.apiEngine, 10);
        return random;
    }

    public String getRandomString(int len) throws RandomNumberException, Base64Exception {
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(this.apiEngine, len);
        String randomString = base64Util.BJS_EncodeBase64(random);
        return randomString;
    }

    public byte[] getRandomByte(int len) throws RandomNumberException {
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(this.apiEngine, len);
        return random;
    }

    public String BJC_GetUniqIdOidByCAId(String caId) {
        Properties trustCert = ValueProvider.getTrustCert(caId);
        String uniqidoid = trustCert.getProperty("uniqidoid");
        return uniqidoid;
    }

    public String getCertInfo(String base64Cert, int type) throws Base64Exception, GetCertInfoException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certificatUtil = new CertificateUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64Cert);
        String certInfo = certificatUtil.BJC_GetBasicCertInfo(certbuf, type);
        return certInfo;
    }

    public String getCertInfoByOid(String base64Cert, String oid) throws Base64Exception, GetCertInfoException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certificatUtil = new CertificateUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64Cert);
        String info = certificatUtil.BJC_GetExtCertInfo(certbuf, oid);
        return info;
    }

    public int validateCert(String base64EncodeCert) throws Base64Exception, CertificateException, ValidateCertException, GetCertInfoException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certificatUtil = new CertificateUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        return 0;
    }

    public String signDataPkcs1(String Content, long signMethod) throws Base64Exception, HashException, RsaSignException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        String signdata = rsaUtil.BJK_RsaSign(this.apiEngine, Content.getBytes(), signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_keyType, this.m_container);
        return signdata;
    }

    public String signDataPkcs1(byte[] Content, long signMethod) throws Base64Exception, HashException, RsaSignException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        String signdata = rsaUtil.BJK_RsaSign(this.apiEngine, Content, signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_keyType, this.m_container);
        return signdata;
    }

    public boolean verifySignedDataPkcs1(String Content, String signature, String cert, long signMethod) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(cert);
        boolean ret = rsaUtil.BJK_RsaVerify(this.apiEngine, Content.getBytes(), signature, certbuf, signMethod);
        return ret;
    }

    public boolean verifySignedDataPkcs1(byte[] Content, String signature, String cert, long signMethod) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(cert);
        boolean ret = rsaUtil.BJK_RsaVerify(this.apiEngine, Content, signature, certbuf, signMethod);
        return ret;
    }

    public String signFile(String inFile, long signMethod) throws HashException, RsaSignException, Base64Exception {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        String signdata = rsaUtil.BJK_RsaSign_File(this.apiEngine, inFile, signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_keyType, this.m_container);
        return signdata;
    }

    public String hashFile(String inFile, long signMethod) throws HashException, RsaSignException, Base64Exception {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        byte[] hashData = hashUtil.BJS_HashFile(this.apiEngine, signMethod, inFile);
        Base64Util base64Util = new Base64Util(this.applicationName);
        String hashValue = base64Util.BJS_EncodeBase64(hashData);
        return hashValue;
    }

    public boolean verifySignedFile(String base64EncodeCert, String inFile, String signValue, long signMethod) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        boolean ret = rsaUtil.BJK_RsaVerify_File(this.apiEngine, inFile, signValue, base64EncodeCert, signMethod);
        return ret;
    }

    public String secretSegment(String secert, int m, int n, int k) throws SecretSegmentException {
        SecretUtil secretUtil = new SecretUtil(this.applicationName);
        return secretUtil.BJ_SecertSegment(this.apiEngine, secert, m, n, k);
    }

    public String secretRecovery(String seg) throws SecretRecoveryException {
        SecretUtil secretUtil = new SecretUtil(this.applicationName);
        return secretUtil.BJ_SecertRecovery(this.apiEngine, seg);
    }

    public String encryptData(String key, String inData, long encryptMethod) throws EncryptDataException, IOException, Base64Exception {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        sKey = new BASE64Decoder().decodeBuffer(key);
        String sdata = cryptoUtil.BJS_SymmEncrypt(this.apiEngine, encryptMethod, 1L, sKey, sKey.length, iv, inData.getBytes());
        return sdata;
    }

    public String decryptData(String key, String inData, long decryptMethod) throws DecryptDataException, Base64Exception, IOException {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        sKey = new BASE64Decoder().decodeBuffer(key);
        byte[] sdata = cryptoUtil.BJS_SymmDecrypt(this.apiEngine, decryptMethod, 1L, sKey, sKey.length, iv, inData);
        String outData = new String(sdata);
        return outData;
    }

    public boolean encryptFile(String key, String inFile, String outFile, long encryptMethod) throws Base64Exception, EncryptDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        FileUtil fileUtil = new FileUtil(this.applicationName);
        byte[] keybuf = base64Util.BJS_DecodeBase64(key);
        boolean rv = fileUtil.BJS_SymmEncFile(this.apiEngine, inFile, outFile, keybuf, encryptMethod, 1L);
        return rv;
    }

    public boolean decryptFile(String key, String inFile, String outFile, long encryptMethod) throws Base64Exception, DecryptDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        FileUtil fileUtil = new FileUtil(this.applicationName);
        byte[] keybuf = base64Util.BJS_DecodeBase64(key);
        boolean rv = fileUtil.BJS_SymmDecFile(this.apiEngine, inFile, outFile, keybuf, encryptMethod, 1L);
        return rv;
    }

    public String pubKeyEncrypt(String base64EncodeCert, String inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        byte[] sdata = rsaUtil.BJK_RsaEncrypt(this.apiEngine, inData.getBytes(), certbuf);
        return base64Util.BJS_EncodeBase64(sdata);
    }

    public byte[] pubKeyEncrypt(String base64EncodeCert, byte[] inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        byte[] sdata = rsaUtil.BJK_RsaEncrypt(this.apiEngine, inData, certbuf);
        return sdata;
    }

    public String priKeyDecrypt(String inData) throws Base64Exception, RsaDecryptException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        String sdata = rsaUtil.BJK_RsaDecrypt(this.apiEngine, inData, this.m_Iinitmodel, this.m_password, this.m_container, this.m_encryptPfx);
        return sdata;
    }

    public byte[] hashAll(ArrayList fileList, ArrayList stringList, long signMethod) {
        FileUtil fileUtil = new FileUtil(this.applicationName);
        HashUtil hu = new HashUtil(this.applicationName);
        byte[] hashbuf = null;
        try {
            int i;
            hu.BJS_HashInit(this.apiEngine, signMethod);
            for (i = 0; i < fileList.size(); ++i) {
                String filePath = fileList.get(i).toString();
                byte[] inbuf = fileUtil.readFile(filePath);
                hu.BJS_HashUpdate(this.apiEngine, inbuf, inbuf.length);
            }
            for (i = 0; i < stringList.size(); ++i) {
                String str = stringList.get(i).toString();
                hu.BJS_HashUpdate(this.apiEngine, str.getBytes(), str.getBytes().length);
            }
            hashbuf = hu.BJS_HashFinal(this.apiEngine);
        }
        catch (Exception e) {
            this.errorlog("Exception in hashAll", e);
            this.debuglog("Exception in hashAll");
            return null;
        }
        return hashbuf;
    }

    public String signAll(ArrayList fileList, ArrayList stringList, long signMethod) throws RsaSignException, Base64Exception {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] hashbuf = this.hashAll(fileList, stringList, signMethod);
        byte[] signData = rsaUtil.BJK_RsaSignNoHash(this.apiEngine, hashbuf, signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_keyType, this.m_container);
        String signString = base64Util.BJS_EncodeBase64(signData);
        return signString;
    }

    public boolean verifySignAll(ArrayList fileList, ArrayList stringList, String base64EncodeCert, String signValue, long signMethod) throws Base64Exception, GetCertInfoException, VerifySignDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        byte[] hashbuf = this.hashAll(fileList, stringList, signMethod);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        byte[] sginbuf = base64Util.BJS_DecodeBase64(signValue);
        boolean isSuccess = rsaUtil.BJK_RsaVerifyNoHash(this.apiEngine, hashbuf, sginbuf, certbuf, signMethod);
        return isSuccess;
    }

    public String getTotalTsReq(ArrayList fileList, ArrayList stringList, long signMethod) throws TsException, Base64Exception {
        TsUtil tsUtil = new TsUtil(this.applicationName);
        byte[] hashbuf = this.hashAll(fileList, stringList, signMethod);
        String sdata = tsUtil.BJT_TSRequest(this.apiEngine, hashbuf, hashbuf.length, signMethod);
        return sdata;
    }

    public String signDataPkcs7(String inData, long signMethod) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        byte[] conbuf = inData.getBytes();
        String p7signdata = pkcs7Util.BJE_Pkcs7Sign(this.apiEngine, conbuf, conbuf.length, signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_signCertBytes, this.m_keyType, this.m_container);
        return p7signdata;
    }

    public String signDataPkcs7Base64(String inData, long signMethod) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] conbuf = base64Util.BJS_DecodeBase64(inData);
        String p7signdata = pkcs7Util.BJE_Pkcs7Sign(this.apiEngine, conbuf, conbuf.length, signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_signCertBytes, this.m_keyType, this.m_container);
        return p7signdata;
    }

    public boolean verifySignedDataPkcs7(String pkcs7SignData) throws Base64Exception, Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        boolean isSuccess = pkcs7Util.BJE_Pkcs7Verify(this.apiEngine, pkcs7SignData);
        return isSuccess;
    }

    public String verifySignedDataPkcs7_cert(String pkcs7SignData) throws Base64Exception, Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        String cert = pkcs7Util.BJE_Pkcs7Verify_Cert(this.apiEngine, pkcs7SignData);
        return cert;
    }

    public String encodeP7EnvelopedData(String base64EncodeCert, String inData, long encryptMethod) throws Base64Exception, Pkcs7EncodeException, Pkcs7EncodeEnvelopeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        String p7envdata = pkcs7Util.BJE_Pkcs7EncodeEnvelope(this.apiEngine, inData, certbuf, encryptMethod);
        return p7envdata;
    }

    public String decodeP7EnvelopedData(String inData) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        String p7envdata = pkcs7Util.BJE_Pkcs7DecodeEnvelope(this.apiEngine, inData, this.m_Iinitmodel, this.m_password, this.m_encryptPfx, this.m_container);
        return p7envdata;
    }

    public String encodeSignAndEnvelopeData(String base64EncodeCert, String inData) throws Base64Exception {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        String p7envdata = pkcs7Util.BJE_Pkcs7EncodeSignAndEnvelope(this.apiEngine, inData, certbuf, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_signCertBytes, this.m_keyType, this.m_container);
        return p7envdata;
    }

    public String decodeSignAndEnvelopeData(String beEncodedBlob) {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        String outData = pkcs7Util.BJE_Pkcs7DecodeSignAndEnvelope(this.apiEngine, beEncodedBlob, this.m_Iinitmodel, this.m_password, this.m_container, this.m_encryptPfx);
        return outData;
    }

    public String decodeP7EnvelopedExData(String beEncryptedBlob) {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        String p7EnvExdata = pkcs7Util.BJE_Pkcs7DecodeEnvelopeEx(this.apiEngine, beEncryptedBlob, this.m_Iinitmodel, this.m_password, this.m_container, this.m_encryptPfx);
        return p7EnvExdata;
    }

    public String signDataXML(String inData, long signMethod) throws XmlSignException {
        XMLSignUtil xs = new XMLSignUtil(this.applicationName);
        String ret = xs.BJX_SignedDataXML_Sign(this.apiEngine, this, inData, signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_keyType, this.m_container);
        return ret;
    }

    public boolean verifySignedDataXML(String inData, long signMethod) throws XmlVerifySignException {
        XMLSignUtil xs = new XMLSignUtil(this.applicationName);
        boolean ret = xs.BJX_SignedDataXML_Verify(this.apiEngine, inData, signMethod);
        return ret;
    }

    public String getXMLSignatureInfo(String XMLSignedData, int type) throws GetXMLSignInfoException, JDOMException {
        XMLSignUtil xs = new XMLSignUtil(this.applicationName);
        String ret = xs.BJX_getXMLSignatureInfo(XMLSignedData, type);
        return ret;
    }

    public String createTimeStampRequest(String inData, long hashMethod) throws HashException, TsException, Base64Exception {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        TsUtil tsUtil = new TsUtil(this.applicationName);
        byte[] hashBytes = hashUtil.BJS_HashBytes(this.apiEngine, hashMethod, inData.getBytes(), inData.getBytes().length);
        String sdata = tsUtil.BJT_TSRequest(this.apiEngine, hashBytes, hashBytes.length, hashMethod);
        return sdata;
    }

    public String createTimeStampResponse(String inData) throws Base64Exception, TsException {
        TsUtil tsUtil = new TsUtil(this.applicationName);
        String p7tsdata = tsUtil.BJT_TSResponse(this.apiEngine, inData, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_keyType, this.m_container);
        return p7tsdata;
    }

    public boolean verifyTimeStamp(String content, String tsResponseData, long hashMethod) throws Base64Exception, TsException, HashException {
        TsUtil tsUtil = new TsUtil(this.applicationName);
        boolean isSuccess = tsUtil.BJT_TSVerify(this.apiEngine, content, tsResponseData, hashMethod);
        return isSuccess;
    }

    public String getTimeStampInfo(String tsResponseData, int type) throws Base64Exception, TsException, ParseException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        TsUtil tsUtil = new TsUtil(this.applicationName);
        byte[] timebuf = base64Util.BJS_DecodeBase64(tsResponseData);
        return tsUtil.BJT_TS_GetInfo(this.apiEngine, timebuf, type);
    }

    public String getP7SignDataInfo(String pkcs7SignData, int type) throws Base64Exception, Pkcs7DecodeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        ArrayList infoList = pkcs7Util.BJE_getP7SignDataInfo(this.apiEngine, pkcs7SignData);
        if (type >= 1) {
            return (String)infoList.get(type - 1);
        }
        return null;
    }

    public int getIinitmodel() {
        return this.m_Iinitmodel;
    }

    public String getProvider() {
        return this.m_provider;
    }

    public String getPrivateDll() {
        return this.m_privateDll;
    }

    public String getPassword() {
        return this.m_password;
    }

    public byte[] getSignPfx() {
        return this.m_signPfx;
    }

    public byte[] getSignCertBytes() {
        return this.m_signCertBytes;
    }

    public String getSignCertString() throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String cert = base64Util.BJS_EncodeBase64(this.m_signCertBytes);
        return cert;
    }

    public byte[] getEncryptCertBytes() {
        return this.m_encryptCertBytes;
    }

    public String getEncryptCertString() throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String cert = base64Util.BJS_EncodeBase64(this.m_encryptCertBytes);
        return cert;
    }

    public String getKeyType() {
        return this.m_keyType;
    }

    public String getContainer() {
        return this.m_container;
    }

    public byte[] getEncryptPfx() {
        return this.m_encryptPfx;
    }

    public byte[] BJ_GetPlainInPut2(String PassEncstr, String sRand) throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] Passbuf = base64Util.BJS_DecodeBase64(PassEncstr);
        if (Passbuf.length < 264) {
            return null;
        }
        byte[] Encpass = new byte[Passbuf.length - 257];
        System.arraycopy(Passbuf, 257, Encpass, 0, Passbuf.length - 257);
        int keysize = Passbuf[0] * 64;
        byte[] Encrand = new byte[keysize];
        System.arraycopy(Passbuf, 1, Encrand, 0, keysize);
        try {
            byte[] outData = null;
            long[] outDataLen = new long[1];
            if (this.m_Iinitmodel == 3) {
                byte[] bpix = this.m_encryptPfx;
                int execflag = this.apiEngine.BCA_Pkcs1RsaPrivateKeyDecByPkcs12(this.m_password.getBytes(), this.m_password.length(), bpix, bpix.length, Encrand, Encrand.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = this.apiEngine.BCA_Pkcs1RsaPrivateKeyDecByPkcs12(this.m_password.getBytes(), this.m_password.length(), bpix, bpix.length, Encrand, Encrand.length, outData, outDataLen);
                }
                if (execflag != 0) {
                    throw new SecurityEngineException(execflag);
                }
            } else {
                int execflag = this.apiEngine.BCA_Pkcs1RsaPrivateKeyDec(this.m_container.getBytes(), this.m_container.length(), 1L, this.m_password.getBytes(), this.m_password.length(), Encrand, Encrand.length, outData, outDataLen);
                if (execflag == 0) {
                    outData = new byte[(int)outDataLen[0]];
                    execflag = this.apiEngine.BCA_Pkcs1RsaPrivateKeyDec(this.m_container.getBytes(), this.m_container.length(), 1L, this.m_password.getBytes(), this.m_password.length(), Encrand, Encrand.length, outData, outDataLen);
                }
                if (execflag != 0) {
                    throw new SecurityEngineException(execflag);
                }
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(sRand.getBytes());
            md.update(outData);
            byte[] mddata = md.digest();
            byte[] dkey = new byte[24];
            System.arraycopy(mddata, 0, dkey, 0, 16);
            System.arraycopy(mddata, 0, dkey, 16, 8);
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(dkey);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cpher.init(2, deskey);
            byte[] pass = cpher.doFinal(Encpass);
            return pass;
        }
        catch (SecurityEngineException see) {
            System.err.println("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef\uff1a" + see.getExcptionDetail());
            this.errorlog("Exception in BJ_GetPlainInPut2", see);
            this.debuglog("Exception in BJ_GetPlainInPut2");
            return null;
        }
        catch (Exception e) {
            System.err.println("\u9519\u8bef\u539f\u56e0\u662f\uff1a" + e.getMessage());
            this.errorlog("Exception in BJ_GetPlainInPut2", e);
            this.debuglog("Exception in BJ_GetPlainInPut2");
            return null;
        }
    }

    public String getAllP7b() {
        return this.allP7b;
    }
}

