/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.security;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.spec.RSAPublicKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import sun.misc.BASE64Decoder;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.cn.org.bjca.config.ValueProvider;
import xjyb.cn.org.bjca.config.XmlConfig;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.InitException;
import xjyb.cn.org.bjca.exception.ParameterNotSupportException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.RsaVerifySignException;
import xjyb.cn.org.bjca.exception.SecretRecoveryException;
import xjyb.cn.org.bjca.exception.SecretSegmentException;
import xjyb.cn.org.bjca.exception.TsException;
import xjyb.cn.org.bjca.exception.ValidateCertException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.framework.Log;
import xjyb.cn.org.bjca.java.utils.CryptoUtil;
import xjyb.cn.org.bjca.java.utils.FileUtil;
import xjyb.cn.org.bjca.java.utils.KeyPairUtil;
import xjyb.cn.org.bjca.java.utils.KeyUtil;
import xjyb.cn.org.bjca.java.utils.NumberUtil;
import xjyb.cn.org.bjca.java.utils.Pkcs7Util;
import xjyb.cn.org.bjca.java.utils.RsaUtil;
import xjyb.cn.org.bjca.java.utils.SecretUtil;
import xjyb.cn.org.bjca.java.utils.TimeStampUtil;
import xjyb.cn.org.bjca.java.utils.TsUtil;
import xjyb.cn.org.bjca.java.utils.XMLSignUtil;
import xjyb.cn.org.bjca.security.SecurityUtil;
import xjyb.cn.org.bjca.security.SuperEngine;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.CertificateUtil;
import xjyb.cn.org.bjca.utils.GetPathUtil;
import xjyb.cn.org.bjca.utils.HashUtil;
import xjyb.com.sansec.device.local.Card;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.x509.CertificateList;
import xjyb.org.bjca.asn1.x509.RSAPublicKeyStructure;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.asn1.x509.X509Extensions;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.asn1.x9.X9ObjectIdentifiers;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.interfaces.P11Interface;
import xjyb.org.bjca.jce.valuebean.DeviceKeyPair;
import xjyb.org.bjca.sm4soft.crypto.ParameterException;
import xjyb.org.bjca.sm4soft.crypto.SM4Crypto;
import xjyb.org.bjca.util.GetP7InfoUtil;
import xjyb.org.bjca.util.MathUtil;
import xjyb.org.bjca.util.P7bUtil;

public class SecurityEngine
extends Log {
    public int m_Iinitmodel = 3;
    private String debug = "false";
    private String m_container = null;
    private String m_appName = null;
    private String m_devType = null;
    private String m_password = null;
    private String m_keyType = null;
    private String m_provider = null;
    private String m_privateDll = null;
    private int m_policytype = 2;
    private ArrayList m_catypeList = null;
    private ArrayList trustObjectList = null;
    private Properties m_appProhibitsList = null;
    private String m_verifyTime = null;
    private String m_uniqidoid = null;
    private byte[] m_signCertBytes = null;
    private X509CertificateStructure strcSignCert = null;
    private byte[] m_encryptCertBytes = null;
    private byte[] m_encryptPfx = null;
    private byte[] m_signPfx = null;
    private KeyStore keyStore;
    private PrivateKey privateKey;
    private byte[] privateKeyByte;
    private byte[] purePrivateKey;
    private RSAPrivateCrtKeyParameters privateCrtKey;
    private P11Interface p11Impl;
    private HashMap p7Map = new HashMap();
    private Hashtable crlTable = new Hashtable();
    private String allP7b;

    public SecurityEngine(String appName) {
        super(appName);
    }

    public boolean initialApp(String appName) throws JDOMException, IOException, InitException {
        if (XmlConfig.version == null) {
            XmlConfig.loadConfig();
        }
        this.setAppValue(appName);
        boolean isCertSuccess = false;
        if (this.m_encryptCertBytes == null) {
            isCertSuccess = this.initSvrCert();
        }
        boolean isP7Success = this.initP7Cert();
        return isCertSuccess && isP7Success;
    }

    public void setAppValue(String appName) {
        Properties webApp = (Properties)XmlConfig.getListWebapps().get(appName);
        this.m_appName = appName;
        this.debug = webApp.getProperty("debug");
        if ("false".equals(this.debug)) {
            LoggerUtil.setDebug(this.m_appName, "false");
            this.debuglog("debug log closed!");
        } else if ("true".equals(this.debug)) {
            LoggerUtil.setDebug(this.m_appName, "true");
            this.debuglog("debug log opened!");
        }
        this.m_container = webApp.getProperty("container");
        this.m_password = ((Properties)XmlConfig.getListCerts().get(this.m_container)).getProperty("password");
        this.m_keyType = ((Properties)XmlConfig.getListCerts().get(this.m_container)).getProperty("keytype");
        String devicename = ((Properties)XmlConfig.getListCerts().get(this.m_container)).getProperty("devicename");
        this.m_devType = ((Properties)XmlConfig.getListDevices().get(devicename)).getProperty("providertype");
        this.m_Iinitmodel = Integer.parseInt(this.m_devType);
        this.m_provider = ((Properties)XmlConfig.getListDevices().get(devicename)).getProperty("provider");
        this.m_privateDll = ((Properties)XmlConfig.getListDevices().get(devicename)).getProperty("privatedll");
        this.m_verifyTime = webApp.getProperty("verifytime");
        String policytype = webApp.getProperty("policytype");
        if (policytype != null) {
            this.m_policytype = Integer.parseInt(policytype);
        }
        this.m_catypeList = ValueProvider.getAllTrustName(appName);
        this.trustObjectList = ValueProvider.getAllTrust(appName);
        this.m_appProhibitsList = (Properties)((Properties)XmlConfig.getListWebappsProhibits().get(appName)).clone();
        this.m_uniqidoid = webApp.getProperty("uniqidoid");
    }

    public boolean initP7Cert() {
        try {
            FileUtil fileU = new FileUtil(this.applicationName);
            Base64Util base64Util = new Base64Util(this.applicationName);
            CertificateUtil certU = new CertificateUtil(this.applicationName);
            String path = GetPathUtil.getConfigPath();
            String realPath = path + "/Trust/p7b/" + this.applicationName;
            byte[] allP7file = fileU.readFile(realPath);
            String p7allInOne = new String(allP7file);
            String realP7All = null;
            if (p7allInOne.substring(0, 1).equals("1") && p7allInOne.substring(1, 4).equals("###")) {
                String p7All = p7allInOne.substring(4);
                String pubKey = certU.BJC_GetBasicCertInfo(this.m_signCertBytes, 30L);
                byte[] realKey = MathUtil.conversionKey(base64Util.BJS_DecodeBase64("LjkyMDU2MjA2Ni42MDE3Mjk2NTkwODEy"), pubKey.getBytes());
                byte[] realP7AllByte = SecurityUtil.getInstance().decryptData(realKey, base64Util.BJS_DecodeBase64(p7All));
                realP7All = new String(realP7AllByte);
            } else {
                Base64Util base64U = new Base64Util(this.applicationName);
                byte[] realP7AllByte = this.decodeP7EnvelopedData(base64U.BJS_DecodeBase64(p7allInOne));
                realP7All = new String(realP7AllByte);
            }
            StringTokenizer p7allOneSt = new StringTokenizer(realP7All, "###");
            while (p7allOneSt.hasMoreElements()) {
                int keyIdentifierLen;
                String realp7 = p7allOneSt.nextElement().toString();
                byte[] p7Byte = base64Util.BJS_DecodeBase64(realp7);
                X509CertificateStructure[] p7certList = P7bUtil.getCertChain(p7Byte);
                boolean isSuccess = certU.validateCertChain(p7certList, this.m_Iinitmodel);
                if (!isSuccess) continue;
                int p7Len = p7certList.length;
                for (int i = 0; i < p7Len; ++i) {
                    if (p7certList[i] != null) continue;
                    fileU.writeFile((realp7 + "###").getBytes(), GetPathUtil.getConfigPath() + "/Trust/errorp7");
                    System.out.println("FIND ONE P7 CERT IS NULL!!!, MAYBE THE P7 CERT IS ERROR!!!");
                    this.errorlog("FIND ONE P7 CERT IS NULL!!!, MAYBE THE P7 CERT IS ERROR!!!");
                    break;
                }
                if (p7certList[0] == null) continue;
                X509Name x509P7Name = p7certList[0].getSubject();
                String p7SubjectKeyIdentifier = p7certList[0].getTBSCertificate().getExtensions().getExtension(X509Extensions.SubjectKeyIdentifier).getValue().toString();
                int n = keyIdentifierLen = p7SubjectKeyIdentifier == null ? 0 : p7SubjectKeyIdentifier.length();
                if (keyIdentifierLen > 5) {
                    String key = x509P7Name + p7SubjectKeyIdentifier.substring(5);
                    if (this.p7Map.containsKey(key)) {
                        System.err.println("init p7Trust map[key=" + key + "]fail, key exist!");
                        this.errorlog("init p7Trust map[key=" + key + "]fail, key exist!");
                        continue;
                    }
                    this.p7Map.put(key, p7certList[0]);
                    continue;
                }
                if (!this.p7Map.containsKey(x509P7Name)) {
                    this.p7Map.put(x509P7Name, p7certList[0]);
                    continue;
                }
                System.err.println("[p7SubjectKeyIdentifier=" + p7SubjectKeyIdentifier + "] get error,init p7Trust map[key=" + x509P7Name + "]fail, key exist!");
                this.errorlog("[p7SubjectKeyIdentifier=" + p7SubjectKeyIdentifier + "] get error,init p7Trust map[key=" + x509P7Name + "]fail, key exist!");
            }
            this.allP7b = realP7All;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in initializing P7 certificate", e);
            return false;
        }
        return true;
    }

    public void verifyCRL() throws Exception {
        boolean isSuccess = false;
        CertificateUtil certU = new CertificateUtil(this.applicationName);
        HashMap cloneP7Map = (HashMap)this.p7Map.clone();
        Hashtable listCrl = (Hashtable)SuperEngine.listCrl.clone();
        Hashtable crlSnTable = (Hashtable)SuperEngine.listCrlSn.clone();
        Set p7KeySet = cloneP7Map.keySet();
        for (Object p7X509Name : p7KeySet) {
            X509CertificateStructure p7Obj = (X509CertificateStructure)cloneP7Map.get(p7X509Name);
            CertificateList crlObj = (CertificateList)listCrl.get(p7X509Name);
            if (crlObj != null) {
                isSuccess = certU.isCRLValid(crlObj, p7Obj);
                this.debuglog(p7X509Name.toString() + " CRL verification result == " + isSuccess);
                if (isSuccess) {
                    TreeSet crlList = (TreeSet)crlSnTable.get(p7X509Name);
                    this.crlTable.put(p7X509Name, crlList);
                    continue;
                }
                this.errorlog(p7X509Name.toString() + " crl is invalid !!!, need to update crl again!!!");
                System.out.println(p7X509Name.toString() + " CRL IS INVALID!!! MUST UPDATE THE CRL AGAIN!!!");
                continue;
            }
            this.debuglog(p7X509Name.toString() + " CRL IS NULL !");
            System.out.println(p7X509Name.toString() + " CRL IS NULL !");
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean initSvrCert() throws InitException {
        getPathUtil = new GetPathUtil(this.applicationName);
        fileUtil = new FileUtil(this.applicationName);
        keyUtil = new KeyUtil(this.applicationName);
        succ = true;
        keyUsage = Integer.parseInt(this.m_keyType);
        if (this.m_Iinitmodel == 3) {
            pixpath = null;
            derpath = null;
            pixpath = getPathUtil.getDiskExchPfx(this.m_container);
            derpath = getPathUtil.getDiskExchCert(this.m_container);
            this.m_encryptCertBytes = fileUtil.readFile(derpath);
            this.m_encryptPfx = fileUtil.readFile(pixpath);
            if (keyUsage == 1) {
                this.m_signCertBytes = this.m_encryptCertBytes;
                this.m_signPfx = this.m_encryptPfx;
            } else if (keyUsage == 2) {
                pixpath = getPathUtil.getDiskSignPfx(this.m_container);
                derpath = getPathUtil.getDiskSignCert(this.m_container);
                this.m_signCertBytes = fileUtil.readFile(derpath);
                this.m_signPfx = fileUtil.readFile(pixpath);
            }
        } else {
            if (this.m_Iinitmodel == 4 || this.m_Iinitmodel == 6) {
                derpath = null;
                derpath = getPathUtil.getDiskExchCert(this.m_container);
                this.m_encryptCertBytes = fileUtil.readFile(derpath);
                if (keyUsage == 1) {
                    this.m_signCertBytes = this.m_encryptCertBytes;
                }
                try {
                    this.keyStore = KeyStore.getInstance("JKS");
                    jksPath = getPathUtil.getEnciphermentJksPath(this.m_container);
                    oFis = new FileInputStream(jksPath);
                    this.keyStore.load(oFis, this.m_password.toCharArray());
                    oFis.close();
                    oKey = this.keyStore.getKey(this.m_container, this.m_password.toCharArray());
                    this.privateKey = (PrivateKey)oKey;
                    this.privateKeyByte = this.privateKey.getEncoded();
                    this.privateCrtKey = keyUtil.getPrivateKey(this.privateKey);
                }
                catch (Exception e) {
                    this.errorlog("Exception in initialized server certificate!", e);
                    throw new InitException("Exception in initialized server certificate!");
                }
            }
            if (this.m_Iinitmodel == 5) {
                try {
                    if (this.m_provider != null) {
                        this.debuglog("The p11 Class == " + this.m_provider);
                        this.p11Impl = (P11Interface)Class.forName(this.m_provider).newInstance();
                        this.p11Impl.setProfilePath(GetPathUtil.getBJCAROOT_Path());
                    } else {
                        this.debuglog("The p11 Class is null !!!");
                    }
                }
                catch (Exception e) {
                    this.errorlog("Exception in initialized p11 interface by java!", e);
                    throw new InitException("Exception in initialized p11 interface by java!");
                }
                try {
                    this.m_encryptCertBytes = this.p11Impl.exportUserCertificate(this.m_container, keyUsage);
                    if (keyUsage != 1) ** GOTO lbl71
                    this.m_signCertBytes = this.m_encryptCertBytes;
                }
                catch (Exception e) {
                    this.errorlog("Exception in initialized server certificate by p11!", e);
                    throw new InitException("Exception in initialized server certificate by p11!");
                }
            } else if (this.m_Iinitmodel == 7 || this.m_Iinitmodel == 8) {
                derpath = getPathUtil.getDiskExchCert(this.m_container);
                this.m_encryptCertBytes = fileUtil.readFile(derpath);
                if (keyUsage == 1) {
                    this.m_signCertBytes = this.m_encryptCertBytes;
                }
                sm2Path = getPathUtil.getEnciphermentSm2Path(this.m_container);
                this.privateKeyByte = fileUtil.readFile(sm2Path);
            }
        }
lbl71:
        // 8 sources

        certU = new CertificateUtil(this.applicationName);
        this.strcSignCert = certU.getX509CertStrc(this.m_signCertBytes);
        return succ;
    }

    public String getRandomString() throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(10);
        String randomString = base64Util.BJS_EncodeBase64(random);
        return randomString;
    }

    public byte[] getRandomByte() {
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(10);
        return random;
    }

    public String getRandomString(int len) throws Base64Exception {
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(len);
        String randomString = base64Util.BJS_EncodeBase64(random);
        return randomString;
    }

    public byte[] getRandomByte(int len) {
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(len);
        return random;
    }

    public String BJC_GetUniqIdOidByCAId(String caId) {
        Properties trustCert = ValueProvider.getTrustCert(caId);
        String uniqidoid = trustCert.getProperty("uniqidoid");
        return uniqidoid;
    }

    public String getCertInfo(String base64Cert, int type) throws Base64Exception, GetCertInfoException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certificatUtil = new CertificateUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64Cert);
        String certInfo = certificatUtil.BJC_GetBasicCertInfo(certbuf, type);
        return certInfo;
    }

    public String getCertInfo0020(String base64Cert, int type) throws Base64Exception, GetCertInfoException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certificatUtil = new CertificateUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64Cert);
        String certInfo = certificatUtil.BJC_GetBasicCertInfo0020(certbuf, type);
        return certInfo;
    }

    public String getCertInfoByOid(String base64Cert, String oid) throws Base64Exception, GetCertInfoException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certificatUtil = new CertificateUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64Cert);
        String info = certificatUtil.BJC_GetExtCertInfo(certbuf, oid);
        return info;
    }

    public int validateCert(String base64EncodeCert) throws Base64Exception, CertificateException, ValidateCertException, GetCertInfoException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certificatUtil = new CertificateUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        return certificatUtil.verifyCertificate(certbuf, this.m_Iinitmodel, this.p7Map, this.crlTable, this.m_verifyTime, this.m_policytype, this.m_catypeList, this.m_appProhibitsList, this.m_uniqidoid);
    }

    public byte[] signData(byte[] content, long signMethod) throws HashException, RsaSignException {
        byte[] signedData = null;
        byte[] hashedContent = this.hash_byte(content, this.strcSignCert);
        signedData = this.signHashDataPkcs1(hashedContent);
        return signedData;
    }

    public byte[] signDataWithoutZ(byte[] content, long signMethod) throws HashException {
        byte[] signedData = null;
        byte[] hashedContent = this.hash_byte(content, null);
        signedData = this.signHashDataPkcs1NoDER(hashedContent);
        byte[] signSW = new byte[128];
        byte[] extBit = new byte[32];
        for (int i = 0; i < 32; ++i) {
            extBit[i] = 0;
        }
        System.arraycopy(extBit, 0, signSW, 0, 32);
        System.arraycopy(signedData, 0, signSW, 32, 32);
        System.arraycopy(extBit, 0, signSW, 64, 32);
        System.arraycopy(signedData, 32, signSW, 96, 32);
        return signSW;
    }

    public boolean verifySignedDataWithoutZ(byte[] certBytes, byte[] inDataBytes, byte[] signedDataBytes) throws HashException, VerifySignDataException {
        byte[] hashedContent = this.hash_byte(inDataBytes, null);
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        String certType = certUtil.BJC_GetBasicCertInfo(certBytes, 31L);
        X509CertificateStructure strcCert = certUtil.getX509CertStrc(certBytes);
        if ("ECC".equals(certType)) {
            byte[] signBJCA = new byte[64];
            if (signedDataBytes.length == 128) {
                System.arraycopy(signedDataBytes, 32, signBJCA, 0, 32);
                System.arraycopy(signedDataBytes, 96, signBJCA, 32, 32);
                WrapCard wCard = new WrapCard();
                try {
                    return wCard.vefiySM3WithSM2SignByHashedDataNoDER(hashedContent, strcCert, signBJCA);
                }
                catch (Exception e) {
                    this.errorlog("Exception in sm2 verify signature !", e);
                    throw new VerifySignDataException("Exception in sm2 verify signature");
                }
            }
            System.out.println("\u4e09\u672aSM2\u7b7e\u540d\u503cBase64\u89e3\u7801\u540e\uff0c\u7b7e\u540d\u5b57\u8282\u957f\u5ea6\u4e3a" + signedDataBytes.length);
            return false;
        }
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        boolean isTrue = rsaUtil.verifySignHashedData(hashedContent, signedDataBytes, strcCert);
        return isTrue;
    }

    public byte[] signDataNoDER(byte[] content, long signMethod) throws HashException, RsaSignException {
        byte[] signedData = null;
        byte[] hashedContent = this.hash_byte(content, this.strcSignCert);
        signedData = this.signHashDataPkcs1NoDER(hashedContent);
        return signedData;
    }

    public byte[] hash_byte(byte[] inData, X509CertificateStructure strucCert) throws HashException {
        if (this.m_Iinitmodel == 7 || this.m_Iinitmodel == 8) {
            byte[] publicKey = null;
            byte[] id = null;
            if (strucCert != null) {
                SubjectPublicKeyInfo spki = strucCert.getSubjectPublicKeyInfo();
                byte[] bPubKey = spki.getPublicKeyData().getBytes();
                publicKey = new byte[64];
                System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
                id = "1234567812345678".getBytes();
            }
            try {
                WrapCard wCard = new WrapCard();
                byte[] hashedData = wCard.sm3(inData, publicKey, id);
                return hashedData;
            }
            catch (Exception e) {
                this.errorlog("Exception in sm2 signature with hashed Data!", e);
                return null;
            }
        }
        HashUtil hashUtil = new HashUtil(this.applicationName);
        String hashType = HashUtil.getHashAlg(this.applicationName);
        if ("SHA1".equals(hashType)) {
            return hashUtil.BJS_HashBytes(1L, inData);
        }
        if ("SHA256".equals(hashType)) {
            return hashUtil.BJS_HashBytes(2L, inData);
        }
        return null;
    }

    public byte[] hashByteByAlg(byte[] inData, String hashAlg, X509CertificateStructure strucCert) throws HashException {
        if ("SM3".equals(hashAlg)) {
            byte[] publicKey = null;
            byte[] id = null;
            if (strucCert != null) {
                SubjectPublicKeyInfo spki = strucCert.getSubjectPublicKeyInfo();
                byte[] bPubKey = spki.getPublicKeyData().getBytes();
                publicKey = new byte[64];
                System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
                id = "1234567812345678".getBytes();
            }
            try {
                WrapCard wCard = new WrapCard();
                byte[] hashedData = wCard.sm3(inData, publicKey, id);
                return hashedData;
            }
            catch (Exception e) {
                this.errorlog("Exception in sm2 signature with hashed Data!", e);
                return null;
            }
        }
        HashUtil hashUtil = new HashUtil(this.applicationName);
        if ("SHA256".equals(hashAlg)) {
            return hashUtil.BJS_HashBytes(2L, inData);
        }
        return hashUtil.BJS_HashBytes(1L, inData);
    }

    public byte[] signHashDataPkcs1(byte[] hashedContent) {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        byte[] signedData = null;
        if (this.m_Iinitmodel == 7 || this.m_Iinitmodel == 8) {
            try {
                WrapCard wCard = new WrapCard(this.m_Iinitmodel);
                signedData = wCard.sm2SignWithHashedData(hashedContent, this.privateKeyByte);
            }
            catch (Exception e) {
                this.errorlog("Exception in sm2 signature with hashed Data!", e);
                return null;
            }
        } else {
            signedData = rsaUtil.signHashedData(hashedContent, this.m_Iinitmodel, this.m_keyType, this.m_container, this.privateCrtKey, this.p11Impl, this.privateKeyByte);
        }
        return signedData;
    }

    public byte[] signHashDataPkcs1NoDER(byte[] hashedContent) {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        byte[] signedData = null;
        if (this.m_Iinitmodel == 7 || this.m_Iinitmodel == 8) {
            try {
                WrapCard wCard = new WrapCard(this.m_Iinitmodel);
                signedData = wCard.sm2SignWithHashedDataNoDER(hashedContent, this.privateKeyByte);
            }
            catch (Exception e) {
                this.errorlog("Exception in sm2 signatureNoDER with hashed Data!", e);
                return null;
            }
        } else {
            signedData = rsaUtil.signHashedData(hashedContent, this.m_Iinitmodel, this.m_keyType, this.m_container, this.privateCrtKey, this.p11Impl, this.privateKeyByte);
        }
        return signedData;
    }

    public boolean verifySignedData(byte[] content, byte[] signature, String base64Cert, long signMethod) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        byte[] derCert = base64Util.BJS_DecodeBase64(base64Cert);
        String certType = certUtil.BJC_GetBasicCertInfo(derCert, 31L);
        boolean isSuccess = false;
        if ("ECC".endsWith(certType)) {
            try {
                X509CertificateStructure cert = new X509CertificateStructure((ASN1Sequence)DerUtil.writeBytesToDERObj(derCert));
                WrapCard wCard = new WrapCard();
                isSuccess = wCard.vefiySM3WithSM2Sign(content, cert, signature);
            }
            catch (Exception e) {
                this.errorlog("Exception in sm2 verify signature !", e);
                throw new VerifySignDataException("Exception in sm2 verify signature");
            }
        } else {
            RsaUtil rsaUtil = new RsaUtil(this.applicationName);
            byte[] certbuf = base64Util.BJS_DecodeBase64(base64Cert);
            isSuccess = rsaUtil.BJK_RsaVerifyNoHash(content, signature, certbuf, signMethod);
        }
        return isSuccess;
    }

    public boolean verifySignedDataNoDER(byte[] content, byte[] signature, String base64Cert, long signMethod) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        byte[] derCert = base64Util.BJS_DecodeBase64(base64Cert);
        String certType = certUtil.BJC_GetBasicCertInfo(derCert, 31L);
        boolean isSuccess = false;
        if ("ECC".endsWith(certType)) {
            try {
                X509CertificateStructure cert = new X509CertificateStructure((ASN1Sequence)DerUtil.writeBytesToDERObj(derCert));
                WrapCard wCard = new WrapCard();
                isSuccess = wCard.vefiySM3WithSM2SignNoDER(content, cert, signature);
            }
            catch (Exception e) {
                this.errorlog("Exception in sm2 verify signatureNoDER !", e);
                throw new VerifySignDataException("Exception in sm2 verify signatureNoDER");
            }
        } else {
            RsaUtil rsaUtil = new RsaUtil(this.applicationName);
            byte[] certbuf = base64Util.BJS_DecodeBase64(base64Cert);
            isSuccess = rsaUtil.BJK_RsaVerifyNoHash(content, signature, certbuf, signMethod);
        }
        return isSuccess;
    }

    public boolean verifySignedData(byte[] content, byte[] signature, byte[] publicKey) throws VerifySignDataException {
        boolean isSuccess = false;
        if (publicKey.length == 64) {
            try {
                WrapCard wCard = new WrapCard();
                isSuccess = wCard.vefiySM3WithSM2Sign(content, publicKey, signature);
            }
            catch (Exception e) {
                this.errorlog("Exception in sm2 verify signature !", e);
                throw new VerifySignDataException("Exception in sm2 verify signature");
            }
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            ByteArrayInputStream bin = new ByteArrayInputStream(publicKey);
            ASN1InputStream aIn = new ASN1InputStream(bin);
            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
            RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure(seq);
            BigInteger modulus = rSAPublicKeyStructure.getModulus();
            BigInteger exponents = rSAPublicKeyStructure.getPublicExponent();
            RSAPublicKeySpec rsaPubKeySpec = new RSAPublicKeySpec(modulus, exponents);
            PublicKey pubKey = keyFactory.generatePublic(rsaPubKeySpec);
            RsaUtil rsaUtil = new RsaUtil(this.applicationName);
            isSuccess = rsaUtil.BJK_RsaVerifyNoHash(content, signature, pubKey);
        }
        catch (Exception e) {
            this.errorlog("Exception in rsa verify signature !", e);
            throw new VerifySignDataException("Exception in rsa verify signature");
        }
        return isSuccess;
    }

    public boolean verifySignatureByHashedData(String base64EncodeCert, byte[] hashedData, byte[] signedValue) throws VerifySignDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] derCert = base64Util.BJS_DecodeBase64(base64EncodeCert);
        return this.verifySignatureByHashedData(derCert, hashedData, signedValue);
    }

    public boolean verifySignatureByHashedData(byte[] cert, byte[] hashedData, byte[] signedValue) throws VerifySignDataException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        CertificateUtil certU = new CertificateUtil(this.applicationName);
        String certType = certU.BJC_GetBasicCertInfo(cert, 31L);
        X509CertificateStructure strcCert = certU.getX509CertStrc(cert);
        if ("ECC".endsWith(certType)) {
            try {
                WrapCard wCard = new WrapCard();
                boolean isTrue = wCard.vefiySm2SignWithHashedData(hashedData, strcCert, signedValue);
                return isTrue;
            }
            catch (Exception e) {
                this.errorlog("Exception in sm2 signature with hashed Data!", e);
                throw new VerifySignDataException("Exception in sm2 signature with hashed Data!");
            }
        }
        boolean isTrue = rsaUtil.verifySignHashedData(hashedData, signedValue, strcCert);
        return isTrue;
    }

    public String hashFile(String inFile, long signMethod) throws HashException, RsaSignException, Base64Exception {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        byte[] hashData = hashUtil.BJS_HashFile(signMethod, inFile);
        Base64Util base64Util = new Base64Util(this.applicationName);
        String hashValue = base64Util.BJS_EncodeBase64(hashData);
        return hashValue;
    }

    public String signFile(String inFile, long signMethod) throws HashException, RsaSignException, Base64Exception {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        String signdata = rsaUtil.BJK_RsaSign_File(inFile, signMethod, this.m_Iinitmodel, this.m_signPfx, this.m_keyType, this.m_container, this.privateKey, this.p11Impl);
        return signdata;
    }

    public boolean verifySignedFile(String base64EncodeCert, String inFile, String signValue, long signMethod) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        boolean ret = rsaUtil.BJK_RsaVerify_File(inFile, signValue, base64EncodeCert, signMethod);
        return ret;
    }

    public String signFile(InputStream inputStream, long signMethod) throws HashException, RsaSignException, Base64Exception {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        String signdata = rsaUtil.BJK_RsaSign_File(inputStream, signMethod, this.m_Iinitmodel, this.m_signPfx, this.m_keyType, this.m_container, this.privateKey, this.p11Impl);
        return signdata;
    }

    public boolean verifySignedFile(String base64EncodeCert, InputStream inputStream, String signValue, long signMethod) throws Base64Exception, HashException, GetCertInfoException, RsaVerifySignException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        boolean ret = rsaUtil.BJK_RsaVerify_File(inputStream, signValue, base64EncodeCert, signMethod);
        return ret;
    }

    public String secretSegment(String secert, int m, int n, int k) throws SecretSegmentException {
        SecretUtil secretUtil = new SecretUtil(this.applicationName);
        return secretUtil.BJ_SecertSegment(secert, m, n, k);
    }

    public String secretRecovery(String seg) throws SecretRecoveryException {
        SecretUtil secretUtil = new SecretUtil(this.applicationName);
        return secretUtil.BJ_SecertRecovery(seg);
    }

    public String encryptDataStringKey(String key, String inData, long encryptMethod) throws EncryptDataException, IOException, Base64Exception {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        sKey = new BASE64Decoder().decodeBuffer(key);
        byte[] sdata = cryptoUtil.encryptData_3des_ecb(sKey, inData.getBytes());
        String outData = base64Util.BJS_EncodeBase64(sdata);
        return outData;
    }

    public byte[] encryptDataReByte(String key, String inData, long encryptMethod) throws EncryptDataException, IOException, Base64Exception {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        sKey = new BASE64Decoder().decodeBuffer(key);
        byte[] sdata = cryptoUtil.encryptData_3des_ecb(sKey, inData.getBytes());
        return sdata;
    }

    public boolean encryptDataStringKey(String key, InputStream inputStream, OutputStream outputStream, long encryptMethod) throws EncryptDataException, IOException {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        sKey = new BASE64Decoder().decodeBuffer(key);
        boolean isSuccess = cryptoUtil.encryptData_3des_ecb(sKey, inputStream, outputStream);
        return isSuccess;
    }

    public String encryptDataByteKey(byte[] key, String inData, long encryptMethod) throws EncryptDataException, IOException, Base64Exception {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        byte[] sdata = cryptoUtil.encryptData_3des_ecb(key, inData.getBytes());
        String outData = base64Util.BJS_EncodeBase64(sdata);
        return outData;
    }

    public byte[] encryptDataReByte(byte[] key, byte[] inData, int algorithm, byte[] iv) {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] enData = null;
        if (algorithm == 102) {
            if (iv == null) {
                iv = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            enData = cryptoUtil.encryptData_3des_ecb(key, inData);
        } else if (algorithm == 400) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            enData = cryptoUtil.encryptData_sm4_cbc(key, iv, inData);
        } else if ((long)algorithm == 1062L) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            enData = cryptoUtil.encryptData_aes_256_cbc(key, iv, inData);
        } else {
            this.errorlog("not supported symm encrypt type:" + algorithm);
            return null;
        }
        return enData;
    }

    public byte[] encryptDataReByte(byte[] key, byte[] inData, int algorithm, byte[] iv, boolean isPkcs5Padding) {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] enData = null;
        if (algorithm == 1022) {
            if (iv == null) {
                iv = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            enData = isPkcs5Padding ? cryptoUtil.encryptData_3des_cbc(key, iv, inData) : cryptoUtil.encryptData_3des_cbc_nopadding(key, iv, inData);
        } else if (algorithm == 400) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            enData = isPkcs5Padding ? cryptoUtil.encryptData_sm4_cbc(key, iv, inData) : cryptoUtil.encryptData_sm4_cbc_nopadding(key, iv, inData);
        } else if (algorithm == 401) {
            enData = isPkcs5Padding ? cryptoUtil.encryptData_sm4_ecb(key, inData) : cryptoUtil.encryptData_sm4_ecb_nopadding(key, inData);
        } else if (algorithm == 402) {
            SM4Crypto sm4Crypto = new SM4Crypto();
            try {
                enData = sm4Crypto.encryptOFB(key, iv, inData);
            }
            catch (ParameterException e) {
                this.errorlog("SM4_OFB encrypt exception:", e);
            }
        } else if (algorithm == 403) {
            SM4Crypto sm4Crypto = new SM4Crypto();
            try {
                enData = sm4Crypto.encryptCFB(key, iv, inData);
            }
            catch (ParameterException e) {
                this.errorlog("SM4_CFB encrypt exception:", e);
            }
        } else if (algorithm == 404) {
            SM4Crypto sm4Crypto = new SM4Crypto();
            try {
                enData = sm4Crypto.encryptCTR(key, iv, inData);
            }
            catch (ParameterException e) {
                this.errorlog("SM4_CTR encrypt exception:", e);
            }
        } else if ((long)algorithm == 1062L) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            enData = isPkcs5Padding ? cryptoUtil.encryptData_aes_256_cbc(key, iv, inData) : cryptoUtil.encryptData_aes_256_cbc_nopadding(key, iv, inData);
        } else {
            return null;
        }
        return enData;
    }

    public String decryptData(String key, String inData, long decryptMethod) throws DecryptDataException, Base64Exception, IOException {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        sKey = new BASE64Decoder().decodeBuffer(key);
        byte[] inDataByte = new BASE64Decoder().decodeBuffer(inData);
        byte[] sdata = cryptoUtil.decryptData_3des_ecb(sKey, inDataByte);
        String outData = new String(sdata);
        return outData;
    }

    public byte[] decryptData(byte[] key, byte[] inData, int algorithm, byte[] iv) {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] originalData = null;
        if (algorithm == 102) {
            if (iv == null) {
                iv = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            originalData = cryptoUtil.decryptData_3des_ecb(key, inData);
        } else if (algorithm == 400) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            originalData = cryptoUtil.decryptData_sm4_cbc(key, iv, inData);
        } else if ((long)algorithm == 1062L) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            originalData = cryptoUtil.decryptData_aes_256_cbc(inData, iv, key);
        } else {
            return null;
        }
        return originalData;
    }

    public byte[] decryptData(byte[] key, byte[] inData, int algorithm, byte[] iv, boolean isPkcs5Padding) {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] originalData = null;
        if (algorithm == 1022) {
            if (iv == null) {
                iv = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            originalData = isPkcs5Padding ? cryptoUtil.decryptData_3des_cbc(key, iv, inData) : cryptoUtil.decryptData_3des_cbc_nopadding(key, iv, inData);
        } else if (algorithm == 400) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            originalData = isPkcs5Padding ? cryptoUtil.decryptData_sm4_cbc(key, iv, inData) : cryptoUtil.decryptData_sm4_cbc_nopadding(key, iv, inData);
        } else if (algorithm == 401) {
            originalData = isPkcs5Padding ? cryptoUtil.decryptData_sm4_ecb(key, inData) : cryptoUtil.decryptData_sm4_ecb_nopadding(key, inData);
        } else if (algorithm == 402) {
            SM4Crypto sm4Crypto = new SM4Crypto();
            try {
                originalData = sm4Crypto.decryptOFB(key, iv, inData);
            }
            catch (ParameterException e) {
                this.errorlog("SM4_OFB decrypt exception:", e);
            }
        } else if (algorithm == 403) {
            SM4Crypto sm4Crypto = new SM4Crypto();
            try {
                originalData = sm4Crypto.decryptCFB(key, iv, inData);
            }
            catch (ParameterException e) {
                this.errorlog("SM4_CFB decrypt exception:", e);
            }
        } else if (algorithm == 404) {
            SM4Crypto sm4Crypto = new SM4Crypto();
            try {
                originalData = sm4Crypto.decryptCTR(key, iv, inData);
            }
            catch (ParameterException e) {
                this.errorlog("SM4_CTR decrypt exception:", e);
            }
        } else if ((long)algorithm == 1062L) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            originalData = isPkcs5Padding ? cryptoUtil.decryptData_aes_256_cbc(inData, iv, key) : cryptoUtil.decryptData_aes_256_cbc_nopadding(inData, iv, key);
        } else {
            return null;
        }
        return originalData;
    }

    public boolean decryptData(String key, InputStream inputStream, OutputStream outputStream, long decryptMethod) throws DecryptDataException, IOException {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        sKey = new BASE64Decoder().decodeBuffer(key);
        boolean isSuccess = cryptoUtil.decryptData_3des_ecb(sKey, inputStream, outputStream);
        return isSuccess;
    }

    public boolean encryptFile(String key, String inFile, String outFile, long encryptMethod) throws Base64Exception, EncryptDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        FileUtil fileUtil = new FileUtil(this.applicationName);
        byte[] keybuf = base64Util.BJS_DecodeBase64(key);
        boolean rv = fileUtil.BJS_SymmEncFile(inFile, outFile, keybuf, encryptMethod, 1L);
        return rv;
    }

    public boolean decryptFile(String key, String inFile, String outFile, long encryptMethod) throws Base64Exception, DecryptDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        FileUtil fileUtil = new FileUtil(this.applicationName);
        byte[] keybuf = base64Util.BJS_DecodeBase64(key);
        boolean rv = fileUtil.BJS_SymmDecFile(inFile, outFile, keybuf, encryptMethod, 1L);
        return rv;
    }

    public String pubKeyEncrypt_OAEP(String base64EncodeCert, String inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        String sdata = rsaUtil.BJK_RsaEncrypt_OAEP(inData.getBytes(), certbuf);
        return sdata;
    }

    public String pubKeyEncrypt_OAEP(String base64EncodeCert, byte[] inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        String sdata = rsaUtil.BJK_RsaEncrypt_OAEP(inData, certbuf);
        return sdata;
    }

    public byte[] pubKeyEncrypt(byte[] certBuf, byte[] inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        String certType = certUtil.BJC_GetBasicCertInfo(certBuf, 31L);
        byte[] enData = null;
        if (this.m_Iinitmodel == 8 || this.m_Iinitmodel == 4) {
            if ("ECC".equals(certType)) {
                try {
                    CertificateUtil certU = new CertificateUtil(this.applicationName);
                    X509CertificateStructure strcCert = certU.getX509CertStrc(certBuf);
                    WrapCard wCard = new WrapCard(8);
                    enData = wCard.sm2Encrypt(strcCert, inData);
                }
                catch (Exception e) {
                    this.errorlog("Exception in sm2 encrypt !", e);
                    return null;
                }
            } else if ("RSA".equals(certType)) {
                RsaUtil rsaUtil = new RsaUtil(this.applicationName);
                enData = rsaUtil.BJK_RsaEncrypt(inData, certBuf);
            }
        } else if (this.m_Iinitmodel == 6 || this.m_Iinitmodel == 7) {
            if ("ECC".equals(certType)) {
                try {
                    CertificateUtil certU = new CertificateUtil(this.applicationName);
                    X509CertificateStructure strcCert = certU.getX509CertStrc(certBuf);
                    WrapCard wCard = new WrapCard(7);
                    enData = wCard.sm2Encrypt(strcCert, inData);
                }
                catch (Exception e) {
                    this.errorlog("Exception in sm2 encrypt !", e);
                    return null;
                }
            } else if ("RSA".equals(certType)) {
                Card card = Card.getInstance();
                String publicKey = certUtil.BJC_GetBasicCertInfo(certBuf, 30L);
                Base64Util base64Util = new Base64Util(this.applicationName);
                enData = card.rsaExternalEncrypt(base64Util.BJS_DecodeBase64(publicKey), inData);
            }
        }
        return enData;
    }

    public byte[] priKeyDecrypt(byte[] encryptedData) throws Base64Exception, RsaDecryptException {
        byte[] outData = null;
        if (this.m_Iinitmodel == 7 || this.m_Iinitmodel == 8) {
            try {
                WrapCard wCard = new WrapCard(this.m_Iinitmodel);
                outData = wCard.sm2Decrypt(this.privateKeyByte, encryptedData);
            }
            catch (Exception e) {
                this.errorlog("Exception in sm2 decrypt !", e);
                return null;
            }
        } else if (this.m_Iinitmodel == 4) {
            RsaUtil rsaUtil = new RsaUtil(this.applicationName);
            outData = rsaUtil.BJK_RsaDecrypt(encryptedData, this.m_Iinitmodel, this.m_keyType, this.m_container, this.m_encryptPfx, this.privateKey, this.p11Impl);
        } else if (this.m_Iinitmodel == 6) {
            Card card = Card.getInstance();
            outData = card.rsaExternalDecrypt(this.privateKeyByte, encryptedData);
        }
        return outData;
    }

    public String priKeyDecrypt_OAEP(String inData) throws Base64Exception, RsaDecryptException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        String sdata = rsaUtil.BJK_RsaDecrypt_OAEP(inData, this.m_Iinitmodel, this.m_keyType, this.m_container, this.m_encryptPfx, this.privateKey, this.p11Impl);
        return sdata;
    }

    public byte[] hashAll(ArrayList fileList, ArrayList stringList, long signMethod) throws NoSuchAlgorithmException {
        HashUtil hu = new HashUtil(this.applicationName);
        byte[] hashValue = hu.hashAll(fileList, stringList, signMethod);
        return hashValue;
    }

    public boolean verifySignAll(ArrayList fileList, ArrayList stringList, String base64EncodeCert, String signValue, long signMethod) throws Base64Exception, GetCertInfoException, NoSuchAlgorithmException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        byte[] hashbuf = this.hashAll(fileList, stringList, signMethod);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        byte[] sginbuf = base64Util.BJS_DecodeBase64(signValue);
        boolean isSuccess = rsaUtil.BJK_RsaVerifyNoHash(hashbuf, sginbuf, certbuf, signMethod);
        return isSuccess;
    }

    public String getTotalTsReq(ArrayList fileList, ArrayList stringList, long signMethod) throws TsException, Base64Exception, NoSuchAlgorithmException {
        TsUtil tsUtil = new TsUtil(this.applicationName);
        byte[] hashbuf = this.hashAll(fileList, stringList, signMethod);
        String sdata = tsUtil.BJT_TSRequest(hashbuf, hashbuf.length, signMethod);
        return sdata;
    }

    public String signDataPkcs7(byte[] inData, long signMethod) throws Pkcs7SignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] p7signdata = pkcs7Util.BJE_Pkcs7Sign(inData, signMethod, this.m_Iinitmodel, this.m_signPfx, this.m_signCertBytes, this.m_keyType, this.m_container, this.privateKey, this.p11Impl, this.privateKeyByte, true, this.privateCrtKey);
        return base64Util.BJS_EncodeBase64(p7signdata);
    }

    public String signDataPkcs7ForJit(byte[] inData, long signMethod, boolean isAttach) throws Pkcs7SignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] p7signdata = pkcs7Util.BJE_Pkcs7SignForJit(inData, signMethod, this.m_Iinitmodel, this.m_signPfx, this.m_signCertBytes, this.m_keyType, this.m_container, this.privateKey, this.p11Impl, this.privateKeyByte, isAttach, this.privateCrtKey);
        return base64Util.BJS_EncodeBase64(p7signdata);
    }

    public byte[] signHashedDataPkcs7_detach(byte[] inData, long signMethod) throws Pkcs7SignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        byte[] p7signdataByte = pkcs7Util.signHashedDataByP7Detach(inData, this.m_Iinitmodel, this.m_signCertBytes, this.m_keyType, this.m_container, this.privateCrtKey, this.privateKeyByte);
        return p7signdataByte;
    }

    public byte[] signAttributePkcs7(byte[] inData, long signMethod) throws Pkcs7SignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        byte[] p7signdataByte = pkcs7Util.signAttributeP7(inData, this.m_Iinitmodel, this.m_signCertBytes, this.m_keyType, this.m_container, this.privateKey, this.privateKeyByte, this.privateCrtKey);
        return p7signdataByte;
    }

    public String signDataPkcs7_detach(byte[] inData, long signMethod) throws Pkcs7SignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] p7signdataByte = pkcs7Util.BJE_Pkcs7Sign(inData, signMethod, this.m_Iinitmodel, this.m_signPfx, this.m_signCertBytes, this.m_keyType, this.m_container, this.privateKey, this.p11Impl, this.privateKeyByte, false, this.privateCrtKey);
        String p7signdata = base64Util.BJS_EncodeBase64(p7signdataByte);
        return p7signdata;
    }

    public String signDataPkcs7_file_detach(String sFilePath, long signMethod) throws Pkcs7SignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        String p7signdata = pkcs7Util.BJE_Pkcs7Sign_file_detach(sFilePath, signMethod, this.m_Iinitmodel, this.m_signPfx, this.m_signCertBytes, this.m_keyType, this.m_container, this.privateKey, this.p11Impl, this.privateKeyByte);
        return p7signdata;
    }

    public String signDataPkcs7Base64(String inData, long signMethod) throws Base64Exception, Pkcs7SignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] conbuf = base64Util.BJS_DecodeBase64(inData);
        byte[] p7signdata = pkcs7Util.BJE_Pkcs7Sign(conbuf, signMethod, this.m_Iinitmodel, this.m_signPfx, this.m_signCertBytes, this.m_keyType, this.m_container, this.privateKey, this.p11Impl, this.privateKeyByte, true, this.privateCrtKey);
        return base64Util.BJS_EncodeBase64(p7signdata);
    }

    public boolean verifySignedDataPkcs7(String pkcs7SignData) throws Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        boolean isSuccess = pkcs7Util.BJE_Pkcs7Verify(null, pkcs7SignData);
        return isSuccess;
    }

    public boolean verifySignedDataPkcs7(byte[] pkcs7SignData) throws Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        boolean isSuccess = pkcs7Util.BJE_Pkcs7Verify(null, pkcs7SignData);
        return isSuccess;
    }

    public String verifySignedP7Data_detach(byte[] inData, String pkcs7SignData) throws Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] signCert = pkcs7Util.BJE_Pkcs7Verify_reCert(inData, pkcs7SignData);
        return base64Util.BJS_EncodeBase64(signCert);
    }

    public String verifySignedDataPkcs7_detach_ForJit(byte[] inData, String pkcs7SignData) throws Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] signCert = pkcs7Util.BJE_Pkcs7Verify_reCert_ForJit(inData, pkcs7SignData);
        return base64Util.BJS_EncodeBase64(signCert);
    }

    public String verifySignedP7Data_detach_hash(byte[] inData, String pkcs7SignData) throws Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        String cert = pkcs7Util.BJE_Pkcs7Verify_byHash_reCert(inData, pkcs7SignData);
        return cert;
    }

    public String verifySignedP7Data_detach_hash(byte[] inData, byte[] pkcs7SignData) throws Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        String cert = pkcs7Util.BJE_Pkcs7Verify_byHash_reCert(inData, pkcs7SignData);
        return cert;
    }

    public String verifySignedDataPkcs7_detach_hash_ForCPIC(byte[] inData, byte[] pkcs7SignData) throws Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        String cert = pkcs7Util.BJE_Pkcs7Verify_byHash_reCertForCPIC(inData, pkcs7SignData);
        return cert;
    }

    public boolean verifySignedP7Data_file_detach(String sFilePath, String pkcs7SignData) throws Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        boolean isSuccess = pkcs7Util.BJE_Pkcs7_file_Verify(sFilePath, pkcs7SignData);
        return isSuccess;
    }

    public byte[] encodeP7EnvelopedData(String base64EncodeCert, byte[] inData, long encryptMethod) throws Pkcs7EncodeEnvelopeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        byte[] derCert = base64Util.BJS_DecodeBase64(base64EncodeCert);
        String certType = certUtil.BJC_GetBasicCertInfo(derCert, 31L);
        byte[] p7DataByte = null;
        p7DataByte = "ECC".endsWith(certType) ? pkcs7Util.pkcs7EncodeEnvelope_sm2(inData, derCert) : pkcs7Util.BJE_Pkcs7EncodeEnvelope(inData, derCert, encryptMethod);
        return p7DataByte;
    }

    public byte[] encodeP7EnvelopedData4Jit(String base64EncodeCert, byte[] inData, long encryptMethod) throws Pkcs7EncodeEnvelopeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        byte[] derCert = base64Util.BJS_DecodeBase64(base64EncodeCert);
        String certType = certUtil.BJC_GetBasicCertInfo(derCert, 31L);
        byte[] p7DataByte = null;
        p7DataByte = "ECC".endsWith(certType) ? pkcs7Util.pkcs7EncodeEnvelope_sm24Jit(inData, derCert) : pkcs7Util.BJE_Pkcs7EncodeEnvelope(inData, derCert, encryptMethod);
        return p7DataByte;
    }

    public byte[] decodeP7EnvelopedData(byte[] inData) throws Pkcs7DecodeEnvelopeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        byte[] outData = null;
        outData = this.m_Iinitmodel == 7 || this.m_Iinitmodel == 8 ? pkcs7Util.pkcs7DecodeEnvelope_sm2(inData, this.privateKeyByte, this.m_encryptCertBytes) : pkcs7Util.BJE_Pkcs7DecodeEnvelope(inData, this.m_Iinitmodel, this.m_encryptPfx, this.m_keyType, this.m_container, this.privateKey, this.p11Impl, this.m_encryptCertBytes);
        return outData;
    }

    public byte[] decodeP7EnvelopedData4Jit(byte[] inData) throws Pkcs7DecodeEnvelopeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        byte[] outData = null;
        outData = this.m_Iinitmodel == 7 || this.m_Iinitmodel == 8 ? pkcs7Util.pkcs7DecodeEnvelope_sm24Jit(inData, this.privateKeyByte, this.m_encryptCertBytes) : pkcs7Util.BJE_Pkcs7DecodeEnvelope(inData, this.m_Iinitmodel, this.m_encryptPfx, this.m_keyType, this.m_container, this.privateKey, this.p11Impl, this.m_encryptCertBytes);
        return outData;
    }

    public String encodeP7SignAndEnvelopData(String base64EncodeCert, byte[] inData) throws Base64Exception, Pkcs7EncodeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        String p7SignAndEnvData = null;
        p7SignAndEnvData = this.m_Iinitmodel == 7 || this.m_Iinitmodel == 8 ? pkcs7Util.BJE_Pkcs7EncodeSignAndEnvelope_SM2(inData, this.m_signCertBytes, this.privateKeyByte, certbuf) : pkcs7Util.BJE_Pkcs7EncodeSignAndEnvelope(inData, this.m_Iinitmodel, this.m_signCertBytes, this.m_keyType, this.m_container, this.privateKey, this.p11Impl, certbuf);
        return p7SignAndEnvData;
    }

    public byte[] decodeP7SignAndEnvelopeData(String inData) throws Pkcs7DecodeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] p7SignAndEnvData = null;
        p7SignAndEnvData = this.m_Iinitmodel == 7 || this.m_Iinitmodel == 8 ? pkcs7Util.BJE_Pkcs7DecodeSignAndEnvelope_SM2(inData, this.privateKeyByte, this.m_signCertBytes) : pkcs7Util.BJE_Pkcs7DecodeSignAndEnvelope(inData, this.m_Iinitmodel, this.m_keyType, this.m_container, this.privateKey, this.p11Impl, this.m_signCertBytes);
        return p7SignAndEnvData;
    }

    public byte[] decodeP7SignAndEnvelopeData(byte[] prikey, String inData) throws Pkcs7DecodeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] p7SignAndEnvData = null;
        p7SignAndEnvData = pkcs7Util.BJE_Pkcs7DecodeSignAndEnvelope_SM2_Jit(inData, prikey, this.m_signCertBytes);
        return p7SignAndEnvData;
    }

    public String signDataXML(String inData, long signMethod) throws XmlSignException {
        XMLSignUtil xs = new XMLSignUtil(this.applicationName);
        String ret = xs.BJX_SignedDataXML_Sign(this, inData, signMethod, this.m_Iinitmodel, this.m_signPfx, this.m_keyType, this.m_container, this.privateCrtKey, this.privateKey, this.p11Impl, this.privateKeyByte, this.purePrivateKey);
        return ret;
    }

    public String signDataXML0020(String inData, long signMethod) throws XmlSignException {
        XMLSignUtil xs = new XMLSignUtil(this.applicationName);
        String ret = xs.BJX_SignedDataXML_Sign0020(this, inData, signMethod, this.m_Iinitmodel, this.m_signPfx, this.m_keyType, this.m_container, this.privateCrtKey, this.privateKey, this.p11Impl, this.privateKeyByte, this.purePrivateKey);
        return ret;
    }

    public boolean verifySignedDataXML(String inData, long signMethod) throws XmlVerifySignException {
        XMLSignUtil xs = new XMLSignUtil(this.applicationName);
        boolean ret = xs.BJX_SignedDataXML_Verify(inData, signMethod);
        return ret;
    }

    public boolean verifySignedDataXML0020(String inData, long signMethod) throws XmlVerifySignException {
        XMLSignUtil xs = new XMLSignUtil(this.applicationName);
        boolean ret = xs.BJX_SignedDataXML_Verify0020(this, inData, signMethod);
        return ret;
    }

    public String getXMLSignatureInfo(String XMLSignedData, int type) throws GetXMLSignInfoException, JDOMException {
        XMLSignUtil xs = new XMLSignUtil(this.applicationName);
        String ret = xs.BJX_getXMLSignatureInfo(XMLSignedData, type);
        return ret;
    }

    public String createTimeStampRequest(byte[] inData, long hashMethod) throws HashException, TsException, Base64Exception {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] tsRequest = tsUtil.createTimeStampRequest(inData, this.m_Iinitmodel);
        String tsReqStr = base64Util.BJS_EncodeBase64(tsRequest);
        return tsReqStr;
    }

    public byte[] createTimeStampRequest(byte[] inData, boolean isAttachCert) throws HashException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        byte[] tsRequest = tsUtil.createTimeStampRequest(inData, this.m_Iinitmodel, isAttachCert);
        return tsRequest;
    }

    public String createTimeStampResponse(String inData, boolean isAttachCert) throws Base64Exception, TsException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        Base64Util base64U = new Base64Util(this.applicationName);
        byte[] request = base64U.BJS_DecodeBase64(inData);
        byte[] p7tsdata = tsUtil.timeStampResponseByRequest(request, isAttachCert, this.m_Iinitmodel, this.strcSignCert, this.privateKey, this.privateKeyByte, this.p11Impl);
        String tsBase64 = base64U.BJS_EncodeBase64(p7tsdata);
        return tsBase64;
    }

    public byte[] createTimeStamp(byte[] tsRequest) throws TsException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        byte[] timeStamp = tsUtil.timeStampResponseByRequest(tsRequest, this.m_Iinitmodel, this.strcSignCert, this.privateKey, this.privateKeyByte);
        return timeStamp;
    }

    public byte[] createTimeStamp0033(byte[] tsRequest) throws TsException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        byte[] timeStamp = tsUtil.timeStampResponseByRequest0033(tsRequest, this.m_Iinitmodel, this.strcSignCert, this.privateKey, this.privateKeyByte);
        return timeStamp;
    }

    public String createTsRespByOriginalData(byte[] inData, boolean isAttachCert) throws Base64Exception, TsException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        String p7tsdata = tsUtil.timeStampResponse(inData, isAttachCert, 0L, this.m_Iinitmodel, this.strcSignCert, this.m_signPfx, this.m_signCertBytes, this.m_keyType, this.m_container, this.privateKey, this.privateKeyByte, this.p11Impl);
        return p7tsdata;
    }

    public byte[] createP7DetachedAndTimeStampedData(byte[] hashedOriginalData) throws GeneralSecurityException {
        Pkcs7Util p7Util = new Pkcs7Util(this.applicationName);
        byte[] p7AndTs = p7Util.createP7DetachedAndTimeStampedData(hashedOriginalData, this.m_signCertBytes, this.privateKey);
        return p7AndTs;
    }

    public byte[] createP7DetachedAndTimeStampedData(byte[] p7sign, byte[] hashedOriginalData) throws GeneralSecurityException {
        Pkcs7Util p7Util = new Pkcs7Util(this.applicationName);
        byte[] p7AndTs = p7Util.createP7DetachedAndTimeStampedData_ts(p7sign, hashedOriginalData);
        return p7AndTs;
    }

    public byte[] generateP7DetachedByP7AndTimeStampedData(byte[] p7sign, byte[] timeStamp) throws GeneralSecurityException {
        Pkcs7Util p7Util = new Pkcs7Util(this.applicationName);
        byte[] p7AndTs = p7Util.generateP7DetachedByP7AndTimeStampedData(p7sign, timeStamp);
        return p7AndTs;
    }

    public int verifyP7DetachedAndTimeStampedData(byte[] p7Byte) {
        Pkcs7Util p7Util = new Pkcs7Util(this.applicationName);
        int result = p7Util.verifyP7DetachedAndTimeStampedData(p7Byte);
        return result;
    }

    public String getP7DetachedAndTimeStampedDataInfo(byte[] p7Byte, int type) throws CertificateEncodingException, IOException {
        Pkcs7Util p7Util = new Pkcs7Util(this.applicationName);
        ArrayList infoList = p7Util.getP7DetachedAndTimeStampedDataInfo(p7Byte, this.m_Iinitmodel);
        if (type >= 1 && type < 6) {
            return (String)infoList.get(type - 1);
        }
        return null;
    }

    public boolean verifyTimeStamp(String content, String tsResponseData, byte[] cert, long hashMethod) throws Base64Exception, TsException, HashException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        boolean isSuccess = tsUtil.verifyTimeStamp(content, tsResponseData, cert, this.m_Iinitmodel);
        return isSuccess;
    }

    public boolean verifyTimeStamp(byte[] timeStamp, byte[] cert) throws TsException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        boolean isSuccess = tsUtil.verifyTimeStamp(timeStamp, cert, this.m_Iinitmodel);
        return isSuccess;
    }

    public boolean verifyTimeStamp0033(byte[] timeStamp, byte[] cert) throws TsException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        byte[] ts = tsUtil.getTsResp(timeStamp);
        boolean isSuccess = tsUtil.verifyTimeStamp(ts, cert, this.m_Iinitmodel);
        return isSuccess;
    }

    public String getTimeStampInfo(String tsResponseData, int type) throws Base64Exception, TsException, ParseException, Pkcs7DecodeException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        ArrayList infoList = tsUtil.getTimeStampInfo(tsResponseData, this.m_Iinitmodel);
        if (type >= 1 && type < 6) {
            return (String)infoList.get(type - 1);
        }
        return null;
    }

    public String getTimeStampInfo(byte[] tsResponseData, int type) throws TsException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        ArrayList infoList = tsUtil.getTimeStampInfo(tsResponseData, this.m_Iinitmodel);
        if (type >= 1 && type < 6) {
            return (String)infoList.get(type - 1);
        }
        return null;
    }

    public String getTimeStampInfo0033(byte[] tsResponseData, int type) throws TsException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        byte[] tsResp = tsUtil.getTsResp(tsResponseData);
        ArrayList infoList = tsUtil.getTimeStampInfo0033(tsResp, this.m_Iinitmodel);
        if (type >= 1 && type < 7) {
            return (String)infoList.get(type - 1);
        }
        return null;
    }

    public String getP7SignDataInfo(String pkcs7SignData, int type) throws Pkcs7DecodeException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        byte[] p7SignedData = base64Util.BJS_DecodeBase64(pkcs7SignData);
        ArrayList infoList = pkcs7Util.getP7SignDataInfo(p7SignedData);
        if (type == 1) {
            byte[] inData = (byte[])infoList.get(type - 1);
            String origialData = new String(inData);
            return origialData;
        }
        if (type == 2) {
            byte[] certCode = (byte[])infoList.get(type - 1);
            String base64Cert = base64Util.BJS_EncodeBase64(certCode);
            return base64Cert;
        }
        if (type == 3) {
            byte[] signValue = (byte[])infoList.get(type - 1);
            String base64SignValue = base64Util.BJS_EncodeBase64(signValue);
            return base64SignValue;
        }
        try {
            String[] attrsStrings;
            if (type == 5 && (attrsStrings = GetP7InfoUtil.getAttrsFromP7(p7SignedData)) != null && attrsStrings.length > 2) {
                return attrsStrings[1];
            }
        }
        catch (Exception e) {
            throw new Pkcs7DecodeException(e.getMessage());
        }
        return null;
    }

    public byte[] getP7SignDataInfo(byte[] p7SignedData, int type) throws Pkcs7DecodeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        ArrayList infoList = pkcs7Util.getP7SignDataInfo(p7SignedData);
        if (type >= 1 && type < 4) {
            return (byte[])infoList.get(type - 1);
        }
        try {
            String[] attrsStrings;
            if (type == 5 && (attrsStrings = GetP7InfoUtil.getAttrsFromP7(p7SignedData)) != null && attrsStrings.length > 2) {
                return attrsStrings[1].getBytes();
            }
        }
        catch (Exception e) {
            throw new Pkcs7DecodeException(e.getMessage());
        }
        return null;
    }

    public int getIinitmodel() {
        return this.m_Iinitmodel;
    }

    public String getProvider() {
        return this.m_provider;
    }

    public String getPrivateDll() {
        return this.m_privateDll;
    }

    public String getPassword() {
        return this.m_password;
    }

    public byte[] getSignPfx() {
        return this.m_signPfx;
    }

    public byte[] getSignCertBytes() {
        return this.m_signCertBytes;
    }

    public String getSignCertString() throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String cert = base64Util.BJS_EncodeBase64(this.m_signCertBytes);
        return cert;
    }

    public byte[] getEncryptCertBytes() {
        return this.m_encryptCertBytes;
    }

    public String getEncryptCertString() throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String cert = base64Util.BJS_EncodeBase64(this.m_encryptCertBytes);
        return cert;
    }

    public String getKeyType() {
        return this.m_keyType;
    }

    public String getContainer() {
        return this.m_container;
    }

    public byte[] getEncryptPfx() {
        return this.m_encryptPfx;
    }

    public String getAllP7b() {
        return this.allP7b;
    }

    public Object[] generatorKeyPair(int type, int length) throws IOException {
        Object[] objs = null;
        KeyPairUtil keyPairUtil = new KeyPairUtil(this.applicationName);
        if (type == 0) {
            keyPairUtil.generatorKeyPair(length);
            objs = new Object[]{keyPairUtil.getPublicKey(), keyPairUtil.getPrivateKey()};
        } else if (type == 1) {
            objs = new Object[]{keyPairUtil.generatorKeyPair_sm2()};
        }
        return objs;
    }

    public byte[] generatP7CounterSign(byte[] inData) throws Pkcs7SignException, Pkcs7DecodeException, HashException, IOException, InvalidKeyException, CertificateException, SecurityException, NoSuchProviderException, NoSuchAlgorithmException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        ArrayList infoList = pkcs7Util.getP7SignDataInfo(inData);
        byte[] encryptDigest = (byte[])infoList.get(2);
        byte[] hashedContent = this.hash_byte(encryptDigest, this.strcSignCert);
        byte[] counterSignData = pkcs7Util.signAttributeP7(hashedContent, this.m_Iinitmodel, this.m_signCertBytes, this.m_keyType, this.m_container, this.privateKey, this.privateKeyByte, this.privateCrtKey);
        byte[] p7CounterSignData = pkcs7Util.pkcs7CounterSign(inData, counterSignData, this.m_Iinitmodel, this.m_signCertBytes);
        return p7CounterSignData;
    }

    public String verifyP7CounterSign(byte[] inData) throws Pkcs7DecodeException, CertificateException, Base64Exception, ValidateCertException, GetCertInfoException, HashException, IOException, ParseException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Object[] infoList = pkcs7Util.getP7CounterSignDataInfo(inData);
        String preInfoList = SecurityUtil.getInstance().assembleCounterSignInfoList(infoList);
        if (preInfoList == null) {
            return SecurityUtil.getInstance().jointVerifyCounterSignRetStr("counterSignature", 1304, null, false);
        }
        int retInt = pkcs7Util.verifyPkcs7CounterSign(infoList);
        if (retInt == -1) {
            return SecurityUtil.getInstance().jointVerifyCounterSignRetStr("counterSignature", 1310, null, false);
        }
        if (retInt == -2) {
            return SecurityUtil.getInstance().jointVerifyCounterSignRetStr("counterSignature", 1304, null, false);
        }
        ArrayList certs = (ArrayList)infoList[0];
        int ret = 0;
        for (int i = 0; i < certs.size() && (ret = this.validateCert(base64Util.BJS_EncodeBase64((byte[])certs.get(i)))) == 1; ++i) {
        }
        if (ret != 1) {
            StringBuilder sb = new StringBuilder();
            int errorCode = 0;
            if (ret == -1) {
                sb.append("certchain");
                errorCode = 1306;
            } else if (ret == -2) {
                sb.append("certOverdue");
                errorCode = 1314;
            } else if (ret == -3 || ret == -4) {
                sb.append("certRevoke");
                errorCode = 1316;
            } else {
                sb.append("certFormat");
                errorCode = 1301;
            }
            return SecurityUtil.getInstance().jointVerifyCounterSignRetStr(sb.toString(), errorCode, null, false);
        }
        return SecurityUtil.getInstance().jointVerifyCounterSignRetStr(null, 1, preInfoList, true);
    }

    public byte[] createTimeStampRequestByHashedData(byte[] inData, boolean isAttachCert) throws TsException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        byte[] tsRequest = tsUtil.createTimeStampRequestByHashedData(inData, this.m_Iinitmodel, isAttachCert);
        return tsRequest;
    }

    public byte[] createTimeStampRequestByFile(String filePath, boolean isAttachCert) throws TsException {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        String algType = certUtil.BJC_GetBasicCertInfo(this.m_signCertBytes, 31L);
        byte[] fileHashBytes = hashUtil.hashFile(algType, filePath, null);
        byte[] tsRequest = tsUtil.createTimeStampRequestByHashedData(fileHashBytes, this.m_Iinitmodel, isAttachCert);
        return tsRequest;
    }

    public int verifyTimeStampByFile(byte[] timeStamp, String inFile) throws TsException, ParseException {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        ArrayList timeStampInfoList = tsUtil.getTimeStampInfo(timeStamp, this.m_Iinitmodel);
        String base64OriHash = (String)timeStampInfoList.get(1);
        String cert = (String)timeStampInfoList.get(2);
        String algType = certUtil.BJC_GetBasicCertInfo(this.m_signCertBytes, 31L);
        byte[] fileHashBytes = hashUtil.hashFile(algType, inFile, null);
        String fileHash = base64Util.BJS_EncodeBase64(fileHashBytes);
        if (!base64OriHash.equals(fileHash)) {
            return -2;
        }
        String base64TimeStamp = base64Util.BJS_EncodeBase64(timeStamp);
        int verifyCertRes = this.verifyTimeCert(base64TimeStamp);
        if (verifyCertRes != 1) {
            return verifyCertRes;
        }
        boolean isTimeStampPass = false;
        isTimeStampPass = cert == null || cert.equals("") ? tsUtil.verifyTimeStamp(timeStamp, this.m_signCertBytes, this.m_Iinitmodel) : tsUtil.verifyTimeStamp(timeStamp, base64Util.BJS_DecodeBase64(cert), this.m_Iinitmodel);
        if (isTimeStampPass) {
            return 1;
        }
        return -1;
    }

    private int verifyTimeCert(String timeStamp) {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        try {
            ArrayList timeStampInfoList = tsUtil.getTimeStampInfo(base64Util.BJS_DecodeBase64(timeStamp), this.m_Iinitmodel);
            String time = (String)timeStampInfoList.get(0);
            String cert = (String)timeStampInfoList.get(2);
            if (cert == null || cert.equals("")) {
                String serialNumber;
                String tsSerialNumber = (String)timeStampInfoList.get(3);
                if (tsSerialNumber.equals(serialNumber = certUtil.BJC_GetBasicCertInfo(this.m_signCertBytes, 2L))) {
                    cert = base64Util.BJS_EncodeBase64(this.m_signCertBytes);
                } else {
                    return -5;
                }
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyyMMddHHmmss");
            String beforeDateStr = certUtil.BJC_GetBasicCertInfo(base64Util.BJS_DecodeBase64(cert), 11L);
            if (beforeDateStr == null || beforeDateStr != null && beforeDateStr.equals("")) {
                return -1;
            }
            Date beforeDate = dateFormat.parse(beforeDateStr);
            if (beforeDate == null) {
                return -1;
            }
            String afterDateStr = certUtil.BJC_GetBasicCertInfo(base64Util.BJS_DecodeBase64(cert), 12L);
            if (afterDateStr == null || afterDateStr != null && afterDateStr.equals("")) {
                return -1;
            }
            Date afterDate = dateFormat.parse(afterDateStr);
            if (afterDate == null) {
                return -1;
            }
            if (time == null || time != null && time.equals("")) {
                return -1;
            }
            Date timeDate = dateFormat1.parse(time);
            if (timeDate == null) {
                return -1;
            }
            if (timeDate.getTime() > afterDate.getTime()) {
                return -6;
            }
            if (timeDate.getTime() < beforeDate.getTime()) {
                return -4;
            }
            int validRes = this.validateCert(cert);
            this.debuglog("validCert result is " + validRes + "!");
            if (validRes == -1) {
                return -3;
            }
            if (validRes == -5) {
                return -4;
            }
            if (validRes == 1 || validRes == -2) {
                return 1;
            }
        }
        catch (Exception e) {
            this.errorlog("exception in verifyTimeCert," + e);
            this.debuglog("exception in verifyTimeCert," + e);
            return 0;
        }
        return -1;
    }

    public byte[] createTimeStampRequestByLargebinary(byte[] inData, boolean isAttachCert) throws TsException, IOException {
        if (inData == null) {
            return null;
        }
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        String algType = certUtil.BJC_GetBasicCertInfo(this.m_signCertBytes, 31L);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inData);
        HashUtil hashUtil = new HashUtil(this.applicationName);
        byte[] hashBytes = null;
        if ("RSA".equals(algType)) {
            hashBytes = hashUtil.hashByInputStream(inputStream);
        } else if ("ECC".equals(algType)) {
            hashBytes = hashUtil.sm3HashByInputStream(inputStream);
        } else {
            return null;
        }
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        byte[] tsRequest = tsUtil.createTimeStampRequestByHashedData(hashBytes, this.m_Iinitmodel, isAttachCert);
        return tsRequest;
    }

    public int verifyTimeStampByLargebinary(byte[] timeStamp, byte[] inData) throws TsException, IOException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certUtil = new CertificateUtil(this.applicationName);
        ArrayList timeStampInfoList = tsUtil.getTimeStampInfo(timeStamp, this.m_Iinitmodel);
        String base64OriHash = (String)timeStampInfoList.get(1);
        String cert = (String)timeStampInfoList.get(2);
        String algType = certUtil.BJC_GetBasicCertInfo(this.m_signCertBytes, 31L);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inData);
        HashUtil hashUtil = new HashUtil(this.applicationName);
        byte[] hashBytes = null;
        if ("RSA".equals(algType)) {
            hashBytes = hashUtil.hashByInputStream(inputStream);
        } else if ("ECC".equals(algType)) {
            hashBytes = hashUtil.sm3HashByInputStream(inputStream);
        } else {
            return -1;
        }
        String hashStr = base64Util.BJS_EncodeBase64(hashBytes);
        if (!base64OriHash.equals(hashStr)) {
            return -2;
        }
        String base64TimeStamp = base64Util.BJS_EncodeBase64(timeStamp);
        int verifyCertRes = this.verifyTimeCert(base64TimeStamp);
        if (verifyCertRes != 1) {
            return verifyCertRes;
        }
        boolean isTimeStampPass = false;
        isTimeStampPass = cert == null || cert.equals("") ? tsUtil.verifyTimeStamp(timeStamp, this.m_signCertBytes, this.m_Iinitmodel) : tsUtil.verifyTimeStamp(timeStamp, base64Util.BJS_DecodeBase64(cert), this.m_Iinitmodel);
        if (isTimeStampPass) {
            return 1;
        }
        return -1;
    }

    public byte[] generatP7CounterSignYbq(byte[] inData, String oids) throws Pkcs7SignException, Pkcs7DecodeException, HashException, IOException, SecurityException, GeneralSecurityException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        byte[] encryptDigest = pkcs7Util.getP7SignDataInfoR(inData);
        byte[] hashedContent = this.hash_byte(encryptDigest, null);
        byte[] counterSignData = pkcs7Util.signAttributeP7Ybq(hashedContent, oids, this.m_Iinitmodel, this.m_signCertBytes, this.m_keyType, this.m_container, this.privateKey, this.privateKeyByte);
        return counterSignData;
    }

    public String verifyP7CounterSignYbq(byte[] p7SignData, byte[] counterSignData) throws Pkcs7DecodeException, CertificateException, Base64Exception, ValidateCertException, GetCertInfoException, HashException, IOException, ParseException, Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] encryptDigest = pkcs7Util.getP7SignDataInfoR(p7SignData);
        byte[] hashedContent = this.hash_byte(encryptDigest, null);
        String base64CounterSign = base64Util.BJS_EncodeBase64(counterSignData);
        String veryRet = pkcs7Util.BJE_Pkcs7TsVerify_byHash_reCert(hashedContent, base64CounterSign);
        return veryRet;
    }

    public byte[] getOriDateByTsRequest(byte[] tsRequest) throws TsException {
        TimeStampUtil tsUtil = new TimeStampUtil(this.applicationName);
        byte[] oriData = tsUtil.getOriDateByTsRequest(tsRequest, this.m_Iinitmodel);
        return oriData;
    }

    public Object[] generatorKeyPairForDZHT(int type, int length) throws IOException, ParameterNotSupportException {
        Object[] objs = null;
        KeyPairUtil keyPairUtil = new KeyPairUtil(this.applicationName);
        if (type == 0) {
            if (length != 1024 && length != 2048 && length != 4096) {
                throw new ParameterNotSupportException("key length " + length + " is not supported!");
            }
            keyPairUtil.generatorKeyPair(length);
            objs = new Object[2];
            byte[] realPrivateKeyObjByte = keyPairUtil.getPrivateKey().getEncoded();
            byte[] tmpPri = new byte[realPrivateKeyObjByte.length];
            for (int i = 0; i < realPrivateKeyObjByte.length; ++i) {
                byte rr = realPrivateKeyObjByte[i];
                int tmp = rr ^ 0xFF;
                tmpPri[i] = (byte)tmp;
            }
            if (!X9ObjectIdentifiers.id_ecPublicKey.equals(this.strcSignCert.getSubjectPublicKeyInfo().getAlgorithmId().getObjectId())) {
                throw new ParameterNotSupportException("The Default application " + this.applicationName + "is not SM2 application!");
            }
            byte[] enPri = null;
            try {
                WrapCard wCard = new WrapCard();
                enPri = wCard.sm2Encrypt(this.strcSignCert, tmpPri);
            }
            catch (Exception e) {
                throw new ParameterNotSupportException("sm2Encrypt fail! tmpPri is = " + Arrays.toString(tmpPri));
            }
            byte[] pubicKeyObjByte = keyPairUtil.getPublicKey().getEncoded();
            objs[0] = pubicKeyObjByte;
            objs[1] = enPri;
        } else if (type == 1) {
            objs = new Object[2];
            DeviceKeyPair generatorKeyPair_sm2 = keyPairUtil.generatorKeyPair_sm2();
            byte[] realPrivateKeyObjByte = generatorKeyPair_sm2.getPrivateKey();
            byte[] tmpPri = new byte[realPrivateKeyObjByte.length];
            for (int i = 0; i < realPrivateKeyObjByte.length; ++i) {
                byte rr = realPrivateKeyObjByte[i];
                int tmp = rr ^ 0xFF;
                tmpPri[i] = (byte)tmp;
            }
            WrapCard wCard = new WrapCard();
            byte[] enPri = wCard.sm2Encrypt(this.strcSignCert, tmpPri);
            objs[0] = generatorKeyPair_sm2.getPublicKey();
            objs[1] = enPri;
        } else {
            throw new ParameterNotSupportException("type " + type + "is not supported!");
        }
        return objs;
    }

    public byte[] decryptPriForDZHT(byte[] enPri) throws IOException {
        byte[] deTmpPri = null;
        try {
            WrapCard wCard = new WrapCard();
            deTmpPri = wCard.sm2Decrypt(this.privateKeyByte, enPri);
        }
        catch (Exception e) {
            this.errorlog("Exception in sm2 decrypt !", e);
            return null;
        }
        byte[] realPri = new byte[deTmpPri.length];
        for (int i = 0; i < deTmpPri.length; ++i) {
            byte rr = deTmpPri[i];
            int tmp = rr ^ 0xFF;
            realPri[i] = (byte)tmp;
        }
        return realPri;
    }
}

