/*
 * Decompiled with CFR 0.152.
 */
package xjyb.bjca.org.multi.util.log;

import xjyb.bjca.org.apache.log4j.Layout;
import xjyb.bjca.org.apache.log4j.Level;
import xjyb.bjca.org.apache.log4j.Logger;
import xjyb.bjca.org.apache.log4j.PatternLayout;
import xjyb.bjca.org.apache.log4j.RollingFileAppender;
import xjyb.bjca.org.multi.util.exceptions.LoggerException;
import xjyb.bjca.org.multi.util.log.AbstractLogger;
import xjyb.bjca.org.multi.util.log.LoggerRes;

public class DebugLogger
extends AbstractLogger {
    public DebugLogger(LoggerRes res) throws LoggerException {
        this.createDebuglogger(res);
    }

    public void Log(String msg) {
        this.logger.debug(msg);
    }

    private void createDebuglogger(LoggerRes loggerres) throws LoggerException {
        if (loggerres.IsUseRemoteLogger()) {
            throw new LoggerException("Now We Can not Implement The Remote Logger");
        }
        this.logger = Logger.getLogger(loggerres.getLoggerName());
        this.logger.removeAllAppenders();
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern("%-5p  [%d{yyyy-MM-dd HH:mm:ss S}] %t %m%n");
        RollingFileAppender da = null;
        try {
            da = new RollingFileAppender((Layout)layout, loggerres.getLogFile());
            da.setMaxBackupIndex(loggerres.getMaxBackUpIndex());
            da.setMaxFileSize(loggerres.getMaxFileSize());
            this.logger.addAppender(da);
            this.logger.setLevel(Level.DEBUG);
        }
        catch (Exception ex) {
            throw new LoggerException(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        LoggerRes res = new LoggerRes();
        res.setLogFile("c:/debug.log");
        res.setMaxFileSize("1kb");
        res.setLoggerName("debug");
        res.setMaxBackupIndex(3);
        res.setMaxFileSize("1kb");
        res.setHeader("#hytest");
        DebugLogger logger = new DebugLogger(res);
        int i = 0;
        while (i < 500) {
            logger.Log("Sign  ok");
            ++i;
        }
        LoggerRes res2 = new LoggerRes();
        res2.setLogFile("c:/debug2.log");
        res2.setMaxFileSize("1kb");
        res2.setLoggerName("debug2");
        res2.setMaxBackupIndex(3);
        res2.setMaxFileSize("1kb");
        res2.setHeader("#hytest");
        DebugLogger logger2 = new DebugLogger(res2);
        int i2 = 0;
        while (i2 < 500) {
            logger2.Log("Sign  ok");
            ++i2;
        }
    }
}

