/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.crypto.xmss;

import cn.org.bjca.gaia.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.gaia.crypto.KeyGenerationParameters;
import cn.org.bjca.gaia.pqc.crypto.xmss.BDS;
import cn.org.bjca.gaia.pqc.crypto.xmss.BDSStateMap;
import cn.org.bjca.gaia.pqc.crypto.xmss.OTSHashAddress;
import cn.org.bjca.gaia.pqc.crypto.xmss.XMSSMTKeyGenerationParameters;
import cn.org.bjca.gaia.pqc.crypto.xmss.XMSSMTParameters;
import cn.org.bjca.gaia.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.xmss.XMSSNode;
import cn.org.bjca.gaia.pqc.crypto.xmss.XMSSParameters;
import java.security.SecureRandom;

public final class XMSSMTKeyPairGenerator {
    private XMSSMTParameters params;
    private XMSSParameters xmssParams;
    private SecureRandom prng;

    public void init(KeyGenerationParameters param) {
        XMSSMTKeyGenerationParameters parameters = (XMSSMTKeyGenerationParameters)param;
        this.prng = parameters.getRandom();
        this.params = parameters.getParameters();
        this.xmssParams = this.params.getXMSSParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        XMSSMTPrivateKeyParameters privateKey = this.generatePrivateKey(new XMSSMTPrivateKeyParameters.Builder(this.params).build().getBDSState());
        this.xmssParams.getWOTSPlus().importKeys(new byte[this.params.getDigestSize()], privateKey.getPublicSeed());
        int rootLayerIndex = this.params.getLayers() - 1;
        OTSHashAddress otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(rootLayerIndex)).build();
        BDS bdsRoot = new BDS(this.xmssParams, privateKey.getPublicSeed(), privateKey.getSecretKeySeed(), otsHashAddress);
        XMSSNode root = bdsRoot.getRoot();
        privateKey.getBDSState().put(rootLayerIndex, bdsRoot);
        privateKey = new XMSSMTPrivateKeyParameters.Builder(this.params).withSecretKeySeed(privateKey.getSecretKeySeed()).withSecretKeyPRF(privateKey.getSecretKeyPRF()).withPublicSeed(privateKey.getPublicSeed()).withRoot(root.getValue()).withBDSState(privateKey.getBDSState()).build();
        XMSSMTPublicKeyParameters publicKey = new XMSSMTPublicKeyParameters.Builder(this.params).withRoot(root.getValue()).withPublicSeed(privateKey.getPublicSeed()).build();
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }

    private XMSSMTPrivateKeyParameters generatePrivateKey(BDSStateMap bdsState) {
        int n = this.params.getDigestSize();
        byte[] secretKeySeed = new byte[n];
        this.prng.nextBytes(secretKeySeed);
        byte[] secretKeyPRF = new byte[n];
        this.prng.nextBytes(secretKeyPRF);
        byte[] publicSeed = new byte[n];
        this.prng.nextBytes(publicSeed);
        XMSSMTPrivateKeyParameters privateKey = null;
        privateKey = new XMSSMTPrivateKeyParameters.Builder(this.params).withSecretKeySeed(secretKeySeed).withSecretKeyPRF(secretKeyPRF).withPublicSeed(publicSeed).withBDSState(bdsState).build();
        return privateKey;
    }
}

