/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.cmp.PKIStatus;
import cn.org.bjca.gaia.asn1.cmp.PKIStatusInfo;
import cn.org.bjca.gaia.asn1.cms.ContentInfo;
import cn.org.bjca.gaia.asn1.tsp.TimeStampResp;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.cert.BjcaCert;
import cn.org.bjca.gaia.assemb.constant.AlgConstant;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.generator.TsGenerator;
import cn.org.bjca.gaia.assemb.generator.TsReqGenerator;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.param.SM3Param;
import cn.org.bjca.gaia.assemb.structure.BjcaTimeStamp;
import cn.org.bjca.gaia.assemb.util.ASN1Util;
import cn.org.bjca.gaia.tsp.TSPAlgorithms;
import cn.org.bjca.gaia.tsp.TimeStampRequest;
import cn.org.bjca.gaia.tsp.TimeStampRequestGenerator;
import cn.org.bjca.gaia.util.Arrays;
import cn.org.bjca.gaia.util.encoders.Base64;
import java.math.BigInteger;
import java.util.Date;

public class TimeStampUtil {
    private GaiaProvider provider = null;

    public TimeStampUtil(GaiaProvider provider) {
        this.provider = provider;
    }

    public byte[] createTsReq(AlgPolicy algPolicy, byte[] oriData, boolean isAttachCert) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("SHA1") || policyType.equals("SHA256") || policyType.equals("SM3"))) {
            throw new PkiException("11014001", "\u4ea7\u751f\u65f6\u95f4\u6233\u8bf7\u6c42\u5931\u8d25\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        byte[] hash = this.provider.hash(algPolicy, oriData);
        return this.createTsReqByHash(algPolicy, hash, isAttachCert);
    }

    public byte[] createTsReqByHash(AlgPolicy algPolicy, byte[] hash, boolean isAttachCert) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("SHA1") || policyType.equals("SHA256") || policyType.equals("SM3"))) {
            throw new PkiException("11014001", "\u4ea7\u751f\u65f6\u95f4\u6233\u8bf7\u6c42\u5931\u8d25\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        ASN1ObjectIdentifier digestAlgorithm = null;
        if (policyType.equals("SHA1")) {
            digestAlgorithm = TSPAlgorithms.SHA1;
        } else if (policyType.equals("SHA256")) {
            digestAlgorithm = TSPAlgorithms.SHA256;
        } else if (policyType.equals("SM3")) {
            digestAlgorithm = TSPAlgorithms.SM3;
        }
        byte[] req = null;
        if (policyType.equals("SM3")) {
            TsReqGenerator tsReqGenerator = new TsReqGenerator();
            try {
                req = tsReqGenerator.generate(digestAlgorithm, hash, isAttachCert);
            }
            catch (Exception e) {
                throw new PkiException("11014001", "\u4ea7\u751f\u65f6\u95f4\u6233\u8bf7\u6c42\u5931\u8d25 " + policyType, e);
            }
        }
        TimeStampRequestGenerator localTimeStampRequestGenerator = new TimeStampRequestGenerator();
        localTimeStampRequestGenerator.setCertReq(isAttachCert);
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        try {
            TimeStampRequest localTimeStampRequest = localTimeStampRequestGenerator.generate(digestAlgorithm, hash, nonce);
            req = localTimeStampRequest.getEncoded();
        }
        catch (Exception e) {
            throw new PkiException("11014001", "\u4ea7\u751f\u65f6\u95f4\u6233\u8bf7\u6c42\u5931\u8d25 " + policyType, e);
        }
        return req;
    }

    public byte[] createTsResp(AlgPolicy algPolicy, BjcaKey bjcaKey, byte[] tsReq, String tsCert) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("SM3WithSM2") || policyType.equals("SHA256WithRSA") || policyType.equals("SHA1WithRSA"))) {
            throw new PkiException("11014002", "\u6839\u636e\u65f6\u95f4\u6233\u8bf7\u6c42\u4ea7\u751f\u65f6\u95f4\u6233\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        byte[] ts = null;
        try {
            TimeStampRequest timeStampRequest = null;
            if (policyType.equals("SM3WithSM2")) {
                TsReqGenerator tsReqGenerator = new TsReqGenerator();
                timeStampRequest = tsReqGenerator.convertReqToStandardReq(tsReq);
            } else {
                timeStampRequest = new TimeStampRequest(tsReq);
            }
            String reqHashAlg = AlgConstant.convertOidToAlgName(timeStampRequest.getMessageImprintAlgOID());
            String policyAlg = AlgConstant.convertSignAlgToHashAlg(policyType);
            if (!reqHashAlg.equals(policyAlg)) {
                throw new PkiException("11014002", "\u6839\u636e\u65f6\u95f4\u6233\u8bf7\u6c42\u4ea7\u751f\u65f6\u95f4\u6233\u5931\u8d25 \u8bf7\u6c42\u4e2d\u6458\u8981\u7b97\u6cd5\u4e0e\u7b56\u7565\u4e2d\u4f20\u5165\u6458\u8981\u7b97\u6cd5\u4e0d\u4e00\u81f4\uff0cpolicy hashAlg =" + policyAlg + ", req hashAlg = " + reqHashAlg);
            }
            byte[] signCertBytes = Base64.decode(tsCert);
            ASN1Object signCertPkcs = ASN1Util.checkAndGetASN1Object(signCertBytes);
            Certificate signCertOb = Certificate.getInstance(signCertPkcs);
            Certificate[] certs = new Certificate[]{signCertOb};
            TsGenerator tsGenerator = new TsGenerator(timeStampRequest, certs);
            byte[] timeStampInfo = tsGenerator.getTimeStampInfo();
            String hashAlg = AlgConstant.convertSignAlgToHashAlg(algPolicy.getPolicyType());
            AlgPolicy hashPolicy = new AlgPolicy(hashAlg);
            byte[] tstHash = this.provider.hash(hashPolicy, timeStampInfo);
            AlgPolicy certPolicy = new AlgPolicy("SHA1");
            byte[] certHash = this.provider.hash(certPolicy, signCertBytes);
            byte[] attrBytes = tsGenerator.assembAttr(tstHash, certHash);
            if (hashAlg.equals("SM3")) {
                BjcaCert bjcaCert = new BjcaCert(signCertBytes);
                SM3Param sm3Param = new SM3Param(bjcaCert.getPublicKeyData());
                hashPolicy.setParam(sm3Param);
            }
            byte[] attrHash = this.provider.hash(hashPolicy, attrBytes);
            byte[] signValue = this.provider.signHashedData(algPolicy, attrHash, bjcaKey);
            ts = tsGenerator.getEncoded(signValue);
        }
        catch (Exception e) {
            throw new PkiException("11014002", "\u6839\u636e\u65f6\u95f4\u6233\u8bf7\u6c42\u4ea7\u751f\u65f6\u95f4\u6233\u5931\u8d25 " + policyType, e);
        }
        return ts;
    }

    public byte[] createTsRespCMS(AlgPolicy algPolicy, BjcaKey bjcaKey, byte[] tsReq, String tsCert) throws PkiException {
        byte[] ts;
        try {
            ts = this.createTsResp(algPolicy, bjcaKey, tsReq, tsCert);
            PKIStatusInfo pkiStatusInfo = new PKIStatusInfo(PKIStatus.granted);
            ts = new TimeStampResp(pkiStatusInfo, new ContentInfo(ASN1Sequence.getInstance(ts))).getEncoded("DER");
        }
        catch (PkiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PkiException("11014002", "\u6839\u636e\u65f6\u95f4\u6233\u8bf7\u6c42\u4ea7\u751f\u65f6\u95f4\u6233\u5931\u8d25 " + algPolicy.getPolicyType(), e);
        }
        return ts;
    }

    public int verifyCMSTs(byte[] inputData, byte[] timeStamp, String cert) throws PkiException {
        try {
            TimeStampResp timeStampResp = TimeStampResp.getInstance(timeStamp);
            timeStamp = timeStampResp.getTimeStampToken().getEncoded("DER");
            return this.verifyTs(inputData, timeStamp, cert);
        }
        catch (PkiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PkiException("11014004", "\u9a8c\u8bc1\u65f6\u95f4\u6233\u5931\u8d25", e);
        }
    }

    public int verifyTs(byte[] inputData, byte[] timeStamp, String cert) throws PkiException {
        BjcaTimeStamp bjcaTimeStamp = this.parseTsStructure(timeStamp);
        byte[] certFromTs = bjcaTimeStamp.getSignCert();
        byte[] signCert = null;
        if (certFromTs == null) {
            if (cert == null) {
                throw new PkiException("11014004", "\u9a8c\u8bc1\u65f6\u95f4\u6233\u5931\u8d25, verify timeStamp fail, need a signCert!");
            }
            signCert = Base64.decode(cert);
        } else {
            signCert = certFromTs;
        }
        byte[] attri = bjcaTimeStamp.getAttribute();
        byte[] signValue = bjcaTimeStamp.getSignValue();
        byte[] hashFromTst = bjcaTimeStamp.getHashFromTst();
        String hashAlg = bjcaTimeStamp.getHashAlg();
        AlgPolicy algPolicy = new AlgPolicy(hashAlg);
        byte[] oriHash = this.provider.hash(algPolicy, inputData);
        if (!Arrays.areEqual(oriHash, hashFromTst)) {
            return -2;
        }
        BjcaCert bjcaCert = new BjcaCert(signCert);
        if (hashAlg.equals("SM3")) {
            SM3Param sm3Param = new SM3Param(bjcaCert.getPublicKeyData());
            algPolicy.setParam(sm3Param);
        }
        byte[] hash = this.provider.hash(algPolicy, attri);
        String toSignAlg = AlgConstant.convertHashAlgToSignAlg(hashAlg);
        AlgPolicy tsPolicy = new AlgPolicy(toSignAlg);
        boolean verifySignHashedData = this.provider.verifySignHashedData(tsPolicy, hash, signValue, bjcaCert.getPublicKey());
        if (!verifySignHashedData) {
            return -1;
        }
        Date signTime = bjcaTimeStamp.getSignTime();
        Date notBefore = bjcaCert.getNotBefore();
        Date notAfter = bjcaCert.getNotAfter();
        if (signTime.before(notBefore)) {
            return -3;
        }
        if (signTime.after(notAfter)) {
            return -4;
        }
        return 1;
    }

    public int verifyCMSTsByHash(byte[] inputData, byte[] timeStamp, String cert) throws PkiException {
        try {
            TimeStampResp timeStampResp = TimeStampResp.getInstance(timeStamp);
            timeStamp = timeStampResp.getTimeStampToken().getEncoded("DER");
            return this.verifyTsByHash(inputData, timeStamp, cert);
        }
        catch (PkiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PkiException("11014004", "\u9a8c\u8bc1\u65f6\u95f4\u6233\u5931\u8d25", e);
        }
    }

    public int verifyTsByHash(byte[] hash, byte[] timeStamp, String cert) throws PkiException {
        BjcaTimeStamp bjcaTimeStamp = this.parseTsStructure(timeStamp);
        byte[] certFromTs = bjcaTimeStamp.getSignCert();
        byte[] signCert = null;
        if (certFromTs == null) {
            if (cert == null) {
                throw new PkiException("11014004", "\u9a8c\u8bc1\u65f6\u95f4\u6233\u5931\u8d25, verify timeStamp fail, need a signCert!");
            }
            signCert = Base64.decode(cert);
        } else {
            signCert = certFromTs;
        }
        byte[] attri = bjcaTimeStamp.getAttribute();
        byte[] signValue = bjcaTimeStamp.getSignValue();
        byte[] hashFromTst = bjcaTimeStamp.getHashFromTst();
        String hashAlg = bjcaTimeStamp.getHashAlg();
        AlgPolicy algPolicy = new AlgPolicy(hashAlg);
        if (!Arrays.areEqual(hash, hashFromTst)) {
            return -2;
        }
        BjcaCert bjcaCert = new BjcaCert(signCert);
        if (hashAlg.equals("SM3")) {
            SM3Param sm3Param = new SM3Param(bjcaCert.getPublicKeyData());
            algPolicy.setParam(sm3Param);
        }
        byte[] attriHash = this.provider.hash(algPolicy, attri);
        String toSignAlg = AlgConstant.convertHashAlgToSignAlg(hashAlg);
        AlgPolicy tsPolicy = new AlgPolicy(toSignAlg);
        boolean verifySignHashedData = this.provider.verifySignHashedData(tsPolicy, attriHash, signValue, bjcaCert.getPublicKey());
        if (!verifySignHashedData) {
            return -1;
        }
        Date signTime = bjcaTimeStamp.getSignTime();
        Date notBefore = bjcaCert.getNotBefore();
        Date notAfter = bjcaCert.getNotAfter();
        if (signTime.before(notBefore)) {
            return -3;
        }
        if (signTime.after(notAfter)) {
            return -4;
        }
        return 1;
    }

    public BjcaTimeStamp parseTsStructure(byte[] timeStamp) throws PkiException {
        BjcaTimeStamp bjcaTimeStamp = new BjcaTimeStamp(timeStamp);
        return bjcaTimeStamp;
    }
}

