/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.x9.ECNamedCurveTable;
import cn.org.bjca.gaia.asn1.x9.X9ECParameters;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.SM3Param;
import cn.org.bjca.gaia.assemb.util.KeyPairUtil;
import cn.org.bjca.gaia.crypto.digests.SM3Digest;
import cn.org.bjca.gaia.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.MessageDigest;

public class HashUtil {
    private String policyType = null;
    private MessageDigest md = null;
    private SM3Digest sm3 = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HashUtil(AlgPolicy algPolicy) throws PkiException {
        this.policyType = algPolicy.getPolicyType();
        if (!(this.policyType.equals("SM3") || this.policyType.equals("SHA1") || this.policyType.equals("SHA256"))) {
            throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + this.policyType);
        }
        if ("SHA256".equals(this.policyType) || "SHA1".equals(this.policyType)) {
            try {
                this.md = MessageDigest.getInstance(this.policyType);
                return;
            }
            catch (Exception e) {
                throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        if (!"SM3".equals(this.policyType)) throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + this.policyType);
        try {
            this.sm3 = new SM3Digest();
            if (algPolicy.getParam() == null) return;
            SM3Param sm3Param = (SM3Param)algPolicy.getParam();
            byte[] publicKey = sm3Param.getPubKey();
            byte[] id = sm3Param.getId();
            byte[] derPub = KeyPairUtil.getDerPublickey(publicKey);
            X9ECParameters x9 = ECNamedCurveTable.getByName("sm2p256v1");
            ECPoint publicPoint = x9.getCurve().decodePoint(derPub);
            BigInteger affineX = publicPoint.getXCoord().toBigInteger();
            BigInteger affineY = publicPoint.getYCoord().toBigInteger();
            this.sm3.addId(affineX, affineY, id);
            return;
        }
        catch (Exception e) {
            throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public byte[] hash(byte[] dataInput) {
        byte[] retHash = null;
        if ("SHA256".equals(this.policyType) || "SHA1".equals(this.policyType)) {
            retHash = this.md.digest(dataInput);
        } else if ("SM3".equals(this.policyType)) {
            this.sm3.update(dataInput, 0, dataInput.length);
            this.sm3.doFinal(retHash, 0);
        }
        return retHash;
    }

    public void update(byte[] buffer) {
        if ("SHA256".equals(this.policyType) || "SHA1".equals(this.policyType)) {
            this.md.update(buffer, 0, buffer.length);
        } else if ("SM3".equals(this.policyType)) {
            this.sm3.update(buffer, 0, buffer.length);
        }
    }

    public byte[] doFinal() {
        byte[] retHash = null;
        if ("SHA256".equals(this.policyType) || "SHA1".equals(this.policyType)) {
            retHash = this.md.digest();
        } else if ("SM3".equals(this.policyType)) {
            retHash = new byte[32];
            this.sm3.doFinal(retHash, 0);
        }
        return retHash;
    }
}

