/*
 * Decompiled with CFR 0.152.
 */
package api.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.apache.commons.compress.utils.IOUtils;

public class FileTool {
    private static Logger log = Logger.getLogger(FileTool.class.toString());

    public static String ReadFileToString(String FileName) {
        return FileTool.ReadFileToString(FileName, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ReadFileToString(String FileName, String encoding) {
        FileInputStream FS = null;
        try {
            String ss;
            FS = new FileInputStream(FileName);
            int size = FS.available();
            byte[] pp = new byte[size];
            FS.read(pp, 0, size);
            String string = ss = new String(pp, encoding);
            return string;
        }
        catch (IOException e) {
            log.info(e.toString());
        }
        finally {
            if (null != FS) {
                FileTool.safeCloseFileInputStream(FS);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean WriteStringToFile(String DataToWrite, String FileName, String encoding) {
        FileOutputStream FS = null;
        try {
            FS = new FileOutputStream(FileName);
            byte[] pp = null;
            pp = DataToWrite.getBytes();
            FS.write(pp);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.info(e.toString());
        }
        finally {
            if (null != FS) {
                FileTool.safeCloseFileOutputStream(FS);
            }
        }
        return false;
    }

    public static boolean WriteStringToFile(String DataToWrite, String FileName) {
        return FileTool.WriteStringToFile(DataToWrite, FileName, null);
    }

    public static boolean isDirExist(String dir) {
        File FF = new File(dir);
        return FF.exists() && FF.isDirectory();
    }

    public static void createFolder(String folderPath) {
        try {
            File myFilePath = new File(folderPath);
            if (!myFilePath.exists()) {
                myFilePath.mkdirs();
            }
        }
        catch (Exception e) {
            log.info("\u521b\u5efa\u76ee\u5f55\u64cd\u4f5c\u51fa\u9519" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveTo(InputStream is, File destFile) throws IOException {
        if (is == null) {
            return false;
        }
        File f = new File(destFile.getParent());
        if (!f.exists()) {
            f.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(destFile);){
            IOUtils.copy(is, fos);
        }
        return true;
    }

    public static boolean saveTo(InputStream is, String filename) throws IOException {
        File f = new File(filename);
        return FileTool.saveTo(is, f);
    }

    public static void safeCloseFileOutputStream(FileOutputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                log.info(e.toString());
            }
        }
    }

    public static void safeCloseFileInputStream(FileInputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                log.info(e.toString());
            }
        }
    }
}

