/*
 * Decompiled with CFR 0.152.
 */
package api;

import api.VoucherFileInfo;
import api.loader.OFDLoader;
import api.tools.PDFTool;
import com.alibaba.fastjson.JSONObject;
import com.pansoft.xbrl.xbrljson.convert.DomToJson;
import com.pansoft.xbrl.xbrljson.convert.JsonToXbrl;
import com.pansoft.xbrl.xbrljson.convert.XbrlToJson;
import com.pansoft.xbrl.xbrljson.util.PropUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VoucherFileUtil {
    private static Log log = LogFactory.getLog(VoucherFileUtil.class);
    private static String DEFAULT_ISSUER_XBRL_FILENAME = "voucher_issuer.xbrl";

    public static VoucherFileInfo extractXBRLFromOFD(String ofdFilePath) throws Exception {
        return VoucherFileUtil.extractXBRLFromOFD(ofdFilePath, "");
    }

    public static VoucherFileInfo extractXBRLFromOFD(String ofdFilePath, String outputFile) throws Exception {
        VoucherFileInfo voucherFileInfo = new OFDLoader().extractAttach(ofdFilePath, outputFile);
        return voucherFileInfo;
    }

    public static VoucherFileInfo extractXBRLFromPDF(String pdfFilePath) {
        return VoucherFileUtil.extractXBRLFromPDF(pdfFilePath, "");
    }

    public static VoucherFileInfo extractXBRLFromPDF(String pdfFilePath, String outputFile) {
        return PDFTool.extractXBRLFileFromPDF(pdfFilePath, DEFAULT_ISSUER_XBRL_FILENAME, outputFile);
    }

    public static JSONObject extractJSONFromOFD(String ofdFilePath) throws Exception {
        String xmlValue = null;
        xmlValue = new OFDLoader().extractOriginalXML(ofdFilePath);
        return VoucherFileUtil.xml2Json(xmlValue);
    }

    public static JSONObject xbrl2Json(String xbrlXml, String configId) {
        return new XbrlToJson().convertXbrlJsonData(xbrlXml, configId);
    }

    public static String json2Xbrl(String jsonValue, String configId) throws Exception {
        return new JsonToXbrl().convertXbrlXml(jsonValue, configId);
    }

    public static JSONObject xml2Json(String xmlValue) {
        return new DomToJson().convertXmlJsonData(xmlValue);
    }

    public static void main(String[] args) throws Exception {
        VoucherFileInfo voucherFileInfo = VoucherFileUtil.extractXBRLFromOFD("D:\\\u535a\u601d\\\u7535\u5b50\u51ed\u8bc1\u6837\u4f8b\u548c\u9a8c\u7b7e\u65b9\u68481.2\\\u7535\u5b50\u53d1\u7968\uff08\u94c1\u8def\u7535\u5b50\u5ba2\u7968\uff09\u76f8\u5173\\\u6837\u4f8b\\\u552e\u7968\u6362\u5f00\u6837\u4f8b.ofd", "D:\\1\\1.txt");
        System.out.println(JSONObject.toJSONString(voucherFileInfo));
    }

    static {
        PropUtil.initFileMap("VoucherType");
    }
}

